// Index view (in form of jQuery widget).
(function($, UTILS) {

    $.widget('adsk.indexscrollertabview', {
		options: {
			caption: "Index",
            data:undefined,
            prevItemTopScope:undefined,
            prevItemBottomScope:undefined,
            previousIndexScrollerBigLetter:undefined
		},

        _create: function() {
            console.log('indextabview: _create');
			// Render view.
			this._render();

//            this.testVar = $('#navigation > .toolbar > .center');

            // Handle UI events.
		},
		
		_render: function() {
            console.log('indextabview: _render');
			// Create markup.
            this._initIndexContent();
            this._initIndexScroller();
		},

        _initIndexContent:function () {
            console.log('indextabview: _initIndexContent');
        },

        _initIndexScroller:function () {
            console.log('indextabview: _initIndexScroller');
        },

        initIndexABCScroller:function (indexData) {
            console.log('indextabview: _initIndexScroller');
            this.indexABC = $(document.createElement('div'))
                .attr('id', 'index-abc')
                .addClass('index-abc')
                .appendTo(this.element);
            var index_scroller = $(document.createElement('ul')).addClass('index-abc-list');
            var data = indexData.data;
            for (var l in data) {
                var letter = data[l];
                var letter_item = $(document.createElement('li')).addClass('index-abc-item');
                var small_letter = $(document.createElement('div')).addClass('index-scroller-letter').html(letter.l).appendTo(letter_item);
                letter_item.appendTo(index_scroller);
            }
            this.big_letter = $(document.createElement('div')).addClass('index-scroller-big-letter');
            $([this.big_letter.get(0), index_scroller.get(0)]).appendTo(this.indexABC);
        },

        initEventHandlers:function () {
            var $element = this.indexABC;
            console.log('indextabview: _initEventHandlers');

            var self = this;
            var ABCElem = document.getElementById($element.attr('id'));
            var ABCElemLeftScope = ABCElem.offsetLeft;
            var ABCElemTopScope = ABCElem.offsetTop;
            var ABCElemBottomScope = ABCElemTopScope + ABCElem.offsetHeight - 2;
            var ABCList = ABCElem.getElementsByTagName('ul')[0];
            var ABCListLeftScope = ABCList.offsetLeft;
            var ABCListWidth = ABCList.offsetWidth;
            var ABCListCenter = Math.floor(ABCElemLeftScope + ABCListLeftScope + (ABCListWidth / 2));
//            this.testVar.text(ABCElemLeftScope + '  '+ABCElemTopScope);

            var indexContent = $('#tab-index > .index-content');

            ABCElem.addEventListener('touchstart', function (event) {
                event.preventDefault();
                if(navigator.userAgent.match(/Android/i)){
                    indexContent.css({overflow:'hidden'});
                }
                if (event.targetTouches.length == 1) {
                    var touch = event.targetTouches[0];
                    var xPos = touch.clientX;
                    var yPos = touch.clientY;

                    if (xPos >= ABCElemLeftScope) {
                        var $ABCScroller = $(this.children[1]);
                        self.options.prevItemTopScope = undefined;
                        self.options.prevItemBottomScope = undefined;
                        $ABCScroller.addClass('touched');
                    }
                    if (yPos <= ABCElemBottomScope) {
                        self._scrollIndex(event, ABCListCenter, yPos);
                    }
                }
            }, false);

            ABCElem.addEventListener('touchend', function (event) {
                var $bigLetterElem = $(this.children[0]);
                var $ABCScroller = $(this.children[1]);
                $bigLetterElem.removeClass('displayed');
                $ABCScroller.removeClass('touched');
                if(navigator.userAgent.match(/Android/i)){
                    indexContent.css({overflow:''});
                }
            }, false);

            ABCElem.addEventListener('touchmove', function (event) {
                event.stopPropagation();
                if (event.targetTouches.length == 1) {
                    var touch = event.targetTouches[0];
                    var xPos = touch.clientX;
                    var yPosition = touch.clientY;
                    var currentListItem = document.elementFromPoint(ABCListCenter, yPosition);
                    if (xPos >= ABCElemLeftScope && yPosition <= ABCElemBottomScope) {
                        var currentListItemBottomScope = ABCElemTopScope + currentListItem.offsetTop + currentListItem.offsetHeight;
                        var currentListItemTopScope = ABCElemTopScope + currentListItem.offsetTop;
                        if (currentListItemBottomScope != self.options.prevItemBottomScope && currentListItemTopScope != self.options.prevItemTopScope) {
                            self.options.prevItemTopScope = currentListItemTopScope;
                            self.options.prevItemBottomScope = currentListItemBottomScope;
                            self._scrollIndex(event, ABCListCenter, yPosition);
                        }
                    }
                }
            }, false);

            this.element.on('touchmove', $.proxy(function(event) {
                // Prevent bubbling to enable native scrolling.
                event.stopPropagation();
            }, this));

        },

        _scrollIndex:function (event, xPos, yPos) {
            console.log('indextabview: _scrollIndex');

            var scrollerElement = document.elementFromPoint(xPos, yPos);
//            this.testVar.text(scrollerElement.className);

            if (scrollerElement.className == 'index-scroller-letter') {
                this._createBigLetter(this.big_letter, scrollerElement, xPos, yPos);
            }

            var indexElement = getIndexElement(scrollerElement);
            if (indexElement) {
                indexElement.scrollIntoView();
            }

            function getIndexElement(scrollerElement) {
                var result;
                var indexLetters = document.getElementsByClassName('index-letter-group');
                for (var i = 0; i < indexLetters.length; i++) {
                    if (indexLetters[i].innerHTML === scrollerElement.innerHTML) {
                        result = indexLetters[i];
                    }
                }
                return result
            }
        },

        _createBigLetter:function (bigLetter, elem, xPos, yPos) {
//            console.log('indextabview: _createBigLetter');

            var bigLetterHtml = $(elem).find('.index-scroller-letter').andSelf().filter('.index-scroller-letter').text();
            if (elem && bigLetterHtml !== this.options.previousIndexScrollerBigLetter) {
                bigLetter.html(bigLetterHtml).css({'position':'fixed','top':yPos-20 , 'left':xPos-70});
                this.options.previousIndexScrollerBigLetter = bigLetterHtml;
                bigLetter.addClass('displayed');
            }
        },

        changeScrollerSize:function () {
            console.log('indextabview: changeScrollerSize');

            var $elem = this.indexABC;
            var height = 380;
            var fontSize = 8;
            var elemTopPadding = 40;
            var innerHeight = window.innerHeight;
            var elemHeight = innerHeight - elemTopPadding - 10;
            var multiplier = innerHeight / height;

            var listItems = $elem[0].getElementsByClassName('index-scroller-letter');
            var listItemsLength = listItems.length;
            var listItemHeight = Math.floor(elemHeight/listItemsLength);
            for(var i = 0; i<listItemsLength; i++){
                $(listItems[i]).css({height:listItemHeight+'px', lineHeight:listItemHeight+'px'})
            }
            if (innerHeight >= height) {
                fontSize = Math.floor(fontSize * multiplier);
            }
            $elem.css({height:elemHeight,fontSize:fontSize + 'px', top:elemTopPadding});
        },

        initIndexItemList:function (indexData) {
            console.log('indextabview: initIndexItemList');

            var indexItemDiv = $(document.createElement('div')).addClass('index-item-div').appendTo(this.element);
            var data = indexData.data;
            for (var l in data) {
                var letter = data[l];
                var letter_div = $(document.createElement('div')).addClass('index-letter-group').addClass('index-item').html(letter.l);
                indexItemDiv.append(letter_div);
                this._render_children(indexItemDiv, letter.c);
            }
        },

        _render_children:function (parent, children) {
            console.log('indextabview: _render_children');

            var entriesDiv = $(document.createElement('div')).addClass('entries-div');
            for (var i in children) {
                var child = children[i];
                var grandchildren = child.c;

                var div = $(document.createElement('div')).addClass('index-entry-text').addClass('index-item');
                var link = $(document.createElement('a')).addClass('index-link').attr('href', child.f).html(child.l);
                if (grandchildren) {
                    link = link.addClass('index-caption');
                }
                div.append(link);

                if (grandchildren) {
                    var indent_div = $(document.createElement('div')).addClass('index-entry');
                    this._render_children(indent_div, grandchildren);
                    div.append(indent_div);
                }
                entriesDiv.append(div);
            }
            entriesDiv.appendTo(parent);
        }

	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIgdgYJKoZIhvcNAQcCoIIgZzCCIGMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // Tm1iq7Gt3cMRJJyBbEtPtXQSi6qAWWHeaEUNOKtYgPyg
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIVtDCCFbACAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgRHwlxCbP
// SIG // /4+wsha065LPJBiPkRxcSd7ShoEjhg0Glh4wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAftiFvqeJvysfkB5DMXJ/5djw3nsZ
// SIG // w6DWL/AgluQ/TgF08Fa6iubptSxFi10NbKTIUoVaczi+
// SIG // EnPiGv9BiyIiVtyAKhEIcr3ThgpXMYqiinQ8ENXd/PTn
// SIG // 0VvqvZiRv2pMANnUZ0XulPu45S7LHUBSapkI6cZbc7Ab
// SIG // 4P3AZ6GSyM51N1hQioyhlHvgVA8S+pioWMLFBSoLZrTO
// SIG // WTC/iLsjmtBjLuf/v06juunJxjFbKsAS+VcKKgpZMdg1
// SIG // KQn6Ox+/7wfbroljhfRmf2+NzEVFO2yFs875L1MNZCEe
// SIG // P/5md6E1sOSKHtDlFSgXws7quMJjqu29Jg3iczoLeUJ1
// SIG // wqTNKKGCE20wghNpBgorBgEEAYI3AwMBMYITWTCCE1UG
// SIG // CSqGSIb3DQEHAqCCE0YwghNCAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwggEMBgsqhkiG9w0BCRABBKCB/ASB+TCB9gIB
// SIG // AQYKKwYBBAGyMQIBATAxMA0GCWCGSAFlAwQCAQUABCC2
// SIG // ly7Ftfl0GI0rlI6o4H+/mijazG2zp9NLzZCr0QUe0QIU
// SIG // AwqUHuXKl7QiNdApPZVtga1YeF8YDzIwMjAwMjA3MTYx
// SIG // NzIwWqCBiqSBhzCBhDELMAkGA1UEBhMCR0IxGzAZBgNV
// SIG // BAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBwwH
// SIG // U2FsZm9yZDEYMBYGA1UECgwPU2VjdGlnbyBMaW1pdGVk
// SIG // MSwwKgYDVQQDDCNTZWN0aWdvIFJTQSBUaW1lIFN0YW1w
// SIG // aW5nIFNpZ25lciAjMaCCDfowggcGMIIE7qADAgECAhA9
// SIG // GjVyMBWCYzDQE3F+gkEIMA0GCSqGSIb3DQEBDAUAMH0x
// SIG // CzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1h
// SIG // bmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAWBgNV
// SIG // BAoTD1NlY3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2Vj
// SIG // dGlnbyBSU0EgVGltZSBTdGFtcGluZyBDQTAeFw0xOTA1
// SIG // MDIwMDAwMDBaFw0zMDA4MDEyMzU5NTlaMIGEMQswCQYD
// SIG // VQQGEwJHQjEbMBkGA1UECAwSR3JlYXRlciBNYW5jaGVz
// SIG // dGVyMRAwDgYDVQQHDAdTYWxmb3JkMRgwFgYDVQQKDA9T
// SIG // ZWN0aWdvIExpbWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28g
// SIG // UlNBIFRpbWUgU3RhbXBpbmcgU2lnbmVyICMxMIICIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAy1FQ/1b+
// SIG // /HhjcAGTWp4Y9DtT9gevIWz1og99HXAthHRIi5yKlQU9
// SIG // WYT5kYB5USzZirfBC5q6CorNZk8DiwG7MMqrvdvATxJe
// SIG // /ArM4kWwATiKu03n1BxUmO05WM9bwi9FmDEK+TU4uDEu
// SIG // bbQeOXLhuCq+n4yMGqVGrgsrTJn+LEv8KLkiOmYX0KpW
// SIG // iiHA85YktNCFJmu68G9kmHmmrb1c2FNrKwrWcoqFRuMN
// SIG // GAbaxntBVjabFT7xahGg92b1GNCAVWOHaGbrDnlVglyj
// SIG // 7Um4cYaekzewa6PqYmyjrpbouf2Lq8b2WVsAPFcgGC1w
// SIG // A6ec75LreaHHXex8tI9L3+td/KMg3ZI45WpROmuFnEyg
// SIG // mAhpWwbnKhnQlZOLO2uKBQkp2Nba2+Ny+lxKL3sVVoYy
// SIG // v38FCZ0tKs9Q4eZhINvHBoBcThRGvq5XcaKqbDCTHH53
// SIG // ywbpV82R9dUzchzh2spu6/MP7Hlbuyee6B7+L/K7f+nl
// SIG // 0GfruA18pCtZA4uV7SIozfosO8cWEa/j1rFQZ2nFjvV5
// SIG // 0K3/h8z4f6r5ou1h+MiNadqx9FGR62dX0WQR62TLA71J
// SIG // VTpFQxgsJWzRLwwtb/VBNSSg8mNZFl/ZpOksTtu7MRLG
// SIG // bfhbbgPcyxWPG41y7NsPFZDWEk7u4gAxJZM1b2pbpRJj
// SIG // QAGKuWmIOoi4DxkCAwEAAaOCAXgwggF0MB8GA1UdIwQY
// SIG // MBaAFBqh+GEZIA/DQXdFKI7RNV8GEgRVMB0GA1UdDgQW
// SIG // BBRvTYYH2DInniwp0tATA4CB3QWDKTAOBgNVHQ8BAf8E
// SIG // BAMCBsAwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8EDDAK
// SIG // BggrBgEFBQcDCDBABgNVHSAEOTA3MDUGDCsGAQQBsjEB
// SIG // AgEDCDAlMCMGCCsGAQUFBwIBFhdodHRwczovL3NlY3Rp
// SIG // Z28uY29tL0NQUzBEBgNVHR8EPTA7MDmgN6A1hjNodHRw
// SIG // Oi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29SU0FUaW1l
// SIG // U3RhbXBpbmdDQS5jcmwwdAYIKwYBBQUHAQEEaDBmMD8G
// SIG // CCsGAQUFBzAChjNodHRwOi8vY3J0LnNlY3RpZ28uY29t
// SIG // L1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5jcnQwIwYI
// SIG // KwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNlY3RpZ28uY29t
// SIG // MA0GCSqGSIb3DQEBDAUAA4ICAQDAaO2z2NRQm+/TdcsP
// SIG // O/ck03o3RY0s7xb7UaksH7UltYqfXQvCGyB0jWYPNsuq
// SIG // 9jYND36PS0p0Q2WsDSr2Cu1rbcUJOO0AG/jl3KYKQAVH
// SIG // 74TKCbxDZoO/n+3bjj3RQWSxcAItA1dbGG8cLMsesgDo
// SIG // ugkvW4EENbmpY22OCMUY0eEhrPkSChTAEtt+JZ2sHRDA
// SIG // WqWD0h8aZlX8myri7DdXjuXfljD4wJMLQxj5Am+pUa+4
// SIG // VwrzHAdpOY83nG3Xka6lLknpSt6z0Iy/OZANwIHO8CoH
// SIG // OgymLVHScvNTxvm97+8MaUl3nyxWxOmhCD0HrsUe1oQi
// SIG // x7x9QxtYOGJO0QUlhMVC+B8v9tv6q4xU7EWKbBJNMFpS
// SIG // 5aQXCSLm72/1X4ZD36EtvUpGkqCBlixhl39Ab9g/jDVa
// SIG // q9HGoDuFZlSA7x8a9fGbsKEnfbLnC8/2LZxYE5SphvxF
// SIG // UqIobX90D1KRSXrpEvipO7CS/X2RFOlbbUiU8siW7gU4
// SIG // s8XsMD/hByAEsdiLvP2zPm/yAlMG9KDtyZpyo5dfAPvL
// SIG // Y9DozXT9dcnUNkW6exJZcu3n8npQAHj4Q5pG2N+/VNRe
// SIG // scfRvBuD9CvnC+hHyFOezBqs9vqKdVNsIIWp1bhquiSO
// SIG // iisIkZ83BBz2b6LdNKqR/8YVLh5CGgkpT/TGzeKRotNA
// SIG // DI544zCCBuwwggTUoAMCAQICEDAPb6zdZph0fKlGNqd4
// SIG // LbkwDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtK
// SIG // ZXJzZXkgQ2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVT
// SIG // VCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNB
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE5MDUw
// SIG // MjAwMDAwMFoXDTM4MDExODIzNTk1OVowfTELMAkGA1UE
// SIG // BhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
// SIG // cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2Vj
// SIG // dGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0aWdvIFJT
// SIG // QSBUaW1lIFN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAyBsBr9ksfoiZfQGYPyCQ
// SIG // vZyAIVSTuc+gPlPvs1rAdtYaBKXOR4O168TMSTTL80Vl
// SIG // ufmnZBYmCfvVMlJ5LsljwhObtoY/AQWSZm8hq9VxEHmH
// SIG // 9EYqzcRaydvXXUlNclYP3MnjU5g6Kh78zlhJ07/zObu5
// SIG // pCNCrNAVw3+eolzXOPEWsnDTo8Tfs8VyrC4Kd/wNlFK3
// SIG // /B+VcyQ9ASi8Dw1Ps5EBjm6dJ3VV0Rc7NCF7lwGUr3+A
// SIG // z9ERCleEyX9W4L1GnIK+lJ2/tCCwYH64TfUNP9vQ6oWM
// SIG // ilZx0S2UTMiMPNMUopy9Jv/TUyDHYGmbWApU9AXn/TGs
// SIG // +ciFF8e4KRmkKS9G493bkV+fPzY+DjBnK0a3Na+WvtpM
// SIG // YMyou58NFNQYxDCYdIIhz2JWtSFzEh79qsoIWId3pBXr
// SIG // GVX/0DlULSbuRRo6b83XhPDX8CjFT2SDAtT74t7xvAIo
// SIG // 9G3aJ4oG0paH3uhrDvBbfel2aZMgHEqXLHcZK5OVmJyX
// SIG // nuuOwXhWxkQl3wYSmgYtnwNe/YOiU2fKsfqNoWTJiJJZ
// SIG // y6hGwMnypv99V9sSdvqKQSTUG/xypRSi1K1DHKRJi0E5
// SIG // FAMeKfobpSKupcNNgtCN2mu32/cYQFdz8HGj+0p9RTbB
// SIG // 942C+rnJDVOAffq2OVgy728YUInXT50zvRq1naHelUF6
// SIG // p4MCAwEAAaOCAVowggFWMB8GA1UdIwQYMBaAFFN5v1qq
// SIG // K0rPVIDh2JvAnfKyA2bLMB0GA1UdDgQWBBQaofhhGSAP
// SIG // w0F3RSiO0TVfBhIEVTAOBgNVHQ8BAf8EBAMCAYYwEgYD
// SIG // VR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEF
// SIG // BQcDCDARBgNVHSAECjAIMAYGBFUdIAAwUAYDVR0fBEkw
// SIG // RzBFoEOgQYY/aHR0cDovL2NybC51c2VydHJ1c3QuY29t
// SIG // L1VTRVJUcnVzdFJTQUNlcnRpZmljYXRpb25BdXRob3Jp
// SIG // dHkuY3JsMHYGCCsGAQUFBwEBBGowaDA/BggrBgEFBQcw
// SIG // AoYzaHR0cDovL2NydC51c2VydHJ1c3QuY29tL1VTRVJU
// SIG // cnVzdFJTQUFkZFRydXN0Q0EuY3J0MCUGCCsGAQUFBzAB
// SIG // hhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMA0GCSqG
// SIG // SIb3DQEBDAUAA4ICAQBtVIGlM10W4bVTgZF13wN6Mgst
// SIG // JYQRsrDbKn0qBfW8Oyf0WqC5SVmQKWxhy7VQ2+J9+Z8A
// SIG // 70DDrdPi5Fb5WEHP8ULlEH3/sHQfj8ZcCfkzXuqgHCZY
// SIG // XPO0EQ/V1cPivNVYeL9IduFEZ22PsEMQD43k+ThivxMB
// SIG // xYWjTMXMslMwlaTW9JZWCLjNXH8Blr5yUmo7Qjd8Fng5
// SIG // k5OUm7Hcsm1BbWfNyW+QPX9FcsEbI9bCVYRm5LPFZgb2
// SIG // 89ZLXq2jK0KKIZL+qG9aJXBigXNjXqC72NzXStM9r4MG
// SIG // OBIdJIct5PwC1j53BLwENrXnd8ucLo0jGLmjwkcd8F3W
// SIG // oXNXBWiap8k3ZR2+6rzYQoNDBaWLpgn/0aGUpk6qPQn1
// SIG // BWy30mRa2Coiwkud8TleTN5IPZs0lpoJX47997FSkc4/
// SIG // ifYcobWpdR9xv1tDXWU9UIFuq/DQ0/yysx+2mZYm9Dx5
// SIG // i1xkzM3uJ5rloMAMcofBbk1a0x7q8ETmMm8c6xdOlMN4
// SIG // ZSA7D0GqH+mhQZ3+sbigZSo04N6o+TzmwTC7wKBjLPxc
// SIG // FgCo0MR/6hGdHgbGpm0yXbQ4CStJB6r97DDa8acvz7f9
// SIG // +tCjhNknnvsBZne5VhDhIG7GrrH5trrINV0zdo7xfCAM
// SIG // KneutaIChrop7rRaALGMq+P5CslUXdS5anSevUiumDGC
// SIG // BBwwggQYAgEBMIGRMH0xCzAJBgNVBAYTAkdCMRswGQYD
// SIG // VQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcT
// SIG // B1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRl
// SIG // ZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGltZSBTdGFt
// SIG // cGluZyBDQQIQPRo1cjAVgmMw0BNxfoJBCDANBglghkgB
// SIG // ZQMEAgEFAKCCAVswGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAyMDcxNjE3
// SIG // MjBaMC8GCSqGSIb3DQEJBDEiBCBuXw9MnHUsQ6eCdF1M
// SIG // wW8p+nupYY5eYsA02lvts8lJCTCB7QYLKoZIhvcNAQkQ
// SIG // Agwxgd0wgdowgdcwFgQUJcisc05IULf42RORqBuSSTZl
// SIG // n2EwgbwEFALWW5Xig3DBVwCV+oj5I92Tf62PMIGjMIGO
// SIG // pIGLMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
// SIG // IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENpdHkxHjAc
// SIG // BgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwG
// SIG // A1UEAxMlVVNFUlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9u
// SIG // IEF1dGhvcml0eQIQMA9vrN1mmHR8qUY2p3gtuTANBgkq
// SIG // hkiG9w0BAQEFAASCAgCVTUks89osECm+qYHHbc8JQDq1
// SIG // g0P9Nmxot9cMC6gk59ry0qkbH759+6IXZIM8KB1LW9s2
// SIG // vMVQTpGaSY7YNmz90/KhZEK9TnB38SWvX4E4J2rt6sP2
// SIG // URoIL0HhCaLwLKNULih6Qup8SwavG4M05TyWSpYJ8cqm
// SIG // Tymhcz3iDyVHn+oLG8Pvj8YH1sAGy31a0WOAGqUqz0dd
// SIG // fOKH2q5zMojdSLf9bHeYOXTIO3F0IJwnOefiPNhEQMk3
// SIG // WZXjo9S4K9aynOoD6Zq3Wn0PgdCNvTUtpuApPqv3B2XI
// SIG // CU0BN3kPwwdRSyqffXy2ovYsjR26/fqtDTtG4NxA/13C
// SIG // rqXYvny4lQeSv/1LA0Tiv7yCi9AvKqK4bQlmxGSfua//
// SIG // Qhbo9Uhjn+LDexNhpiHYsVCypsaiX/duQKgfTOiLFkvC
// SIG // wtJJPPFD0A4osKadQsejJWxq5sV+Ik1dUzSuUgVML0KI
// SIG // TGYdCipv77p6beo5PALi4dT5UHxmDQAgb0FWufFbm670
// SIG // ArqAuhwuPecQ9xTecge/VYQskLhbHuS2mBmlyFqdxvHy
// SIG // qNl8HXsv2wC2JtppMBYkj44OXTk0HT5+cb9MfAhVqopA
// SIG // FW6GEXsvTANGjYzE4FTfyfiMR1ZHThYDEBDAc2I00/A+
// SIG // l+bCP9sVuNWeQIYvaiPhHyJpJXhIMHQkDX4sNX5eRg==
// SIG // End signature block
