// Topic view.
(function($, UTILS) {

	$.widget('adsk.topicview', {
		options: {

		},

		/* Private members. */

		_$preloader: undefined,
		_$content: undefined,

        _create: function() {
            console.log('topicview: _create');

            // Create layout.
            this._render();

            // Show preloader animation.
            this.showPreloader();

            this._addEventHandlers();
        },

        _render: function() {
            console.log('topicview: _render');

            // Create app view markup.
            this.element
            .html('<div class="block-preloader"></div>' +
                  '<div class="content">Topic content</div>');

            this._$preloader = this.element.find('.block-preloader');
            this._$content = this.element.find('.content');
        },

        _addEventHandlers: function() {
            console.log('topicview: _addEventHandlers');

            var self = this,
                href = location.href;
        },

        _isAbsolutePath: function(path) {
            // Check if path is fully qualified.
            if ( /^[A-Za-z]+:\/\//.test(path) ) return true;
            if ( path.indexOf("//") == 0 ) return true;
            return false;
        },

        _flattenRelativeResourcePath: function(src, base) {
            var changedSrc = src;

            if (src && !this._isAbsolutePath(src)) {
                if (!base) {
                    base = './files/';
                }

                if (src.indexOf('../') == 0) {
                    // ../images/image.png.

                    // Strip "move up to one folder" command.
                    changedSrc = src.substr(1);
                } else {
                    // ./image.png or images.png

                    // Remove './'.
                    if (src.indexOf('./') == 0) {
                        src = src.substr(2);
                    }

                    changedSrc = base.concat(src);
                }

                return changedSrc;
            }
        },

        // book with root dir specified: base = './filesBOOK/'
        // root book: base = './files/'
        _changeHyperlinkHref: function(hyperlink, base) {
            var href = hyperlink.getAttribute('href'),
                url = (href) ? href.replace(/^\s+|\s+$/, "") : href, // href.trim()
                changedUrl = url,
                target = hyperlink.getAttribute('target');

            if (url && !this._isAbsolutePath(url)) {
                // Not anchor and not absolute url.

                if (url.indexOf('../') == 0) {
                    // "Move up one folder" relative path (cases 3, 4 and 5).

                    // Strip "move up to one folder" command.
                    changedUrl = url.substr(1);

                    if (target !== '_blank') {
                         // Add hashbang (case 5).
                         changedUrl = '#!/url='.concat(changedUrl);
                    }
                } else if ((url.charAt(0) != '#') &&
                           (url.indexOf('mailto:') != 0) &&
                           (url.indexOf('javascript') != 0)) {
                    // "Current folder" relative path (topic.htm or ./topic.htm).

                    // Remove './'.
                    if (url.indexOf('./') == 0) {
                        url = url.substr(2);
                    }

                    // Add hashbang and base path (e.g. #!url=./files/topic.htm)
                    changedUrl = '#!/url='.concat(base, url);
                } else if (url == '#') {
                    changedUrl = location.hash;
                }

                hyperlink.setAttribute('href', changedUrl);
            }
        },

        _doCommentsHyperlinkHandler: function(topicPath) {
            // Display the comments page.
            var title = document.title;

            // Remove question marks from title.
            title = title.replace(/[\?]/g, '_');

            var href = decodeURIComponent(location.href);
            // Strip hash and all that follows.
            href = href.replace(/#.*$/, '');

            var index = href.lastIndexOf("/");
                helpPath = href.substring(0, index + 1),
                url = helpPath + topicPath + '#' + title + ' [' + location.href + ']',
                specs = "height=450,width=450,resizable=yes,directories=no,location=no,menubar=no,status=no,toolbar=no";

            // Display a fixed height window with none of the browser chrome.
            window.open(url, null, specs);
        },

        _showFallbackWhenNoSourceCouldBeDecoded: function(video) {
            var $video = $(video),
                $lastSource = $video.children('source').last();

            $lastSource.error(function() {
                $video.replaceWith($video.children('.embed-container'));
            });
        },

        ﻿ _replaceObjectWithItsCopy: function(object) {
                    ﻿
            var div = document.createElement('div'),
                params = document.createElement('div'),
                classid = " classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000'";

            $(params).append( $(object).children('param') );

            // IE’s proprietary classid attribute and 'movie' param need to be created together,
            // as well as 'flashvars' param (otherwise its value will not be passed to Flash).
            var html = 	"<object" + classid + ">" +
                            params.innerHTML +
                            object.innerHTML +
                        "</object>";

            div.innerHTML = html;

            var obj = div.firstChild;

            obj.setAttribute("type", object.getAttribute('type'));
            obj.setAttribute("data", object.getAttribute('data'));
            obj.setAttribute("id", object.getAttribute('id'));

            // Replace targeted DOM element with our new <object>.
            object.parentNode.replaceChild(obj, object);
        },

        /* Public members. */

        showPreloader: function() {
            console.log('topicview: showPreloader');

            this._$preloader.show();
        },

        hidePreloader: function() {
            console.log('topicview: hidePreloader');

            this._$preloader.fadeOut();
        },

        showTopicContent: function(content, base) {
            console.log('topicview: showTopicContent');

            // Parse a string into an array of DOM nodes.
            // var html = $.parseHTML(content);
            // this._$content.html(html);
            this.showPreloader();

            // Replace src attribute with data-src to prevent jQuery html()
            // from triggering the browser request images.
            content = content.replace(/ src=/g, ' data-src=');

            var topic = $(document.createElement('div'));

            // Set the HTML content.
            topic.html(content);

            var bodyContent = topic.find('#body-content'),
                self = this;

            if (bodyContent.length == 0) {
                bodyContent = topic;
            }

            // Replace <a> elements href attribute value.
            bodyContent.find('a, area').each(function() {
                self._changeHyperlinkHref(this, base);
            });

            // Open comments page by user click.
            bodyContent.find('a.comments-anchor').click(function(event) {
                event.preventDefault();
                self._doCommentsHyperlinkHandler(this.getAttribute('href'));
            });

            // Showing fallback content when no source could be decoded.
            bodyContent.find('video').each(function() {
                self._showFallbackWhenNoSourceCouldBeDecoded(this);
            });

            // Flatten <source> element @src attribute value.
            bodyContent.find('source').each(function() {
                this.setAttribute('src', self._flattenRelativeResourcePath(this.getAttribute('data-src')));
            });

            // Flatten @data attribute value.
            bodyContent.find('object[data]').each(function() {
                this.setAttribute('data', self._flattenRelativeResourcePath(this.getAttribute('data')));
            });

            // Flatten <param name="movie"> @value.
            bodyContent.find('param[name=movie]').each(function() {
                this.setAttribute('value', self._flattenRelativeResourcePath(this.getAttribute('value')));
            });

            // Replace current objects with copies to deal with IE issue when dynamically changed values not honored.
            var isMSIE = /*@cc_on!@*/false;
            if (isMSIE) {
                bodyContent.find('object[data]').each(function() {
                    self._replaceObjectWithItsCopy(this);
                });
            }

            // Add src attributes to <img> elements with slightly changed value of data-src attribute.
            var images = bodyContent.find('img');
            images.each(function() {
                this.setAttribute('src', self._flattenRelativeResourcePath(this.getAttribute('data-src')));
            });

            // Add src attributes to <embed> elements with slightly changed value of data-src attribute.
            var embeds = bodyContent.find('embed');
            embeds.each(function() {
                this.setAttribute('src', self._flattenRelativeResourcePath(this.getAttribute('data-src')));
            });

            // Launch details (collapsible section) polyfill.
            bodyContent.find('details').details();

            // To avoid memory leaks, jQuery removes other constructs such as data and event handlers
            // from the child elements before removing the elements themselves.
            this._$content.empty().append(bodyContent);

            topic = bodyContent = null;

            $(window).trigger('topic-loaded');

            this.hidePreloader();
        },

        highlight: function(searchOptions) {
            // Get topic content except RAWMT banner.
            var $bodyContent = this._$content.children('.body_content');

            $bodyContent.removeHighlight();

            if (searchOptions.highlightEnabled) {
                var query = searchOptions.searchQuery,
                    lenient = searchOptions.caseInsensitiveEnabled;

                if (query && query !== '') {
                    // Highlight whole phrase.
                    $bodyContent.highlight(query, lenient);

                    // Highlight words.
                    if (searchOptions.searchMethod !== 'phrase') {
                        var words = query.split(" ");

                        $(words).each(function(index, word) {
                            if (word && word !== '') {
                                $bodyContent.highlight(word, lenient);
                            }
                        })
                    }
                }
            }
        },

        scrollToFragment: function(href) {
            // Scroll to anchor.
            if (href.lastIndexOf('#') != -1) {
                var fragment = href.substring(href.lastIndexOf('#') + 1);

                if (fragment !== undefined && fragment !== '') {
                    var $anchor = $('a[name=' + fragment + ']');

                    this._$content.scrollTo($anchor, 800);
                } else {
                    // Scroll to top for invalid fragment value.
                    this._$content.scrollTo(0);
                }
            } else {
                // Scroll to top if fragment value not specified.
                this._$content.scrollTo(0);
            }
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // ZB6ZfN4jdDuCRGD+sbCjtR2x0uhqjsQsUjxop56o7W+g
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgH7GdHea/
// SIG // Zuy9pnVaA0V+NXneQcYWg5eDP8pCwLkF34IwDQYJKoZI
// SIG // hvcNAQEBBQAEggEAM7OgwDf3EZbV3vYs0Q2FHZm5SOpx
// SIG // nkDbvVLxLFtyTC77NMd1e4aaCtZPewxmq7Uj7l7BLPs+
// SIG // D2xLfk2zq5qVrpGmoEkTfo8zK3eKFHoq8Qdb8rtOJ5YZ
// SIG // iO2tVXd12Zz43dcgOCGriHg+R124sVJkSCUFwe1nvW5s
// SIG // CGzGx6zWYX6HZTuCAT0MK0G9GMD0gaDaN32SDAhx4X8k
// SIG // SzjFFWAEuKS4D+nnfWng1R1qVLTj8VMDTbeFJCb9N/lC
// SIG // DaHaYGQ6rNFQyfsmB5lq44gQpGZ2ixejeYTUBGRcSvV4
// SIG // ByCQUbOwX2O2M5GEtwxEeQD4fvts2P2u/uM6nIqHsYoE
// SIG // WhRXLaGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQgsI2a
// SIG // eIVCzhQLHdUsF6A2lptMTMf2G06JJhH82DQL9VgCFHEn
// SIG // QIHm7ksAMHYMOXLbLAPFN84HGA8yMDIwMDIwNzE2MTcw
// SIG // NFqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAyMDcxNjE3
// SIG // MDRaMC8GCSqGSIb3DQEJBDEiBCDoi9jLGu193wfdUA6A
// SIG // cVbyXrt0tGxSYsqR+mQpq40iQTCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAA2UqNOia+uU6eAnB8W0UfJZ/YaVSgRegXjinjpw4
// SIG // r0VneiSDT5vLTcEN8hZIw4hXjypb+lGqXBMpUCFpJ0w/
// SIG // 4ApB6bkVpiv9f+HBlCXJGZVLJ8GWK29To6nUP3MOV/mT
// SIG // YNxaz1YPHvvuWkkBIW3dqfUSaMvAAdgYBtD9YsX/IYNw
// SIG // WYyiHTbRR933iPQ5N30puisCxrkYqyP85iQtrBrPFzYt
// SIG // DrZeecr2cpWbJtiYwdem1ftUAnXOHLlPG9/0i2XSpDeZ
// SIG // 305A/0XlhW2oIfi0AtwheLXbSKL2DnYSV/vkJC/m7bBS
// SIG // LVGxwEMvHnWO0nyG1IJGmpzVmcB9y9422AyTkQ==
// SIG // End signature block
