//---start of generated typescript---
//
//////////////////////////////////////////////////////////////////////////////
//
// (C) Copyright 2012 by Autodesk, Inc.
//
// The information contained herein is confidential, proprietary to Autodesk,
// Inc., and considered a trade secret as defined in section 499C of the
// penal code of the State of California.  Use of this information by anyone
// other than authorized employees of Autodesk, Inc. is granted only under a
// written non-disclosure agreement, expressly prescribing the scope and
// manner of such use.
//
//////////////////////////////////////////////////////////////////////////////
//---end of generated typescript---
//---start of generated typescript---
//
//////////////////////////////////////////////////////////////////////////////
//
// (C) Copyright 2012 by Autodesk, Inc.
//
// The information contained herein is confidential, proprietary to Autodesk,
// Inc., and considered a trade secret as defined in section 499C of the
// penal code of the State of California.  Use of this information by anyone
// other than authorized employees of Autodesk, Inc. is granted only under a
// written non-disclosure agreement, expressly prescribing the scope and
// manner of such use.
//
//////////////////////////////////////////////////////////////////////////////
// Include TS files
///<reference path="CommonTypes.ts"/>
var help;
(function (help) {

    var Autodesk;
    (function (Autodesk) {
        var JavaScript;
        (function (JavaScript) {
            var ErrorStatus;
            (function (ErrorStatus) {
                ErrorStatus[ErrorStatus["eOk"] = 0] = "eOk";
            })(ErrorStatus = JavaScript.ErrorStatus || (JavaScript.ErrorStatus = {}));
        })(JavaScript = Autodesk.JavaScript || (Autodesk.JavaScript = {}));
    })(Autodesk || (Autodesk = {}));

    var Api;
    (function (Api) {
        // options: { functionName, functionParams }
        var execAsyncProxy = function(options) {
            return new Promise(function(resolve, reject) {
                execAsync(JSON.stringify(options), function(result) {
                    var resObj = JSON.parse(result);

                    if (typeof (apiVersion) == 'function' && apiVersion() > 2) {
                        resolve(resObj.retValue);
                    } else {
                        //OLD serialization logic:
                        if (resObj.hasOwnProperty("retValue")) {
                            resolve(JSON.parse(resObj.retValue));
                        } else {
                            resolve(resObj);
                        }
                    }
                }, function(result) {
                    var error = JSON.parse(result);
                    //retcode must be present
                    if (error.retCode == undefined) {
                        throw TypeError("Internal error: retCode is not present.");
                    }
                    //and it must be non-eOk
                    if (error.retCode == Autodesk.JavaScript.ErrorStatus.eOk) {
                        throw "Internal error: retCode is eOk in error callback.";
                    }
                    //errorMessage is optional
                    if (error.retErrorString == undefined) {
                        reject(error.retCode);
                    } else {
                        reject(error.retCode, error.retErrorString);
                    }
                });
            });
        };


        function login() {
            return execAsyncProxy({
                functionName: 'help_Api.login',
                functionParams: {}
            });
        } //end of function
        Api.login = login;

        function logout() {
            return execAsyncProxy({
                functionName: 'help_Api.logout',
                functionParams: {}
            });
        } //end of function
        Api.logout = logout;

        function isLoggedIn() {
            return execAsyncProxy({
                functionName: 'help_Api.isLoggedIn',
                functionParams: {}
            });
        } //end of function
        Api.isLoggedIn = isLoggedIn;

        function getUserInfo() {
            return execAsyncProxy({
                functionName: 'help_Api.getUserInfo',
                functionParams: {}
            });
        } //end of function
        Api.getUserInfo = getUserInfo;

        function getUserName() {
            return execAsyncProxy({
                functionName: 'help_Api.getUserName',
                functionParams: {}
            });
        } //end of function
        Api.getUserName = getUserName;

        function getUserFirstName() {
            return execAsyncProxy({
                functionName: 'help_Api.getUserFirstName',
                functionParams: {}
            });
        } //end of function
        Api.getUserFirstName = getUserFirstName;

        function getUserLastName() {
            return execAsyncProxy({
                functionName: 'help_Api.getUserLastName',
                functionParams: {}
            });
        } //end of function
        Api.getUserLastName = getUserLastName;

        function getUserId() {
            return execAsyncProxy({
                functionName: 'help_Api.getUserId',
                functionParams: {}
            });
        } //end of function
        Api.getUserId = getUserId;

        function getUserEmail() {
            return execAsyncProxy({
                functionName: 'help_Api.getUserEmail',
                functionParams: {}
            });
        } //end of function
        Api.getUserEmail = getUserEmail;

        function HomeUrl(Online) {
            return execAsyncProxy({
                functionName: 'help_Api.HomeUrl',
                functionParams: {
                    Online: Online
                }
            });
        } //end of function
        Api.HomeUrl = HomeUrl;

        function OfflineInstalled() {
            return execAsyncProxy({
                    functionName: 'help_Api.OfflineInstalled',
                    functionParams: {}
                });
        } //end of function
        Api.OfflineInstalled = OfflineInstalled;

        function HelpFindUI(ID, IsTopic) {
            return execAsyncProxy({
                functionName: 'help_Api.HelpFindUI',
                functionParams: {
                    ID: ID,
                    IsTopic: IsTopic
                }
            });
        } //end of function
        Api.HelpFindUI = HelpFindUI;

        var userLoggedInEvent_handlers = null;
        //called by native code: fires event to callback supplied by the user
        function userLoggedInEventCallback(args) {
            var obj = JSON.parse(args);
            //unpack all event arguments
            var userInfo = obj.userInfo;
            //call each handler
            for (var i = 0; i < userLoggedInEvent_handlers.length; ++i)
                userLoggedInEvent_handlers[i](userInfo);
        }
        //allows user to supply a callback
        function addHandler_userLoggedInEvent(userFunction) {
            var separator = (typeof (apiVersion) == 'function' && apiVersion() > 2) ? '.' : '_';
            if (userLoggedInEvent_handlers == null) {
                userLoggedInEvent_handlers = new Array();
                registerCallback('help_Api' + separator + 'userLoggedInEvent', userLoggedInEventCallback);
            }
            userLoggedInEvent_handlers.push(userFunction);
        }
        Api.addHandler_userLoggedInEvent = addHandler_userLoggedInEvent;
        //removes the callback
        function removeHandler_userLoggedInEvent(userFunction) {
            if (userLoggedInEvent_handlers !== null) {
                for (var i = 0; i < userLoggedInEvent_handlers.length; i++) {
                    if (userLoggedInEvent_handlers[i] === userFunction) {
                        userLoggedInEvent_handlers.splice(i, 1);
                        break;
                    }
                }
            }
        }
        Api.removeHandler_userLoggedInEvent = removeHandler_userLoggedInEvent;
        var userLoggedOutEvent_handlers = null;
        //called by native code: fires event to callback supplied by the user
        function userLoggedOutEventCallback(args) {
            var obj = JSON.parse(args);
            //unpack all event arguments
            //call each handler
            for (var i = 0; i < userLoggedOutEvent_handlers.length; ++i)
                userLoggedOutEvent_handlers[i]();
        }
        //allows user to supply a callback
        function addHandler_userLoggedOutEvent(userFunction) {
            var separator = (typeof (apiVersion) == 'function' && apiVersion() > 2) ? '.' : '_';
            if (userLoggedOutEvent_handlers == null) {
                userLoggedOutEvent_handlers = new Array();
                registerCallback('help_Api' + separator + 'userLoggedOutEvent', userLoggedOutEventCallback);
            }
            userLoggedOutEvent_handlers.push(userFunction);
        }
        Api.addHandler_userLoggedOutEvent = addHandler_userLoggedOutEvent;
        //removes the callback
        function removeHandler_userLoggedOutEvent(userFunction) {
            if (userLoggedOutEvent_handlers !== null) {
                for (var i = 0; i < userLoggedOutEvent_handlers.length; i++) {
                    if (userLoggedOutEvent_handlers[i] === userFunction) {
                        userLoggedOutEvent_handlers.splice(i, 1);
                        break;
                    }
                }
            }
        }
        Api.removeHandler_userLoggedOutEvent = removeHandler_userLoggedOutEvent;
    })(Api = help.Api || (help.Api = {})); //end module Api
})(help || (help = {}));
//---end of generated typescript---
//# sourceMappingURL=Autodesk.AutoCAD.Help.js.map

// SIG // Begin signature block
// SIG // MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 74+DNzYo29wNL/sOm5ixtP90CEvfdegizPO36FW1Tyag
// SIG // ggoaMIIEyzCCA7OgAwIBAgIQCQja65wGHi65un4mqmKH
// SIG // ijANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xOTA1MTQwMDAw
// SIG // MDBaFw0yMDA1MTMyMzU5NTlaMHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIDApDYWxpZm9ybmlhMRMwEQYDVQQHDApT
// SIG // YW4gUmFmYWVsMRcwFQYDVQQKDA5BdXRvZGVzaywgSW5j
// SIG // LjERMA8GA1UECwwIU2VjdXJpdHkxFzAVBgNVBAMMDkF1
// SIG // dG9kZXNrLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAkVKRoPYsoxPdlabspcuG8HYDfcWQ
// SIG // 9qyPOT2punwpVdjt2slktcpSTlydrGy8ijcbl5/k8AOJ
// SIG // afKMQvow0fNjIoNB5nsb8j2xFJPbBhHl8GT4P6DZ1OWK
// SIG // ioiUXgGHKjctUws49J4elntqvBYhKCbuPqG772QCoYFU
// SIG // P7qcFbh3PbyNB6cnKMn2vNGRqiEtV2aGg+/MiL3QPsvT
// SIG // kTWhVuTLIvwZ4kK5C5ACiQzlGOlE+C7gWuFoxtvy6gUa
// SIG // A8JAq/xLjYKwFevQwGncg3s1cuiGhx0P7Rvn6oCd2cem
// SIG // FmbK3I3rMRt+jc9wzAj3oHxvCo4f5Lfva+OpC1dETUVV
// SIG // sk0VGwIDAQABo4IBPjCCATowCQYDVR0TBAIwADAOBgNV
// SIG // HQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // YQYDVR0gBFowWDBWBgZngQwBBAEwTDAjBggrBgEFBQcC
// SIG // ARYXaHR0cHM6Ly9kLnN5bWNiLmNvbS9jcHMwJQYIKwYB
// SIG // BQUHAgIwGQwXaHR0cHM6Ly9kLnN5bWNiLmNvbS9ycGEw
// SIG // HwYDVR0jBBgwFoAU1MAGIknrOUvdk+JcobhHdglyA1gw
// SIG // KwYDVR0fBCQwIjAgoB6gHIYaaHR0cDovL3JiLnN5bWNi
// SIG // LmNvbS9yYi5jcmwwVwYIKwYBBQUHAQEESzBJMB8GCCsG
// SIG // AQUFBzABhhNodHRwOi8vcmIuc3ltY2QuY29tMCYGCCsG
// SIG // AQUFBzAChhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNy
// SIG // dDANBgkqhkiG9w0BAQsFAAOCAQEA0Q2+iVSEfT4xGq3A
// SIG // OADVb0rT5Z8E+PPb1x6hKknSzuaZKk/acDz9mdnFajaU
// SIG // WgIKiFJlsqJnuAM1w4lqKaEWsz3DoxvGIEwexj71Ud6a
// SIG // KlBJNcR9DdkXUZwMhbw9d78rjJAIX6tOwfSludZfdq8b
// SIG // YEkuIzQi9uYW9vHVPSCzhnUBKjwc9qTo9yBc7Fcn4FAT
// SIG // 90DzWM2hS9oc3p0pprYI2I/O4th90BEmwWkVqVgfaR0z
// SIG // VyIEmBbqB/IWLfjUBZJ/8sbkwWuWlYVRrfPxsj1e9qvb
// SIG // wE3Y28jWyGbqoUG39GhXk3uT8R8i3+T6M0c4rMfdifBC
// SIG // pceCaFTJzSye7LoeVzCCBUcwggQvoAMCAQICEHwbNTVK
// SIG // 59t050FfEWnKa6gwDQYJKoZIhvcNAQELBQAwgb0xCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29y
// SIG // azE6MDgGA1UECxMxKGMpIDIwMDggVmVyaVNpZ24sIElu
// SIG // Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE4MDYG
// SIG // A1UEAxMvVmVyaVNpZ24gVW5pdmVyc2FsIFJvb3QgQ2Vy
// SIG // dGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTQwNzIyMDAw
// SIG // MDAwWhcNMjQwNzIxMjM1OTU5WjCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMjCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBANeVQ9Tc32euOftS
// SIG // pLYmMQRw6beOWyq6N2k1lY+7wDDnhthzu9/r0XY/ilaO
// SIG // 6y1L8FcYTrGNpTPTC3Uj1Wp5J92j0/cOh2W13q0c8fU1
// SIG // tCJRryKhwV1LkH/AWU6rnXmpAtceSbE7TYf+wnirv+9S
// SIG // rpyvCNk55ZpRPmlfMBBOcWNsWOHwIDMbD3S+W8sS4duM
// SIG // xICUcrv2RZqewSUL+6McntimCXBx7MBHTI99w94Zzj7u
// SIG // BHKOF9P/8LIFMhlM07Acn/6leCBCcEGwJoxvAMg6ABFB
// SIG // ekGwp4qRBKCZePR3tPNgKuZsUAS3FGD/DVH0qIuE/iHa
// SIG // XF599Sl5T7BEdG9tcv8CAwEAAaOCAXgwggF0MC4GCCsG
// SIG // AQUFBwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL3Mu
// SIG // c3ltY2QuY29tMBIGA1UdEwEB/wQIMAYBAf8CAQAwZgYD
// SIG // VR0gBF8wXTBbBgtghkgBhvhFAQcXAzBMMCMGCCsGAQUF
// SIG // BwIBFhdodHRwczovL2Quc3ltY2IuY29tL2NwczAlBggr
// SIG // BgEFBQcCAjAZGhdodHRwczovL2Quc3ltY2IuY29tL3Jw
// SIG // YTA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vcy5zeW1j
// SIG // Yi5jb20vdW5pdmVyc2FsLXJvb3QuY3JsMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMA4GA1UdDwEB/wQEAwIBBjApBgNV
// SIG // HREEIjAgpB4wHDEaMBgGA1UEAxMRU3ltYW50ZWNQS0kt
// SIG // MS03MjQwHQYDVR0OBBYEFNTABiJJ6zlL3ZPiXKG4R3YJ
// SIG // cgNYMB8GA1UdIwQYMBaAFLZ3+mlIR59TEtXC6gcydgfR
// SIG // lwcZMA0GCSqGSIb3DQEBCwUAA4IBAQB/68qn6ot2Qus+
// SIG // jiBUMOO3udz6SD4Wxw9FlRDNJ4ajZvMC7XH4qsJVl5Fw
// SIG // g/lSflJpPMnx4JRGgBi7odSkVqbzHQCR1YbzSIfgy8Q0
// SIG // aCBetMv5Be2cr3BTJ7noPn5RoGlxi9xR7YA6JTKfRK9u
// SIG // QyjTIXW7l9iLi4z+qQRGBIX3FZxLEY3ELBf+1W5/muJW
// SIG // kvGWs60t+fTf2omZzrI4RMD3R3vKJbn6Kmgzm1By3qif
// SIG // 1M0sCzS9izB4QOCNjicbkG8avggVgV3rL+JR51EeyXgp
// SIG // 5x5lvzjvAUoBCSQOFsQUecFBNzTQPZFSlJ3haO8I8OJp
// SIG // nGdukAsak3HUJgLDwFojMYIOuzCCDrcCAQEwgZkwgYQx
// SIG // CzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRlYyBD
// SIG // b3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1
// SIG // c3QgTmV0d29yazE1MDMGA1UEAxMsU3ltYW50ZWMgQ2xh
// SIG // c3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENBIC0gRzIC
// SIG // EAkI2uucBh4uubp+Jqpih4owDQYJYIZIAWUDBAIBBQCg
// SIG // fDAQBgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgh+reOXt9
// SIG // Cc1dPo6xic3/aygF0tzCjpuYuVng9Nmi6c4wDQYJKoZI
// SIG // hvcNAQEBBQAEggEAL0Ef5HgAw+KZe2tOMrypnQlwci5J
// SIG // 1J+R0ThtK+Hh3olY3kWCKfx9uDJjWuOfn0cYyst+ILeT
// SIG // xUe0BphcoA+0RAADgaTJ0SHKajXihlnUAtcoP9Rhv1b7
// SIG // 9XMga6LSOmqieRf2J7CF2Ikb0sT2Tdy/I9t11FqC2NOV
// SIG // AJ0DCD4pOjTWEZroQ7vW5oO6lUEUyPvbHe/wEH3ljhLX
// SIG // 2jFDw6gG7cYneBG01FSbyxOnNqYWrcALpcqJKYcxb1EV
// SIG // CuLovNU3pyFjRh6tmkeqYNy2PdtsAwuE5lfiXJjQBVUq
// SIG // Gnu0udAzz/v+VT20EZLR52SJHFhw8VQrxIG5IMMLTiOZ
// SIG // OvI8GaGCDHQwggxwBgorBgEEAYI3AwMBMYIMYDCCDFwG
// SIG // CSqGSIb3DQEHAqCCDE0wggxJAgEDMQ8wDQYJYIZIAWUD
// SIG // BAIBBQAwga8GCyqGSIb3DQEJEAEEoIGfBIGcMIGZAgEB
// SIG // BgkrBgEEAaAyAgMwMTANBglghkgBZQMEAgEFAAQg3qpe
// SIG // hMVeAcBxhYBZevOGgwRpkgbpj1fGRLVwk352tygCFC0A
// SIG // VaymliBV+fADeTlLMhEdAhoAGA8yMDIwMDIwNzE2MTcw
// SIG // MlqgL6QtMCsxKTAnBgNVBAMMIEdsb2JhbFNpZ24gVFNB
// SIG // IGZvciBBZHZhbmNlZCAtIEcyoIII0zCCBLYwggOeoAMC
// SIG // AQICDAynz10HBySsieeaOjANBgkqhkiG9w0BAQsFADBb
// SIG // MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2ln
// SIG // biBudi1zYTExMC8GA1UEAxMoR2xvYmFsU2lnbiBUaW1l
// SIG // c3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBHMjAeFw0xODAy
// SIG // MTkwMDAwMDBaFw0yOTAzMTgxMDAwMDBaMCsxKTAnBgNV
// SIG // BAMMIEdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAt
// SIG // IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
// SIG // AQEAt8eSiijY85HLUA1d6ylEwYJZpcpkzr2DtVHllMxu
// SIG // gJoXbNz/YuY2Q14Bwgxkjcp3nvZdd0W5Xsgk60E3EWY3
// SIG // rMjNdJvMs+9M4n8bznO+yZadNR5891T3bOygEtaumZ1j
// SIG // xHhfWakuIvXDJ9iyW0VjJ5D/jLE9qbTzDsDxIGUGiZ0D
// SIG // HKOwUkGFNOu8y85U9hL+swGJSqb6VMUf+9McwOO/l+M/
// SIG // 0Bv5QMcb1esmfEMwx3DyeBGqhU6lDg0ASjoRd6PKIwGA
// SIG // nsiTVl1GzIrY0qoKhIWyiVvVMs5BexhOVMqr0VJeEtMk
// SIG // nlbzDI/dvZKOedVBicOjoOWR/MdnnYczznEycwIDAQAB
// SIG // o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARF
// SIG // MEMwQQYJKwYBBAGgMgEeMDQwMgYIKwYBBQUHAgEWJmh0
// SIG // dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRv
// SIG // cnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYB
// SIG // BQUHAwgwRgYDVR0fBD8wPTA7oDmgN4Y1aHR0cDovL2Ny
// SIG // bC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVzdGFtcGlu
// SIG // Z3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgG
// SIG // CCsGAQUFBzAChjxodHRwOi8vc2VjdXJlLmdsb2JhbHNp
// SIG // Z24uY29tL2NhY2VydC9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // Mi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5n
// SIG // bG9iYWxzaWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJn
// SIG // MjAdBgNVHQ4EFgQULW5u0Y3lA4Du52Ppp9naCzxXIj0w
// SIG // HwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0ww
// SIG // DQYJKoZIhvcNAQELBQADggEBAI39HR+PiNNl+LVcRumn
// SIG // 07Y/SstDBcIHDcNeA4QjN6h6jJcj/yechH1h61xLVz6b
// SIG // 9ETbgFj3tmXejxIKX6eHdLfaFECHUeyfSkdV8BfoGD5x
// SIG // IDHmKCKrTvaunGvC50T7aA0gf1M/lBuhhoJOMhYQWj+J
// SIG // WMHQtNu2kPuNMumhS0ZQN7bDOukpJBKSWk4rubYKejaM
// SIG // l8DviXwz3jHhoZfk50WtYVL9WonTVH6KTVuJew6Wd9Hy
// SIG // PDgb2vmlYSBlArzFrdcMYhAoLN2246hhAKwIJqONhdBk
// SIG // yTaQHopSyYeNNaVdSJH8k6alZfHs+TrcpSyeBG1iM/7e
// SIG // +p/Fzq+V81Go8s4wggQVMIIC/aADAgECAgsEAAAAAAEx
// SIG // icZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdH
// SIG // bG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMK
// SIG // R2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAe
// SIG // Fw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUB
// SIG // tpaU4k/YwQj2RiPZRcWVl1urGr/SbFfJMwYfoA/GPH5T
// SIG // SHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
// SIG // C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGp
// SIG // eZ7X61edK3wi2BTX8QceeCI2a3d5r6/5f45O4bUIMf3q
// SIG // 7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7IaGlR
// SIG // dhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBl
// SIG // H1d2zFuOBE8sqNuEUBNPxtyLufjdaUyI65x7MCb8eli7
// SIG // WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHlMA4GA1Ud
// SIG // DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
// SIG // A1UdDgQWBBSSIadKlV1ksJu0HuYAN0fmnUErTDBHBgNV
// SIG // HSAEQDA+MDwGBFUdIAAwNDAyBggrBgEFBQcCARYmaHR0
// SIG // cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9y
// SIG // eS8wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
// SIG // bG9iYWxzaWduLm5ldC9yb290LXIzLmNybDAfBgNVHSME
// SIG // GDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
// SIG // 9w0BAQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbO
// SIG // MRhZ+WxBX4AuwEIluBjH/NSxN8RooM8oagN0S2OXhXdh
// SIG // O9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
// SIG // ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uy
// SIG // y/YZhp2fyNSYBbJxb051rvE9ZGo7Xk5GpipdCJLxo/Md
// SIG // dL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVzr9xG
// SIG // 2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB7
// SIG // 4JD9IBh4GCJdCC6MHKCX8x2ZfaOdkdMGRE4EbnocIOM2
// SIG // 8LZQuTGCAqgwggKkAgEBMGswWzELMAkGA1UEBhMCQkUx
// SIG // GTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNV
// SIG // BAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0g
// SIG // U0hBMjU2IC0gRzICDAynz10HBySsieeaOjANBglghkgB
// SIG // ZQMEAgEFAKCCAQ4wGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDAyMDcxNjE3
// SIG // MDJaMC8GCSqGSIb3DQEJBDEiBCAUHlH8xOzWbPYklwar
// SIG // 596RIfMfFjXqUvXDFYjigrAOHDCBoAYLKoZIhvcNAQkQ
// SIG // AgwxgZAwgY0wgYowgYcEFJsSBXrnKq/21jdytJ9qI28m
// SIG // Sc2pMG8wX6RdMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
// SIG // ExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
// SIG // YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAt
// SIG // IEcyAgwMp89dBwckrInnmjowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAfWPRR5J8zsCEfGFms2ffIQ8f0KQ9cGZ2zddZwBNw
// SIG // KVi/BzBHxDkiAaX/4pSuY8aT0Pu21QwdVnSZB0oisB/q
// SIG // BpdkhPJ37IA5N5WJCQnkOzrXfjnRhT3y3FA3GSkaDbTs
// SIG // 3gg2rnT/QhJ6x/po8m32GZtrkZ2JGgPaqLeQx0KKcywm
// SIG // /akY3SA/wgvpVT2hBXXSdwn5ESYQt2wjgln3S1IdvFtH
// SIG // oLlALzdU3eWTmM1MzmIzBCiszk/UVBR6ApE3xREx/S+G
// SIG // InOVtVczAxdcBJ5HHc2LE8OaumBFkIs+kEYywx0HH7KC
// SIG // 6L4Lu/GQfV4oIv4/1UdRbbjG0Ii9Jml+2SNlsg==
// SIG // End signature block
