# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiUvTransformTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()

        self.addControl('passthrough', label='')
        self.addSeparator()

        self.addControl('uvset', label='UV')


        self.beginLayout('֡', collapse=False)
        self.addControl('scaleFrame', label='ģ')
        self.addControl('translateFrame', label='任')
        self.addControl('rotateFrame', label='ת')
        self.addControl('pivotFrame', label='')
        self.addControl('wrapFrameU', label=' U')
        self.addControl('wrapFrameV', label=' V')
        self.addControl('wrapFrameColor', label='ɫ')
        self.endLayout()

        self.beginLayout('任', collapse=False)
        self.addControl('repeat', label='ظ')
        self.addControl('offset', label='')
        self.addControl('rotate', label='ת')
        self.addControl('pivot', label='')
        self.addControl('coverage', label='')
        self.endLayout()

        self.beginLayout('UV޸', collapse=False)
        self.addControl('noise', label='')
        self.addControl('mirrorU', label='U')
        self.addControl('mirrorV', label='V')
        self.addControl('flipU', label='תU')
        self.addControl('flipV', label='תV')
        self.addControl('swapUv', label='Uv')
        self.addControl('stagger', label='')
        self.endLayout()
        self.addControl('unit', label='Ԫ')

        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.addExtraControls()
        self.endScrollLayout()
