# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.utils as utils
import mtoa.ui.ae.utils as aeUtils
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate


class AEaiThinFilmTemplate(ShaderAETemplate):

   
    def setup(self):
        self.addSwatch()
       
        self.beginScrollLayout()
        
        self.beginLayout('', collapse=False)
        self.addControl('thicknessMin', label='С (nm)')
        self.addControl('thicknessMax', label=' (nm)')
        self.addControl('thickness', label='')
        self.endLayout()

        self.beginLayout('IOR', collapse=False)
        self.addControl('iorMedium', label='еIOR')
        self.addControl('iorFilm', label='ĤIOR')
        self.addControl('iorInternal', label='ڲIOR')       
        self.endLayout()

        # include/call base class/node attributes
        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.addExtraControls()
        
        self.endScrollLayout()
