# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.utils as utils
import mtoa.ui.ae.utils as aeUtils
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate


class AEaiStandardVolumeTemplate(ShaderAETemplate):
    convertToMayaStyle = True
   
    def setup(self):
        self.addSwatch()

        self.beginScrollLayout()
        
        self.beginLayout("", collapse=False)
        self.addControl("density",  label="ܶ", annotation="Volume Density")
        self.addControl("densityChannel", label="ܶͨ", annotation="Density Channel")
        self.addControl("interpolation", label="ֵ", annotation="Interpolation")
        self.addControl("displacement", label="λ", annotation="Displacement")
        self.endLayout()

        self.beginLayout("ɢ", collapse=False)
        self.addControl("scatter",  label="", annotation="Scatter")
        self.addControl("scatterColor", label="ɢɫ", annotation="Scatter Color")
        self.addControl("scatterColorChannel", label="ɫͨ", annotation="Scatter Color Channel")
        self.addControl("scatterAnisotropy", label="", annotation="Scatter Anisotropy")
        self.endLayout()

        self.beginLayout("͸", collapse=False)
        self.addControl("transparent",  label="", annotation="Transparent Weight")
        self.addControl("transparentDepth", label="", annotation="Transparent Depth")
        self.addControl("transparentChannel", label="ͨ", annotation="Transparent Channel")
        self.endLayout()

        self.beginLayout("", collapse=False)
        self.addControl("emissionMode",  label="ģʽ", annotation="Emission Mode")
        self.addControl("emission", label="", annotation="Emission Weight")
        self.addControl("emissionColor", label="ɫ", annotation="Emission Color")
        self.addControl("emissionChannel", label="ͨ", annotation="Emission Channel")

        self.beginLayout("¶", collapse=False)
        self.addControl("temperature",  label="¶", annotation="Temperature")
        self.addControl("temperatureChannel", label="ͨ", annotation="Temperature Channel")
        self.addControl("blackbodyKelvin", label="", annotation="Blackbody Kelvin")
        self.addControl("blackbodyIntensity", label="ǿ", annotation="Blackbody Intensity")

        self.endLayout()
        self.endLayout()


        # include/call base class/node attributes
        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.suppress('PhongExponent')
       
        self.addExtraControls()
        self.endScrollLayout()

