# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.utils as utils
import mtoa.ui.ae.utils as aeUtils
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate


class AEaiStandardHairTemplate(ShaderAETemplate):
    convertToMayaStyle = True
   
    def setup(self):
        self.addSwatch()

        self.beginScrollLayout()

        self.addCustom('message', 'AEshaderTypeNew', 'AEshaderTypeReplace')
        

        self.beginLayout("ɫ", collapse=False)
        self.addControl("base",  label="", annotation="Base Weight")
        self.addControl("baseColor", label="ɫ", annotation="Base Color")
        self.addSeparator()
        self.addControl("melanin",  label="ɫ", annotation="Melanin")
        self.addControl("melaninRedness",  label="ɫط", annotation="Melanin Redness")
        self.addControl("melaninRandomize",  label="ɫ", annotation="Melanin Randomize")
        self.endLayout()

        self.beginLayout("߹", collapse=False)
        self.addControl("roughness",  label="ֲڶ", annotation="Roughness")
        self.addControl("ior",  label="IOR", annotation="IOR")
        self.addControl("shift",  label="ƫ", annotation="IOR")
        self.beginLayout("ɫ", collapse=True)
        self.addControl("specularTint",  label="߹ɫ", annotation="Specular Tint")
        self.addSeparator()
        self.addControl("specular2Tint",  label="θ߹ɫ", annotation="2dn Specular Tint")
        self.addSeparator()
        self.addControl("transmissionTint",  label="͸ɫ", annotation="Transmission Tint")
        self.endLayout()
        self.endLayout()

        self.beginLayout("", collapse=True)
        self.addControl("diffuse",  label="", annotation="Specular")
        self.addControl("diffuseColor",  label="ɫ", annotation="Specular Tint")
        self.endLayout()

        self.beginLayout("", collapse=True)
        self.addControl("emission",  label="", annotation="Emission")
        self.addControl("emissionColor",  label="ɫ", annotation="Emission Color")
        self.endLayout()

        self.addControl("opacity",  label="͸", annotation="Opacity")

        self.beginLayout("ƹ", collapse=True)
        self.addControl("aiEnableMatte", label="ƹ")
        self.addControl("aiMatteColor", label="ƹɫ")
        self.addControl("aiMatteColorA", label="ƹⲻ͸")
        self.endLayout()

        self.beginLayout("߼", collapse=True)
        self.addControl("indirectDiffuse",  label="", annotation="Indirect Diffuse")
        self.addControl("indirectSpecular",  label="Ӹ߹", annotation="Indirect Specular")
        self.endLayout()


        # include/call base class/node attributes
        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.suppress('PhongExponent')
       
        self.addExtraControls()
        self.endScrollLayout()

