# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.ui.ae.lightTemplate as lightTemplate
import mtoa.ui.ae.aiSwatchDisplay as aiSwatchDisplay
import mtoa.ui.ae.templates as templates

class AEaiSkyDomeLightTemplate(lightTemplate.LightTemplate):
    def addSwatch(self):
        self.addCustom("message", aiSwatchDisplay.aiSwatchDisplayNew, aiSwatchDisplay.aiSwatchDisplayReplace)
        
    def makeLightExclusive(self, attr):
        lightName = attr.split(".")[0]
        pm.rowLayout(nc=2, cal=[2, 'left'])
        pm.text(label="")
        pm.exclusiveLightCheckBox('exclusiveButton', light=lightName, label="Ĭ")
        pm.setParent('..')
        
    def replaceLightExclusive(self, attr):
        lightName = attr.split(".")[0]
        pm.exclusiveLightCheckBox('exclusiveButton', edit=True, light=lightName)
        
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()
        
        self.beginLayout('', collapse=False)        
        self.addControl('color', label='ɫ')
        self.addControl('intensity', label='ǿ')
        self.addControl('resolution', label='ֱ')
        self.addSeparator()
        self.setupColorTemperature("ArnoldSkyDome")
        self.addCustom("instObjGroups", self.makeLightExclusive, self.replaceLightExclusive)
        self.addSeparator()
        self.addControl('format', label='ʽ')
        self.addControl('aiExposure', label='ع')
        self.addControl('aiSamples', label='')
        self.addControl('aiNormalize', label='ͳһ')
        self.addSeparator()
        self.addControl('aiCastShadows', label='ͶӰ')
        self.addControl('aiShadowColor', label='Ӱɫ')
        self.addSeparator()
        self.addControl('portalMode', label='ģʽ')
        self.addSeparator()

        self.commonLightAttributes(addVisibility = True)
        self.endLayout()
        
        self.beginLayout('Ӳ', collapse=True)
        self.addControl('sampling', label='ֱ')
        self.addControl('hwtexalpha', label='͸')
        self.endLayout()
        
        self.beginLayout('', collapse=True)
        self.addControl('skyRadius', label='հ뾶')
        self.addControl('skyFacing', label='')
        self.endLayout()

        # Do not show extra attributes
        extras = ["visibility",
                  "intermediateObject",
                  "template",
                  "ghosting",
                  "instObjGroups",
                  "useObjectColor",
                  "objectColor",
                  "drawOverride",
                  "lodVisibility",
                  "renderInfo",
                  "renderLayerInfo",
                  "ghostingControl",
                  "ghostCustomSteps",
                  "ghostFrames",
                  "ghostRangeStart",
                  "ghostRangeEnd",
                  "ghostDriver",
                  "ghostColorPreA",
                  "ghostColorPre",
                  "ghostColorPostA",
                  "ghostColorPost",
                  "motionBlur",
                  "visibleInReflections",
                  "visibleInRefractions",
                  "castsShadows",
                  "receiveShadows",
                  "maxVisibilitySamplesOverride",
                  "maxVisibilitySamples",
                  "geometryAntialiasingOverride",
                  "antialiasingLevel",
                  "shadingSamplesOverride",
                  "shadingSamples",
                  "maxShadingSamples",
                  "volumeSamplesOverride",
                  "volumeSamples",
                  "depthJitter",
                  "ignoreSelfShadowing",
                  "primaryVisibility",
                  "compInstObjGroups",
                  "localPosition",
                  "localScale"]

        for extra in extras:
            self.suppress(extra)
        
        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        self.endScrollLayout()

