# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiRandomTemplate(ShaderAETemplate):
    def inputTypeChanged(self, nodeName):
        fullAttr = '%s.%s'%(nodeName, "inputType")
        inputTypeValue = pm.getAttr(fullAttr)
        
        pm.editorTemplate(dimControl=(nodeName, "inputInt", (False if inputTypeValue == 0  else True)))
        pm.editorTemplate(dimControl=(nodeName, "inputFloat", (False if inputTypeValue == 1  else True)))
        pm.editorTemplate(dimControl=(nodeName, "inputColor", (False if inputTypeValue == 2  else True)))
    
    def setup(self):
    	self.addSwatch()
        self.beginScrollLayout()

        self.beginLayout('', collapse=False)
        self.addControl('inputType', label='', changeCommand=self.inputTypeChanged)
        self.addControl('inputInt', label='Int')
        self.addControl('inputFloat', label='')
        self.addControl('inputColor', label='ɫ')
        self.endLayout()
        self.addControl('seed', label='')
        self.addControl('grayscale', label='Ҷ')
        
        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.addExtraControls()
        self.endScrollLayout()
