# -*- coding: utf-8 -*
import pymel.core as pm
import mtoa.utils as utils
import mtoa.ui.ae.utils as aeUtils
import maya.cmds as cmds
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiPhysicalSkyTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()
        
        self.beginLayout("", collapse=False)
        
        self.addControl("turbidity", label="Ƕ")
        self.addControl("groundAlbedo", label="淴")
        
        self.addControl("elevation", label="", annotation="WARNING : Linking rendertime graphs are not supported!")
        self.addControl("azimuth", label="λ", annotation="WARNING : Linking rendertime graphs are not supported!")
        self.addControl("intensity", label="ǿ")
        
        self.addSeparator()
        
        self.addControl("skyTint", label="ɫ")
        self.addControl("sunTint", label="̫ɫ")
        self.addControl("sunSize", label="̫С")
        self.addControl("enableSun", label="̫")
        
        self.endLayout()
        
        pm.mel.AEdependNodeTemplate(self.nodeName)
        self.addExtraControls()
        self.endScrollLayout()

