# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiMotionVectorTemplate(ShaderAETemplate):
    def checkRaw(self, nodeName):
        fullAttr = '%s.%s'%(nodeName, "raw")
        rawValue = pm.getAttr(fullAttr)
        
        dim = rawValue
        pm.editorTemplate(dimControl=(nodeName, "maxDisplace", dim))
        
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()
        
        self.beginLayout("˶", collapse=False)
    
        self.addControl("time0", label="ʼʱ")
        self.addControl("time1", label="ʱ")
        self.addSeparator()
        self.addControl("raw", changeCommand=self.checkRaw, label="ԭʼ")
        self.addControl("maxDisplace", label="λ")
        
        self.endLayout()
        
        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        self.endScrollLayout()
    
