# -*- coding: utf-8 -*-
import mtoa.ui.ae.utils as aeUtils
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiLightDecayTemplate(ShaderAETemplate):
    def checkNearAtten(self, nodeName):
        fullAttr = '%s.%s'%(nodeName, "use_near_atten")
        rawValue = pm.getAttr(fullAttr)
        
        dim = not rawValue
        pm.editorTemplate(dimControl=(nodeName, "nearStart", dim))
        pm.editorTemplate(dimControl=(nodeName, "nearEnd", dim))

    def checkFarAtten(self, nodeName):
        fullAttr = '%s.%s'%(nodeName, "use_far_atten")
        rawValue = pm.getAttr(fullAttr)
        
        dim = not rawValue
        pm.editorTemplate(dimControl=(nodeName, "farStart", dim))
        pm.editorTemplate(dimControl=(nodeName, "farEnd", dim))

    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()
        
        self.beginLayout('˥', collapse=False)

        self.addControl('useNearAtten', changeCommand=self.checkNearAtten, label='ʹý˥')
        self.addControl('nearStart', label='˥ʼ')
        self.addControl('nearEnd', label='˥')

        self.addSeparator()
        
        self.addControl('useFarAtten', changeCommand=self.checkFarAtten, label='ʹԶ˥')
        self.addControl('farStart', label='˥ʼ')
        self.addControl('farEnd', label='˥')
        
        self.endLayout()
        
        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        self.endScrollLayout()

