# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.utils as utils
import mtoa.ui.ae.utils as aeUtils
import maya.cmds as cmds
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate
import maya.mel as mel

class AEaiImageTemplate(ShaderAETemplate):
    def filenameEdit(self, newFilename) :
        attr = self.nodeAttr('filename')
        cmds.setAttr(attr, newFilename, type="string")
        attr = self.nodeAttr('colorSpace')
        ignoreFileRules =  cmds.getAttr(self.nodeAttr('ignoreColorSpaceFileRules'))

        # if ignoreFileRules is enabled, we don't want to update the color space (#2843)
        if ignoreFileRules == 0:
            cmds.setAttr(attr, cmds.colorManagementFileRules(evaluate=newFilename), type="string")

    def LoadFilenameButtonPush(self, *args):
        basicFilter = 'All Files (*.*)'
        ret = cmds.fileDialog2(fileFilter=basicFilter, cap='Load Image File',okc='Load',fm=4)
        if ret is not None and len(ret):
            self.filenameEdit(ret[0])
            cmds.textFieldGrp("filenameImageGrp", edit=True, text=ret[0])

    def filenameNew(self, nodeName):
        #cmds.rowLayout(nc=3)
        cmds.rowLayout(nc=2, cw2=(360,30), cl2=('left', 'left'), adjustableColumn=1, columnAttach=[(1, 'left', -4), (2, 'left', 0)])
        path = cmds.textFieldGrp("filenameImageGrp", label="ͼ", changeCommand=self.filenameEdit)
        cmds.textFieldGrp(path, edit=True, text=cmds.getAttr(nodeName))
        cmds.symbolButton( image='navButtonBrowse.png', command=self.LoadFilenameButtonPush)

    def filenameReplace(self, nodeName):
        cmds.textFieldGrp( "filenameImageGrp", edit=True, text=cmds.getAttr(nodeName) )

    @staticmethod
    def editUVSet(newValue):
        try:
            if len(newValue) > 0:
                cmds.attrFieldGrp('aiImageUVCoords', edit=True, enable=False)
            else:
                cmds.attrFieldGrp('aiImageUVCoords', edit=True, enable=True)
            mel.eval('refreshAE')
        except:
            import traceback, sys
            traceback.print_exc(file=sys.__stderr__)

    def uvsetNew(self, attrName):
        cmds.setUITemplate('attributeEditorPresetsTemplate', pushTemplate=True)
        aeUtils.attrTextFieldGrp('aiImageUVSet', label='UV Set', attribute=attrName, changeCommand=AEaiImageTemplate.editUVSet)
        cmds.setUITemplate(popTemplate=True)

    def uvsetReplace(self, attrName):
        try:
            aeUtils.attrTextFieldGrp('aiImageUVSet', edit=True, attribute=attrName, changeCommand=AEaiImageTemplate.editUVSet)
        except:
            pass

    def uvcoordsNew(self, attrName):
        cmds.setUITemplate('attributeEditorPresetsTemplate', pushTemplate=True)
        enabled = True
        if len(cmds.getAttr('%s.uvset' % attrName.split('.')[0])) > 0:
            enabled = False
        cmds.attrFieldGrp('aiImageUVCoords', label='UV Coords', enable=enabled, attribute=attrName)
        cmds.setUITemplate(popTemplate=True)

    def uvcoordsReplace(self, attrName):
        try:
            enabled = True
            if len(cmds.getAttr('%s.uvset' % attrName.split('.')[0])) > 0:
                enabled = False
            cmds.attrFieldGrp('aiImageUVCoords', edit=True, enable=enabled, attribute=attrName)
        except:
            pass

##   In case we need an attribute "imageName" so that colorSpace is updated correctly
#    def imageNameConnect(self, attrName):
#        if not cmds.isConnected(self.nodeAttr('filename'), self.nodeAttr('imageName')):
#            cmds.connectAttr(self.nodeAttr('filename'), self.nodeAttr('imageName'))


    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()
        
        self.beginLayout("ͼ", collapse=False)
        self.addCustom('filename', self.filenameNew, self.filenameReplace)
        self.addControl("filter", label="")
        
        self.addControl("mipmap_bias", label="ͼƫ")
        self.addControl("multiply", label="")
        self.addControl("offset", label="")
        # self.addCustom('imageName', self.imageNameConnect, self.imageNameConnect)
    

        cmds.editorTemplate('AEcolorSpaceNew', 'AEcolorSpaceReplace', 'colorSpace', callCustom=True)
        self.addControl("ignoreColorSpaceFileRules", label="ɫʿռļ")
        self.addControl("autoTx", label="ԶTX")
        self.addSeparator()
        
        self.addControl("ignoreMissingTextures", label="ȱ")
        self.addControl("missingTextureColor", label="ȱɫ")
        self.endLayout()
        
        self.beginLayout("UV", collapse=True)
        self.beginNoOptimize()
        self.addCustom('uvset', self.uvsetNew, self.uvsetReplace)
        self.addSeparator()
        self.addCustom('uvcoords', self.uvcoordsNew, self.uvcoordsReplace)
        
        self.addControl("soffset", label=" U")
        self.addControl("toffset", label=" V")
        
        self.addControl("swrap", label=" U")
        self.addControl("twrap", label=" V")
        
        self.addControl("sscale", label=" U")
        self.addControl("tscale", label=" V")
        
        self.addControl("sflip", label="ת U")
        self.addControl("tflip", label="ת V")
        
        self.addControl("swap_st", label=" UV")

        self.endNoOptimize()
        self.endLayout()
        
        pm.mel.AEdependNodeTemplate(self.nodeName)
        self.addExtraControls()
        self.endScrollLayout()

