# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.utils as utils
import mtoa.ui.ae.utils as aeUtils
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate


class AEaiFlatTemplate(ShaderAETemplate):

    def setup(self):
        self.addSwatch()
       
        self.beginScrollLayout()
        
        self.addCustom('message', 'AEshaderTypeNew', 'AEshaderTypeReplace')

        self.beginLayout('ƹ/', collapse=False)
        self.addControl('color', label='ɫ')
        self.endLayout()

        self.beginLayout('Matte', collapse=True)
        self.addControl('aiEnableMatte', label='ƹ')
        self.addControl('aiMatteColor', label='ƹɫ')
        self.addControl('aiMatteColorA', label='ƹⲻ͸')
        self.endLayout()
        
        # include/call base class/node attributes
        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.addExtraControls()
        
        self.endScrollLayout()
