# -*- coding: utf-8 -*-
import maya.cmds as cmds
import pymel.core as pm
import mtoa.ui.ae.templates as templates
import mtoa.utils as utils
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate


class AEaiCurveCollectorTemplate(ShaderAETemplate):

    def setup(self):
        self.beginScrollLayout()
        self.beginLayout("", collapse=False)
        self.addControl('aiMode', label='ģʽ')
        
        self.addControl('aiCurveWidth', label='')
        pm.mel.AEaddRampControl(self.nodeName + '.aiWidthProfile')
        self.addSeparator()
        self.addControl('aiSampleRate', label='')

        self.addControl('aiCurveShader', label='ɫ')
        self.addControl('aiExportRefPoints', label='ο')

        self.addControl('aiMinPixelWidth', label='Сؿ')
        self.addSeparator()
        
        self.addControl("aiUserOptions", label="ûѡ")
        self.addSeparator()

        # FIXME is there a way to use the code in templates.py in ShapeMixin ?
        self.addControl("aiOpaque", label="͸")
        self.addControl("aiMatte", label="ƹ")

        self.beginLayout("ܼ", collapse=False)
        self.addControl("primaryVisibility", label="")
        self.addControl("castsShadows", label="Ӱ")
        self.addControl("aiVisibleInDiffuseReflection", label="")
        self.addControl("aiVisibleInSpecularReflection", label="淴")
        self.addControl("aiVisibleInDiffuseTransmission", label="͸")
        self.addControl("aiVisibleInSpecularTransmission", label="͸")
        self.addControl("aiVisibleInVolume", label="")
        self.addControl("aiSelfShadows", label="Ӱ")
        self.addControl("aiTraceSets", label="ټ")
        self.endLayout()

        self.endLayout()

        self.beginLayout('ʾ', collapse=True)
        self.addControl('visibility', label="ܼ")
        self.addControl('template', label="ģ")
        self.addControl('ghosting', label="Ӱ")
        self.addControl('intermediateObject', label="м")
        self.endLayout()
        
        self.beginLayout('Ƹ', collapse=True)
        self.addControl('overrideDisplayType', label="ʾ")
        self.addControl('overrideLevelOfDetail', label="ϸڼ")
        self.addControl('overrideShading', label="ɫ")
        self.addControl('overrideTexturing', label="")
        self.addControl('overridePlayback', label="ǲ")
        self.addControl('overrideEnabled', label="")
        self.addControl('useObjectColor', label="ʹöɫ")
        self.addControl('objectColor', label="ɫ")
        self.endLayout()
    

        # include/call base class/node attributes
        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.suppress('blackBox')
        self.suppress('containerType')
        self.suppress('templateName')
        self.suppress('viewName')
        self.suppress('iconName')
        self.suppress('templateVersion')
        self.suppress('uiTreatment')
        self.suppress('customTreatment')
        self.suppress('creator')
        self.suppress('creationDate')
        self.suppress('rmbCommand')
        self.suppress('templatePath')
        self.suppress('viewMode')
        self.suppress('ignoreHwShader')
        self.suppress('boundingBoxScale')
        self.suppress('featureDisplacement')
        self.suppress('boundingBoxScale')
        self.suppress('initialSampleRate')
        self.suppress('extraSampleRate')
        self.suppress('textureThreshold')
        self.suppress('normalThreshold')
        self.suppress('lodVisibility')
        self.suppress('ghostingControl')
        self.suppress('ghostPreSteps')
        self.suppress('ghostPostSteps')
        self.suppress('ghostStepSize')
        self.suppress('ghostRangeStart')
        self.suppress('ghostRangeEnd')
        self.suppress('ghostDriver')
        self.suppress('ghostFrames')
        self.suppress('ghosting')
        self.suppress('ghostCustomSteps')
        self.suppress('ghostColorPreA')
        self.suppress('ghostColorPre')
        self.suppress('ghostColorPostA')
        self.suppress('ghostColorPost')
        self.suppress('tweak')
        self.suppress('relativeTweak')
        self.suppress('currentUVSet')
        self.suppress('displayImmediate')
        self.suppress('displayColors')
        self.suppress('displayColorChannel')
        self.suppress('currentColorSet')
        self.suppress('smoothShading')
        self.suppress('drawOverride')
        self.suppress('shadingSamples')
        self.suppress('maxVisibilitySamplesOverride')
        self.suppress('maxVisibilitySamples')
        self.suppress('antialiasingLevel')
        self.suppress('maxShadingSamples')
        self.suppress('shadingSamplesOverride')
        self.suppress('geometryAntialiasingOverride')
        self.suppress('antialiasingLevel')
        self.suppress('volumeSamplesOverride')
        self.suppress('volumeSamples')
        self.suppress('depthJitter')
        self.suppress('ignoreSelfShadowing')
        self.suppress('controlPoints')
        self.suppress('colorSet')
        self.suppress('uvSet')
        self.suppress('weights')
        self.suppress('renderInfo')
        self.suppress('renderLayerInfo')
        self.suppress('compInstObjGroups')
        self.suppress('instObjGroups')
        self.suppress('collisionOffsetVelocityIncrement')
        self.suppress('collisionOffsetVelocityMultiplier')
        self.suppress('collisionDepthVelocityMultiplier')
        self.suppress('collisionDepthVelocityIncrement')
    

        self.addExtraControls()        
        self.endScrollLayout()
