# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiColorJitterTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()

        self.addControl('input', label='')

        self.beginLayout('û', collapse=False)
        self.addControl('dataInput', label='')
        self.addControl('dataGainMin', label='С')
        self.addControl('dataGainMax', label='')
        self.addControl('dataHueMin', label='Сɫ')
        self.addControl('dataHueMax', label='ɫ')
        self.addControl('dataSaturationMin', label='СͶ')
        self.addControl('dataSaturationMax', label='󱥺Ͷ')
        self.addControl('dataSeed', label='')
        self.endLayout()

        self.beginLayout('', collapse=False)
        self.addControl('procGainMin', label='С')
        self.addControl('procGainMax', label='')
        self.addControl('procHueMin', label='Сɫ')
        self.addControl('procHueMax', label='ɫ')
        self.addControl('procSaturationMin', label='СͶ')
        self.addControl('procSaturationMax', label='󱥺Ͷ')
        self.addControl('procSeed', label='')
        self.endLayout()

        self.beginLayout('', collapse=False)
        self.addControl('objGainMin', label='С')
        self.addControl('objGainMax', label='')
        self.addControl('objHueMin', label='Сɫ')
        self.addControl('objHueMax', label='ɫ')
        self.addControl('objSaturationMin', label='СͶ')
        self.addControl('objSaturationMax', label='󱥺Ͷ')
        self.addControl('objSeed', label='')
        self.endLayout()

        self.beginLayout('', collapse=False)
        self.addControl('faceGainMin', label='С')
        self.addControl('faceGainMax', label='')
        self.addControl('faceHueMin', label='Сɫ')
        self.addControl('faceHueMax', label='ɫ')
        self.addControl('faceSaturationMin', label='СͶ')
        self.addControl('faceSaturationMax', label='󱥺Ͷ')
        self.addControl('faceSeed', label='')
        self.endLayout()


        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        self.endScrollLayout()


