# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiColorCorrectTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()

        self.addControl('input', label='')
        self.addControl('mask', label='')
        self.beginLayout('ɫУ', collapse=False)

        self.addControl('gamma', label='Gamma')
        self.addControl('hueShift', label='ɫɫ')
        self.addControl('saturation', label='Ͷ')
        self.addControl('contrast', label='Աȶ')
        self.addControl('contrastPivot', label='Ա͸')
        self.addControl('exposure', label='ع')
        self.addControl('multiply', label='')
        self.addControl('add', label='')
        self.addControl('invert', label='')
        self.endLayout()

        self.beginLayout('Alpha', collapse=False)
        self.addControl('alphaIsLuminance', label='')
        self.addControl('alphaMultiply', label='')
        self.addControl('alphaAdd', label='')
        self.addControl('invertAlpha', label='')
        self.endLayout()

        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        self.endScrollLayout()

