# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiBarndoorTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        
        self.beginScrollLayout()
        
        self.beginLayout('Barndoor', collapse=False)
        self.addControl('barndoorTopLeft', label='Ͻ')
        self.addControl('barndoorTopRight', label='Ͻ')
        self.addControl('barndoorTopEdge', label='Ե')        
        self.addSeparator()
        self.addControl('barndoorBottomLeft', label='·')
        self.addControl('barndoorBottomRight', label='·')
        self.addControl('barndoorBottomEdge', label='ײԵ')
        self.addSeparator()
        self.addControl('barndoorLeftTop', label='Ϸ')
        self.addControl('barndoorLeftBottom', label='·')
        self.addControl('barndoorLeftEdge', label='Ե')
        self.addSeparator()
        self.addControl('barndoorRightTop', label='Ϸ')
        self.addControl('barndoorRightBottom', label='·')
        self.addControl('barndoorRightEdge', label='ұԵ')
        self.endLayout()
        
        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.addExtraControls()
        self.endScrollLayout()

