# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiAtmosphereVolumeTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        
        self.beginScrollLayout()
        
        self.beginLayout('', collapse=False)
        self.addControl('density', label='ܶ')
        self.addControl('rgbDensity', label='ɫ')
        self.addSeparator()
        self.addControl('attenuation', label='˥')
        self.addControl('rgbAttenuation', label='ɫ˥')
        self.addSeparator()
        self.addControl('eccentricity', label='')
        self.addSeparator()
        self.addControl('samples', label='')
        self.endLayout()
        
        self.beginLayout('Contribution')
        self.addControl('affectCamera', label='')
        self.addControl('affectDiffuse', label='')
        self.addControl('affectSpecular', label='(߹⣩')
        self.endLayout()
        
        pm.mel.AEdependNodeTemplate(self.nodeName)
        
        self.addExtraControls()
        self.endScrollLayout()

