# -*- coding: utf-8 -*-
import pymel.core as pm
import mtoa.ui.ae.lightTemplate as lightTemplate
import mtoa.ui.ae.aiSwatchDisplay as aiSwatchDisplay
import mtoa.ui.ae.templates as templates

class AEaiAreaLightTemplate(lightTemplate.LightTemplate):
    def addSwatch(self):
        self.addCustom("message", aiSwatchDisplay.aiSwatchDisplayNew, aiSwatchDisplay.aiSwatchDisplayReplace)

    def makeLightExclusive(self, attr):
        lightName = attr.split(".")[0]
        pm.rowLayout(nc=2, cal=[2, 'left'])
        pm.text(label="")
        pm.exclusiveLightCheckBox('exclusiveButton', light=lightName, label="Ĭ")
        pm.setParent('..')
        
    def replaceLightExclusive(self, attr):
        lightName = attr.split(".")[0]
        pm.exclusiveLightCheckBox('exclusiveButton', edit=True, light=lightName)
    
    def setup(self):        
        self.addSwatch()

        self.beginScrollLayout()

        self.beginLayout("Arnold", collapse=False)

        self.addControl("color", label = "ɫ")
        self.addControl("intensity", label = "ǿ")
        self.addControl("aiExposure", label = "ع")
        self.addSeparator()        
        self.setupColorTemperature("ArnoldArea")
        self.addCustom("instObjGroups", self.makeLightExclusive, self.replaceLightExclusive)
        
        self.addChildTemplate('aiTranslator', templates.getNodeTemplate('aiAreaLight'))
        
        self.addSeparator()

        self.commonLightAttributes()
        
        self.endLayout()

        # include/call base class/node attributes
        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        suppressList = ['aiShadowDensity', 'aiCastShadows', 'update',
            'aiSamples', 'aiNormalize', 'aiColorTemperature',
            'aiShadowColor', 'aiResolution', 'ghostFrames',
            'motionBlur', 'visibleInReflections', 'visibleInRefractions',
            'castsShadows', 'receiveShadows', 'maxVisibilitySamplesOverride',
            'maxVisibilitySamples', 'geometryAntialiasingOverride', 'antialiasingLevel',
            'shadingSamplesOverride', 'shadingSamples', 'maxShadingSamples',
            'volumeSamplesOverride', 'volumeSamples', 'layerRenderable',
            'ghostingControl', 'ghostCustomSteps', 'ghostColorPreA',
            'ghostColorPre', 'ghostColorPostA', 'ghostColorPost',
            'ghostRangeStart', 'ghostRangeEnd', 'ghostDriver',
            'depthJitter', 'ignoreSelfShadowing', 'primaryVisibility',
            'localPosition', 'localScale', 'pointCamera', 'normalCamera',
            'visibility', 'intermediateObject', 'template', 'ghosting',
            'objectColorRGB', 'useObjectColor', 'objectColor',
            'containerType', 'creationDate', 'creator',
            'customTreatment', 'uiTreatment', 'templateVersion',
            'viewMode', 'iconName', 'viewName', 'templatePath',
            'rmbCommand', 'blackBox', 'drawOverride',
            'renderInfo', 'renderLayerInfo', 'compInstObjGroups',
            'lodVisibility', 'templateName', 'selectionChildHighlighting']
        for sup in suppressList:
            self.suppress(sup)
        self.endScrollLayout()

class BaseAreaLightTemplate(lightTemplate.LightTemplate):
    def addCommonParameters(self):
        self.addControl("aiSamples", label = "")
        self.addControl("aiNormalize", label = "ͳһ")

        self.addSeparator()

        self.addControl("aiCastShadows", label = "ͶӰ")
        self.addControl("aiShadowDensity", label = "Ӱܶ")
        self.addControl("aiShadowColor", label = "Ӱɫ")

    def setup(self):
        self.addCommonParameters()       
        
class QuadAreaLightTemplate(BaseAreaLightTemplate):
    def setup(self):
        self.addControl("aiSpread", label = "ɢ")
        self.addControl("aiResolution", label = "ֱ")
        self.addControl("aiRoundness", label = "Բ")
        self.addControl("aiSoftEdge", label = "")
        #self.addControl("aiPortal")  hiding it as we now have a dedicated light portal node
        self.addSeparator()
        self.addCommonParameters()

class DiskAreaLightTemplate(BaseAreaLightTemplate):
    def setup(self):
        self.addControl("aiSpread")
        self.addSeparator()
        self.addCommonParameters()

class MeshLightTemplate(BaseAreaLightTemplate):
    def setup(self):
        self.addControl("color")
        self.addControl("intensity")
        self.addControl("aiExposure", label = "ع")
        self.addSeparator()        
        self.setupColorTemperature("ArnoldArea")
        
        self.addSeparator()
        self.addControl("lightVisible")
        
        self.addSeparator()
        
        self.addCommonParameters()

        self.addSeparator()

        self.commonLightAttributes(False)

        self.beginLayout('Subdivision', collapse=True)
        self.addControl("aiSubdivType", label="")
        self.addControl("aiSubdivIterations", label="")
        self.addControl("aiSubdivAdaptiveMetric", label="Ӧ")
        self.addControl("aiSubdivPixelError", label="Ӧ")
        self.addControl("aiSubdivAdaptiveSpace", label="Ӧռ")
        # TODO: add dicing camera UI
        #self.addControl("aiSubdivDicingCamera", label="Dicing Camera")
        self.addControl("aiSubdivUvSmoothing", label="UVƽ")
        self.addControl("aiSubdivSmoothDerivs", label="ƽ")
        self.endLayout()

        self.addControl("aiUserOptions", "User Options")


templates.registerAETemplate(templates.TranslatorControl, "aiAreaLight", label="ƹ״")
templates.registerTranslatorUI(QuadAreaLightTemplate, "aiAreaLight", "quad")
templates.registerTranslatorUI(BaseAreaLightTemplate, "aiAreaLight", "cylinder")
templates.registerTranslatorUI(DiskAreaLightTemplate, "aiAreaLight", "disk")
templates.registerDefaultTranslator('aiAreaLight', "quad")
templates.registerTranslatorUI(MeshLightTemplate, "mesh", "mesh_light")
