# -*- coding: utf-8 -*-
import pymel.core as pm
from mtoa.ui.ae.shaderTemplate import ShaderAETemplate

class AEaiAmbientOcclusionTemplate(ShaderAETemplate):
    def setup(self):
        self.addSwatch()
        self.beginScrollLayout()

        self.addCustom('message', 'AEshaderTypeNew', 'AEshaderTypeReplace')

        self.beginLayout('', collapse=False)
        self.addControl('samples', label='')
        self.addControl('spread', label='ɢ')
        self.addControl('falloff', label='˥')
        self.addControl('near_clip', label='')
        self.addControl('far_clip', label='Զ')
        self.addSeparator()
        self.addControl('white', label='ɫ')
        self.addControl('black', label='ɫ')        
        self.addControl('opacity', label='͸')       
        self.addSeparator()
        self.beginNoOptimize()
        self.addControl('invertNormals', label='ת')
        self.addControl('selfOnly', label='')
        self.endNoOptimize()
        self.addControl('normalCamera', label='')
        self.endLayout()

        pm.mel.AEdependNodeTemplate(self.nodeName)

        self.addExtraControls()
        self.endScrollLayout()

