texture gTexture0;
uniform extern float2 gRatio = float2(1, 1);
uniform extern float4x4 gWVP : WorldViewProjection;
uniform extern float4x4 gEffectiveRectEdges; // Jeder Zeile in der Matrix repräsentiert einen Vektor mit Startpunkt: [StartX, StartY, RichtungX, RichtungY]. Die Richtung im rechten Winkel zur eigentlichen Richtung und ist Ratio-Korrigiert und normalisiert
uniform extern float4x4 gPageRectEdges; // Jeder Zeile in der Matrix repräsentiert einen Vektor mit Startpunkt: [StartX, StartY, RichtungX, RichtungY]. Die Richtung im rechten Winkel zur eigentlichen Richtung und ist Ratio-Korrigiert und normalisiert
uniform extern float3 gBrightness = float3(0, 0, 0); // Normal, effektiv, Objekt
uniform extern float3 gContrast = float3(0, 0, 0); // Normal, effektiv, Objekt

sampler Sampler1 = sampler_state
{
  texture = <gTexture0>;
};

struct OutputVS
{
  float4 posH: POSITION0;
  float2 tex0: TEXCOORD0;
};

OutputVS VSPanning(float3 pos : POSITION, float2 tex0: TEXCOORD0) {
  OutputVS outVS;

  outVS.posH = mul(float4(pos.xy * gRatio, pos.z, 1.0), gWVP);
  outVS.tex0 = tex0;

  return outVS;
}

float Dash(float2 position) {
  position *= 100;
  return (fmod(floor(position.x + position.y), 2) < 1) ? 0.5 : 1;
}

float Brightness(float3 color) {
  color *= float3(0.3333, 0.3334, 0.3333);
  return color.r + color.g + color.b;
}

float4 BlendPremultiplied(float4 src, float4 dst) {
  return src + dst * (1 - src.a);
}

float min4(float a, float b, float c, float d)
{
  return min(min(a, b), min(c, d));
}

float DistanceToLine(float2 vec, float2 lineStart, float2 lineDirection)
{
//  return (dot((vec - lineStart) * gRatio, mul(normalize((lineEnd - lineStart) * gRatio), rotationZ2(1.570796326))));
  return -dot((vec - lineStart) * gRatio, lineDirection);
}

float4 PSPanning(float2 tex0 : TEXCOORD0) : COLOR
{
  float4 color = tex2D(Sampler1, tex0);

  float distancePage = -min4(
    DistanceToLine(tex0.xy, gPageRectEdges[0].xy, gPageRectEdges[0].zw),
    DistanceToLine(tex0.xy, gPageRectEdges[1].xy, gPageRectEdges[1].zw),
    DistanceToLine(tex0.xy, gPageRectEdges[2].xy, gPageRectEdges[2].zw),
    DistanceToLine(tex0.xy, gPageRectEdges[3].xy, gPageRectEdges[3].zw)
    ); // negative Werte sind im Rahmen, positive außerhalb

  if (distancePage > 0) discard; // Pixel liegt außerhalb der Seite -> verwerfen, so das später der LayoutDesigner-Hintergrund an dieser Stelle erscheint

  // Test, ob Pixel innherhalb des effektiven Rechtecks liegt
  float distance = -min4(
    DistanceToLine(tex0.xy, gEffectiveRectEdges[0].xy, gEffectiveRectEdges[0].zw),
    DistanceToLine(tex0.xy, gEffectiveRectEdges[1].xy, gEffectiveRectEdges[1].zw),
    DistanceToLine(tex0.xy, gEffectiveRectEdges[2].xy, gEffectiveRectEdges[2].zw),
    DistanceToLine(tex0.xy, gEffectiveRectEdges[3].xy, gEffectiveRectEdges[3].zw)
    ); // negative Werte sind im Rahmen, positive außerhalb

  float alpha = smoothstep(-0.0005, 0, distance); // Abgrenzung von Bildinnerem zum -Äußeren inkl. weichem Bereich fürs Antialiasing
  float4 dashColor;
  dashColor.a = 0.15 + (1 - color.a) * 0.5; // Dashes dort stärker, wo das Bild transparent ist
  dashColor.a *= alpha;
  dashColor.rgb = Dash(tex0 * gRatio) * dashColor.a;

  color.rgb = lerp(color.rgb, Brightness(color.rgb) * 0.5 + 0.5, 0.8 * alpha); // entfärben
  color = BlendPremultiplied(dashColor, color);

  // schwarzer Rand
  alpha = (1 - smoothstep(-0.0005, 0.01, distance)) * alpha * 0.5;
  color = float4(0, 0, 0, alpha) + color * (1 - alpha);

  return color;
}

technique Panning
{
  pass pImage
  {
    VertexShader = compile vs_3_0 VSPanning();
    PixelShader = compile ps_3_0 PSPanning();
    FillMode = solid;
    // FillMode = wireframe;

    AlphaBlendEnable = true;
    BlendOp = Add;
    SrcBlend = One;
    DestBlend = InvSrcAlpha;
  }
}

