var translationDictionary = {};
var debug = false;
var language = '';

function GetTranslation(id)
{
  if (id === '')
    return id; // keine Leerstrings übersetzen

  var result = translationDictionary[id];

  if (!result)
  {
    result = id;
    if (debug)
      result = '_(' + id + ')!';
  }

  return result;
}

function translate()
{
  $(".translate").each(function(index, element) {
    if (element.nodeName === 'INPUT')
      element.placeholder = GetTranslation(element.placeholder); else
    if (element.nodeName === 'IMG')
      element.src = GetTranslation(element.src); else
      element.innerText = GetTranslation(element.innerText);
  });
}

function loadDictionary(callbackAfterTranslate)
{
  var generateBaseDictionary = getParameterByName('po') === 'true';
  if (generateBaseDictionary)
  {
    generatePO();
    return
  }

  language = getParameterByName('lang');
  var dictionaryFilename = 'locale/' + language + '/translation.js';
  var callback;
  loadScript(dictionaryFilename,
    function () {
      translate();
      if (callbackAfterTranslate) callbackAfterTranslate();
    });
  debug = getParameterByName('debug') === 'true';
}

function generateCode(content)
{
  var element = document.createElement("pre")
  element.innerHTML = content;
  document.getElementsByTagName("body")[0].appendChild(element);
}

function generatePO()
{
  // alle Strings sammeln
  var poItems = $(".translate").map(function() {
    if (this.nodeName === 'INPUT')
      return this.placeholder;
    if (this.nodeName === 'IMG')
      return this.src;

    return this.innerText;
  }).get();

  // Sortieren
  poItems.sort();

  // Duplikate entfernen
  for (var i = poItems.length - 1; i > 0; i--) {
    if (poItems[i] === poItems[i - 1])
      poItems.splice(i, 1);
  }

  // Inhalt der PO-Datei als String erzeugen
  var po = "";
  for (var i = 0; i < poItems.length; i++) {
    var item = poItems[i];
    po = po + 'msgid "' + item + '"\nmsgstr ""\n\n';
  }
  $('body').empty();
  generateCode(po);
}

function addLanguageToLink(elements)
{
  var querystring = '?lang=' + language;
  if (debug)
    querystring += '&debug=true';
  for (var i = 0; i < elements.length; i++)
  {
    elements[i].attr('href', elements[i].attr('href') + querystring);
  }
}