uniform extern float4x4 gWVP : WorldViewProjection;
uniform extern texture gTexture0;
uniform extern texture gTexture1;
uniform extern float4x4 gTexTransform;

sampler TextureSampler0 = sampler_state
{
  Texture = <gTexture0>;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  MipFilter = LINEAR;
  AddressU = CLAMP;
  AddressV = CLAMP;
};

sampler TextureSampler1 = sampler_state
{
  Texture = <gTexture1>;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  MipFilter = LINEAR;
  AddressU = CLAMP;
  AddressV = CLAMP;
};

struct OutputVS
{
	float4 posH: POSITION0;
	float2 tex0: TEXCOORD0;
};

OutputVS mainVS(float3 pos : POSITION, float2 tex0: TEXCOORD0) {
	OutputVS outVS;

	outVS.posH = mul(float4(pos.xyz, 1.0f), gWVP);
	outVS.tex0 = mul(float3(tex0, 1.0f), gTexTransform).xy;

	return outVS;
}

float4 mainPS(float2 Tex : TEXCOORD0) : COLOR
{
	float4 color_fg = tex2D(TextureSampler1, Tex);
	float4 color_bg = tex2D(TextureSampler0, Tex);
	float4 color = color_fg;
	if (color_bg.a > 0)
		color.rgb += color_bg.rgb + 0.1;

	return color;
}

technique Occlusion {
	pass p0 {
		CullMode = None;
		VertexShader = compile vs_2_0 mainVS();
		PixelShader = compile ps_2_0 mainPS();
		// FillMode = wireframe;
		FillMode = solid;

		AlphaBlendEnable = true;
		BlendOp = Add;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

