/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodProtoReference;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderProtoPool;
import org.jf.dexlib2.writer.builder.BuilderStringPool;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;

class BuilderMethodPool
extends BaseBuilderPool
implements MethodSection<BuilderStringReference, BuilderTypeReference, BuilderMethodProtoReference, BuilderMethodReference, BuilderMethod> {
    private final ConcurrentMap<MethodReference, BuilderMethodReference> internedItems = Maps.newConcurrentMap();

    public BuilderMethodPool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderMethodReference internMethod(MethodReference methodReference) {
        BuilderMethodReference ret = (BuilderMethodReference)this.internedItems.get(methodReference);
        if (ret != null) {
            return ret;
        }
        BuilderMethodReference dexPoolMethodReference = new BuilderMethodReference(((BuilderTypePool)this.dexBuilder.typeSection).internType(methodReference.getDefiningClass()), ((BuilderStringPool)this.dexBuilder.stringSection).internString(methodReference.getName()), ((BuilderProtoPool)this.dexBuilder.protoSection).internMethodProto(methodReference));
        ret = this.internedItems.putIfAbsent(dexPoolMethodReference, dexPoolMethodReference);
        return ret == null ? dexPoolMethodReference : ret;
    }

    public BuilderMethodReference internMethod(String definingClass, String name, List<? extends CharSequence> parameters, String returnType) {
        return this.internMethod(new MethodKey(definingClass, name, parameters, returnType));
    }

    @Override
    public BuilderMethodReference getMethodReference(BuilderMethod builderMethod) {
        return builderMethod.methodReference;
    }

    @Override
    public BuilderTypeReference getDefiningClass(BuilderMethodReference key) {
        return key.definingClass;
    }

    @Override
    public BuilderMethodProtoReference getPrototype(BuilderMethodReference key) {
        return key.proto;
    }

    @Override
    public BuilderMethodProtoReference getPrototype(BuilderMethod builderMethod) {
        return builderMethod.methodReference.proto;
    }

    @Override
    public BuilderStringReference getName(BuilderMethodReference key) {
        return key.name;
    }

    @Override
    public int getMethodIndex(BuilderMethod builderMethod) {
        return builderMethod.methodReference.index;
    }

    @Override
    public int getItemIndex(BuilderMethodReference key) {
        return key.index;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderMethodReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderMethodReference>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderMethodReference key) {
                return key.index;
            }

            @Override
            protected int setValue(BuilderMethodReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }

    private static class MethodKey
    extends BaseMethodReference
    implements MethodReference {
        private final String definingClass;
        private final String name;
        private final List<? extends CharSequence> parameterTypes;
        private final String returnType;

        public MethodKey(String definingClass, String name, List<? extends CharSequence> parameterTypes, String returnType) {
            this.definingClass = definingClass;
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        @Override
        public String getDefiningClass() {
            return this.definingClass;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<? extends CharSequence> getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public String getReturnType() {
            return this.returnType;
        }
    }
}

