/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import java.util.List;
import java.util.Set;
import org.jf.dexlib2.base.value.BaseAnnotationEncodedValue;
import org.jf.dexlib2.base.value.BaseArrayEncodedValue;
import org.jf.dexlib2.base.value.BaseBooleanEncodedValue;
import org.jf.dexlib2.base.value.BaseEnumEncodedValue;
import org.jf.dexlib2.base.value.BaseFieldEncodedValue;
import org.jf.dexlib2.base.value.BaseMethodEncodedValue;
import org.jf.dexlib2.base.value.BaseMethodHandleEncodedValue;
import org.jf.dexlib2.base.value.BaseMethodTypeEncodedValue;
import org.jf.dexlib2.base.value.BaseNullEncodedValue;
import org.jf.dexlib2.base.value.BaseStringEncodedValue;
import org.jf.dexlib2.base.value.BaseTypeEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableByteEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableCharEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableLongEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableShortEncodedValue;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethodHandleReference;
import org.jf.dexlib2.writer.builder.BuilderMethodProtoReference;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.util.ExceptionWithContext;

public abstract class BuilderEncodedValues {
    public static BuilderEncodedValue defaultValueForType(String type) {
        switch (type.charAt(0)) {
            case 'Z': {
                return BuilderBooleanEncodedValue.FALSE_VALUE;
            }
            case 'B': {
                return new BuilderByteEncodedValue(0);
            }
            case 'S': {
                return new BuilderShortEncodedValue(0);
            }
            case 'C': {
                return new BuilderCharEncodedValue('\u0000');
            }
            case 'I': {
                return new BuilderIntEncodedValue(0);
            }
            case 'J': {
                return new BuilderLongEncodedValue(0L);
            }
            case 'F': {
                return new BuilderFloatEncodedValue(0.0f);
            }
            case 'D': {
                return new BuilderDoubleEncodedValue(0.0);
            }
            case 'L': 
            case '[': {
                return BuilderNullEncodedValue.INSTANCE;
            }
        }
        throw new ExceptionWithContext("Unrecognized type: %s", type);
    }

    public static class BuilderMethodHandleEncodedValue
    extends BaseMethodHandleEncodedValue
    implements BuilderEncodedValue {
        final BuilderMethodHandleReference methodHandleReference;

        public BuilderMethodHandleEncodedValue(BuilderMethodHandleReference methodHandleReference) {
            this.methodHandleReference = methodHandleReference;
        }

        @Override
        public BuilderMethodHandleReference getValue() {
            return this.methodHandleReference;
        }
    }

    public static class BuilderMethodTypeEncodedValue
    extends BaseMethodTypeEncodedValue
    implements BuilderEncodedValue {
        final BuilderMethodProtoReference methodProtoReference;

        public BuilderMethodTypeEncodedValue(BuilderMethodProtoReference methodProtoReference) {
            this.methodProtoReference = methodProtoReference;
        }

        @Override
        public BuilderMethodProtoReference getValue() {
            return this.methodProtoReference;
        }
    }

    public static class BuilderTypeEncodedValue
    extends BaseTypeEncodedValue
    implements BuilderEncodedValue {
        final BuilderTypeReference typeReference;

        BuilderTypeEncodedValue(BuilderTypeReference typeReference) {
            this.typeReference = typeReference;
        }

        @Override
        public String getValue() {
            return this.typeReference.getType();
        }
    }

    public static class BuilderStringEncodedValue
    extends BaseStringEncodedValue
    implements BuilderEncodedValue {
        final BuilderStringReference stringReference;

        BuilderStringEncodedValue(BuilderStringReference stringReference) {
            this.stringReference = stringReference;
        }

        @Override
        public String getValue() {
            return this.stringReference.getString();
        }
    }

    public static class BuilderShortEncodedValue
    extends ImmutableShortEncodedValue
    implements BuilderEncodedValue {
        public BuilderShortEncodedValue(short value) {
            super(value);
        }
    }

    public static class BuilderNullEncodedValue
    extends BaseNullEncodedValue
    implements BuilderEncodedValue {
        public static final BuilderNullEncodedValue INSTANCE = new BuilderNullEncodedValue();

        private BuilderNullEncodedValue() {
        }
    }

    public static class BuilderMethodEncodedValue
    extends BaseMethodEncodedValue
    implements BuilderEncodedValue {
        final BuilderMethodReference methodReference;

        BuilderMethodEncodedValue(BuilderMethodReference methodReference) {
            this.methodReference = methodReference;
        }

        @Override
        public BuilderMethodReference getValue() {
            return this.methodReference;
        }
    }

    public static class BuilderLongEncodedValue
    extends ImmutableLongEncodedValue
    implements BuilderEncodedValue {
        public BuilderLongEncodedValue(long value) {
            super(value);
        }
    }

    public static class BuilderIntEncodedValue
    extends ImmutableIntEncodedValue
    implements BuilderEncodedValue {
        public BuilderIntEncodedValue(int value) {
            super(value);
        }
    }

    public static class BuilderFloatEncodedValue
    extends ImmutableFloatEncodedValue
    implements BuilderEncodedValue {
        public BuilderFloatEncodedValue(float value) {
            super(value);
        }
    }

    public static class BuilderFieldEncodedValue
    extends BaseFieldEncodedValue
    implements BuilderEncodedValue {
        final BuilderFieldReference fieldReference;

        BuilderFieldEncodedValue(BuilderFieldReference fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        public BuilderFieldReference getValue() {
            return this.fieldReference;
        }
    }

    public static class BuilderEnumEncodedValue
    extends BaseEnumEncodedValue
    implements BuilderEncodedValue {
        final BuilderFieldReference enumReference;

        BuilderEnumEncodedValue(BuilderFieldReference enumReference) {
            this.enumReference = enumReference;
        }

        @Override
        public BuilderFieldReference getValue() {
            return this.enumReference;
        }
    }

    public static class BuilderDoubleEncodedValue
    extends ImmutableDoubleEncodedValue
    implements BuilderEncodedValue {
        public BuilderDoubleEncodedValue(double value) {
            super(value);
        }
    }

    public static class BuilderCharEncodedValue
    extends ImmutableCharEncodedValue
    implements BuilderEncodedValue {
        public BuilderCharEncodedValue(char value) {
            super(value);
        }
    }

    public static class BuilderByteEncodedValue
    extends ImmutableByteEncodedValue
    implements BuilderEncodedValue {
        public BuilderByteEncodedValue(byte value) {
            super(value);
        }
    }

    public static class BuilderBooleanEncodedValue
    extends BaseBooleanEncodedValue
    implements BuilderEncodedValue {
        public static final BuilderBooleanEncodedValue TRUE_VALUE = new BuilderBooleanEncodedValue(true);
        public static final BuilderBooleanEncodedValue FALSE_VALUE = new BuilderBooleanEncodedValue(false);
        private final boolean value;

        private BuilderBooleanEncodedValue(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getValue() {
            return this.value;
        }
    }

    public static class BuilderArrayEncodedValue
    extends BaseArrayEncodedValue
    implements BuilderEncodedValue {
        final List<? extends BuilderEncodedValue> elements;
        int offset = 0;

        BuilderArrayEncodedValue(List<? extends BuilderEncodedValue> elements) {
            this.elements = elements;
        }

        @Override
        public List<? extends EncodedValue> getValue() {
            return this.elements;
        }
    }

    public static class BuilderAnnotationEncodedValue
    extends BaseAnnotationEncodedValue
    implements BuilderEncodedValue {
        final BuilderTypeReference typeReference;
        final Set<? extends BuilderAnnotationElement> elements;

        BuilderAnnotationEncodedValue(BuilderTypeReference typeReference, Set<? extends BuilderAnnotationElement> elements) {
            this.typeReference = typeReference;
            this.elements = elements;
        }

        @Override
        public String getType() {
            return this.typeReference.getType();
        }

        public Set<? extends BuilderAnnotationElement> getElements() {
            return this.elements;
        }
    }

    public static interface BuilderEncodedValue
    extends EncodedValue {
    }
}

