/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.collect.ImmutableList;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.iface.instruction.VariableRegisterInstruction;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.util.ParamUtil;

public abstract class InlineMethodResolver {
    public static InlineMethodResolver createInlineMethodResolver(int odexVersion) {
        if (odexVersion == 35) {
            return new InlineMethodResolver_version35();
        }
        if (odexVersion == 36) {
            return new InlineMethodResolver_version36();
        }
        throw new RuntimeException(String.format("odex version %d is not supported yet", odexVersion));
    }

    protected InlineMethodResolver() {
    }

    private static Method inlineMethod(int accessFlags, String cls, String name, String params, String returnType) {
        ImmutableList<ImmutableMethodParameter> paramList = ImmutableList.copyOf(ParamUtil.parseParamString(params));
        return new ImmutableMethod(cls, name, paramList, returnType, accessFlags, null, null);
    }

    public abstract Method resolveExecuteInline(AnalyzedInstruction var1);

    private static class InlineMethodResolver_version36
    extends InlineMethodResolver {
        private final Method[] inlineMethods;
        private final Method indexOfIMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "indexOf", "I", "I");
        private final Method indexOfIIMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "indexOf", "II", "I");
        private final Method fastIndexOfMethod = InlineMethodResolver.access$000(2, "Ljava/lang/String;", "fastIndexOf", "II", "I");
        private final Method isEmptyMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "isEmpty", "", "Z");

        public InlineMethodResolver_version36() {
            this.inlineMethods = new Method[]{InlineMethodResolver.inlineMethod(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), null, null, InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sin", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToIntBits", "F", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToRawIntBits", "F", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "intBitsToFloat", "I", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToLongBits", "D", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToRawLongBits", "D", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "longBitsToDouble", "J", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "I", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "J", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "F", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "min", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "max", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "sqrt", "D", "D")};
        }

        @Override
        public Method resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + inlineIndex);
            }
            if (inlineIndex == 4) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 2) {
                    return this.indexOfIMethod;
                }
                if (parameterCount == 3) {
                    return this.fastIndexOfMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            if (inlineIndex == 5) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 3) {
                    return this.indexOfIIMethod;
                }
                if (parameterCount == 1) {
                    return this.isEmptyMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            return this.inlineMethods[inlineIndex];
        }
    }

    private static class InlineMethodResolver_version35
    extends InlineMethodResolver {
        private final Method[] inlineMethods = new Method[]{InlineMethodResolver.access$000(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "sin", "D", "D")};

        @Override
        public Method resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid inline index: " + inlineIndex);
            }
            return this.inlineMethods[inlineIndex];
        }
    }
}

