/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import org.jf.baksmali.Adaptors.Format.ArrayDataMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.OffsetInstructionFormatMethodItem;
import org.jf.baksmali.Adaptors.Format.PackedSwitchMethodItem;
import org.jf.baksmali.Adaptors.Format.SparseSwitchMethodItem;
import org.jf.baksmali.Adaptors.Format.UnresolvedOdexInstructionMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib2.analysis.UnresolvedOdexInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;

public class InstructionMethodItemFactory {
    public static InstructionMethodItem makeInstructionFormatMethodItem(MethodDefinition methodDef, int codeAddress, Instruction instruction) {
        if (instruction instanceof OffsetInstruction) {
            return new OffsetInstructionFormatMethodItem(methodDef.classDef.options, methodDef, codeAddress, (OffsetInstruction)instruction);
        }
        if (instruction instanceof UnresolvedOdexInstruction) {
            return new UnresolvedOdexInstructionMethodItem(methodDef, codeAddress, (UnresolvedOdexInstruction)instruction);
        }
        switch (instruction.getOpcode().format) {
            case ArrayPayload: {
                return new ArrayDataMethodItem(methodDef, codeAddress, (ArrayPayload)instruction);
            }
            case PackedSwitchPayload: {
                return new PackedSwitchMethodItem(methodDef, codeAddress, (PackedSwitchPayload)instruction);
            }
            case SparseSwitchPayload: {
                return new SparseSwitchMethodItem(methodDef, codeAddress, (SparseSwitchPayload)instruction);
            }
        }
        return new InstructionMethodItem<Instruction>(methodDef, codeAddress, instruction);
    }
}

