/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirUtil {
    public static void copyToDir(Directory in, Directory out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, Directory out, String fileName) throws DirectoryException {
        DirUtil.copyToDir(in, out, fileName, fileName);
    }

    public static void copyToDir(Directory in, Directory out, String inFile, String outFile) throws DirectoryException {
        try {
            if (in.containsDir(inFile)) {
                in.getDir(inFile).copyToDir(out.createDir(outFile));
            } else {
                BrutIO.copyAndClose(in.getFileInput(inFile), out.getFileOutput(outFile));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + inFile, ex);
        }
    }

    public static void copyToDir(Directory in, File out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, File out, String[] fileNames) throws DirectoryException {
        for (int i = 0; i < fileNames.length; ++i) {
            DirUtil.copyToDir(in, out, fileNames[i]);
        }
    }

    public static void copyToDir(Directory in, File out, String fileName) throws DirectoryException {
        try {
            if (in.containsDir(fileName)) {
                OS.rmdir(new File(out, fileName));
                in.getDir(fileName).copyToDir(new File(out, fileName));
            } else {
                if (fileName.equals("res") && !in.containsFile(fileName)) {
                    return;
                }
                String cleanedFilename = BrutIO.sanitizeUnknownFile(out, fileName);
                File outFile = new File(out, cleanedFilename);
                outFile.getParentFile().mkdirs();
                BrutIO.copyAndClose(in.getFileInput(fileName), new FileOutputStream(outFile));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + fileName, ex);
        }
        catch (BrutException ex) {
            throw new DirectoryException("Error copying file: " + fileName, ex);
        }
    }
}

