/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.err.CantFind9PatchChunk;
import brut.androlib.err.RawXmlEncounteredException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.directory.DirUtil;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResFileDecoder {
    private final ResStreamDecoderContainer mDecoders;
    private static final Logger LOGGER = Logger.getLogger(ResFileDecoder.class.getName());
    private static final String[] RAW_IMAGE_EXTENSIONS = new String[]{"m4a", "qmg"};
    private static final String[] RAW_9PATCH_IMAGE_EXTENSIONS = new String[]{"qmg", "spi"};

    public ResFileDecoder(ResStreamDecoderContainer decoders) {
        this.mDecoders = decoders;
    }

    public void decode(ResResource res, Directory inDir, Directory outDir) throws AndrolibException {
        String outFileName;
        ResFileValue fileValue = (ResFileValue)res.getValue();
        String inFileName = fileValue.getStrippedPath();
        String outResName = res.getFilePath();
        String typeName = res.getResSpec().getType().getName();
        String ext = null;
        int extPos = inFileName.lastIndexOf(".");
        if (extPos == -1) {
            outFileName = outResName;
        } else {
            ext = inFileName.substring(extPos).toLowerCase();
            outFileName = outResName + ext;
        }
        try {
            if (typeName.equals("raw")) {
                this.decode(inDir, inFileName, outDir, outFileName, "raw");
                return;
            }
            if (typeName.equals("font") && !".xml".equals(ext)) {
                this.decode(inDir, inFileName, outDir, outFileName, "raw");
                return;
            }
            if (typeName.equals("drawable") || typeName.equals("mipmap")) {
                if (inFileName.toLowerCase().endsWith(".9" + ext)) {
                    outFileName = outResName + ".9" + ext;
                    if (inFileName.toLowerCase().endsWith(".r.9" + ext)) {
                        outFileName = outResName + ".r.9" + ext;
                    }
                    for (String extension : RAW_9PATCH_IMAGE_EXTENSIONS) {
                        if (!inFileName.toLowerCase().endsWith("." + extension)) continue;
                        this.copyRaw(inDir, outDir, inFileName, outFileName);
                        return;
                    }
                    if (inFileName.toLowerCase().endsWith(".xml")) {
                        this.decode(inDir, inFileName, outDir, outFileName, "xml");
                        return;
                    }
                    try {
                        this.decode(inDir, inFileName, outDir, outFileName, "9patch");
                        return;
                    }
                    catch (CantFind9PatchChunk ex) {
                        LOGGER.log(Level.WARNING, String.format("Cant find 9patch chunk in file: \"%s\". Renaming it to *.png.", inFileName), ex);
                        outDir.removeFile(outFileName);
                        outFileName = outResName + ext;
                    }
                }
                for (String extension : RAW_IMAGE_EXTENSIONS) {
                    if (!inFileName.toLowerCase().endsWith("." + extension)) continue;
                    this.copyRaw(inDir, outDir, inFileName, outFileName);
                    return;
                }
                if (!".xml".equals(ext)) {
                    this.decode(inDir, inFileName, outDir, outFileName, "raw");
                    return;
                }
            }
            this.decode(inDir, inFileName, outDir, outFileName, "xml");
        }
        catch (RawXmlEncounteredException ex) {
            this.decode(inDir, inFileName, outDir, outFileName, "raw");
        }
        catch (AndrolibException ex) {
            LOGGER.log(Level.SEVERE, String.format("Could not decode file, replacing by FALSE value: %s", inFileName), ex);
            res.replace(new ResBoolValue(false, 0, null));
        }
    }

    public void decode(Directory inDir, String inFileName, Directory outDir, String outFileName, String decoder) throws AndrolibException {
        try (InputStream in = inDir.getFileInput(inFileName);
             OutputStream out = outDir.getFileOutput(outFileName);){
            this.mDecoders.decode(in, out, decoder);
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void copyRaw(Directory inDir, Directory outDir, String inFilename, String outFilename) throws AndrolibException {
        try {
            DirUtil.copyToDir(inDir, outDir, inFilename, outFilename);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeManifest(Directory inDir, String inFileName, Directory outDir, String outFileName) throws AndrolibException {
        try (InputStream in = inDir.getFileInput(inFileName);
             OutputStream out = outDir.getFileOutput(outFileName);){
            ((XmlPullStreamDecoder)this.mDecoders.getDecoder("xml")).decodeManifest(in, out);
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }
}

