/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.CommentingIndentingWriter;
import org.jf.baksmali.Adaptors.FieldDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.util.IndentingWriter;
import org.jf.util.StringUtils;

public class ClassDefinition {
    public final BaksmaliOptions options;
    public final ClassDef classDef;
    private final HashSet<String> fieldsSetInStaticConstructor;

    public ClassDefinition(BaksmaliOptions options, ClassDef classDef) {
        this.options = options;
        this.classDef = classDef;
        this.fieldsSetInStaticConstructor = ClassDefinition.findFieldsSetInStaticConstructor(classDef);
    }

    private static HashSet<String> findFieldsSetInStaticConstructor(ClassDef classDef) {
        HashSet<String> fieldsSetInStaticConstructor = new HashSet<String>();
        for (Method method : classDef.getDirectMethods()) {
            MethodImplementation impl;
            if (!method.getName().equals("<clinit>") || (impl = method.getImplementation()) == null) continue;
            block6: for (Instruction instruction : impl.getInstructions()) {
                switch (instruction.getOpcode()) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c ins = (Instruction21c)instruction;
                        FieldReference fieldRef = (FieldReference)ins.getReference();
                        try {
                            fieldRef.validateReference();
                            if (!fieldRef.getDefiningClass().equals(classDef.getType())) continue block6;
                            fieldsSetInStaticConstructor.add(ReferenceUtil.getShortFieldDescriptor(fieldRef));
                        }
                        catch (Reference.InvalidReferenceException invalidReferenceException) {}
                        break;
                    }
                }
            }
        }
        return fieldsSetInStaticConstructor;
    }

    public void writeTo(IndentingWriter writer) throws IOException {
        this.writeClass(writer);
        this.writeSuper(writer);
        this.writeSourceFile(writer);
        this.writeInterfaces(writer);
        this.writeAnnotations(writer);
        Set<String> staticFields = this.writeStaticFields(writer);
        this.writeInstanceFields(writer, staticFields);
        Set<String> directMethods = this.writeDirectMethods(writer);
        this.writeVirtualMethods(writer, directMethods);
    }

    private void writeClass(IndentingWriter writer) throws IOException {
        writer.write(".class ");
        this.writeAccessFlags(writer);
        writer.write(this.classDef.getType());
        writer.write(10);
    }

    private void writeAccessFlags(IndentingWriter writer) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForClass(this.classDef.getAccessFlags())) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }

    private void writeSuper(IndentingWriter writer) throws IOException {
        String superClass = this.classDef.getSuperclass();
        if (superClass != null) {
            writer.write(".super ");
            writer.write(superClass);
            writer.write(10);
        }
    }

    private void writeSourceFile(IndentingWriter writer) throws IOException {
        String sourceFile = this.classDef.getSourceFile();
        if (sourceFile != null) {
            writer.write(".source \"");
            StringUtils.writeEscapedString(writer, sourceFile);
            writer.write("\"\n");
        }
    }

    private void writeInterfaces(IndentingWriter writer) throws IOException {
        List<String> interfaces = this.classDef.getInterfaces();
        if (interfaces.size() != 0) {
            writer.write(10);
            writer.write("# interfaces\n");
            for (String interfaceName : interfaces) {
                writer.write(".implements ");
                writer.write(interfaceName);
                writer.write(10);
            }
        }
    }

    private void writeAnnotations(IndentingWriter writer) throws IOException {
        Set<? extends Annotation> classAnnotations = this.classDef.getAnnotations();
        if (classAnnotations.size() != 0) {
            writer.write("\n\n");
            writer.write("# annotations\n");
            String containingClass = null;
            if (this.options.implicitReferences) {
                containingClass = this.classDef.getType();
            }
            AnnotationFormatter.writeTo(writer, classAnnotations, containingClass);
        }
    }

    private Set<String> writeStaticFields(IndentingWriter writer) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenFields = new HashSet<String>();
        Iterable<? extends Field> staticFields = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getStaticFields(false) : this.classDef.getStaticFields();
        for (Field field : staticFields) {
            boolean setInStaticConstructor;
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# static fields");
                wroteHeader = true;
            }
            writer.write(10);
            IndentingWriter fieldWriter = writer;
            String fieldString = ReferenceUtil.getShortFieldDescriptor(field);
            if (!writtenFields.add(fieldString)) {
                writer.write("# duplicate field ignored\n");
                fieldWriter = new CommentingIndentingWriter(writer);
                System.err.println(String.format("Ignoring duplicate field: %s->%s", this.classDef.getType(), fieldString));
                setInStaticConstructor = false;
            } else {
                setInStaticConstructor = this.fieldsSetInStaticConstructor.contains(fieldString);
            }
            FieldDefinition.writeTo(this.options, fieldWriter, field, setInStaticConstructor);
        }
        return writtenFields;
    }

    private void writeInstanceFields(IndentingWriter writer, Set<String> staticFields) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenFields = new HashSet<String>();
        Iterable<? extends Field> instanceFields = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getInstanceFields(false) : this.classDef.getInstanceFields();
        for (Field field : instanceFields) {
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# instance fields");
                wroteHeader = true;
            }
            writer.write(10);
            IndentingWriter fieldWriter = writer;
            String fieldString = ReferenceUtil.getShortFieldDescriptor(field);
            if (!writtenFields.add(fieldString)) {
                writer.write("# duplicate field ignored\n");
                fieldWriter = new CommentingIndentingWriter(writer);
                System.err.println(String.format("Ignoring duplicate field: %s->%s", this.classDef.getType(), fieldString));
            } else if (staticFields.contains(fieldString)) {
                System.err.println(String.format("Duplicate static+instance field found: %s->%s", this.classDef.getType(), fieldString));
                System.err.println("You will need to rename one of these fields, including all references.");
                writer.write("# There is both a static and instance field with this signature.\n# You will need to rename one of these fields, including all references.\n");
            }
            FieldDefinition.writeTo(this.options, fieldWriter, field, false);
        }
    }

    private Set<String> writeDirectMethods(IndentingWriter writer) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenMethods = new HashSet<String>();
        Iterable<? extends Method> directMethods = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getDirectMethods(false) : this.classDef.getDirectMethods();
        for (Method method : directMethods) {
            MethodImplementation methodImpl;
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# direct methods");
                wroteHeader = true;
            }
            writer.write(10);
            String methodString = ReferenceUtil.getMethodDescriptor(method, true);
            IndentingWriter methodWriter = writer;
            if (!writtenMethods.add(methodString)) {
                writer.write("# duplicate method ignored\n");
                methodWriter = new CommentingIndentingWriter(writer);
            }
            if ((methodImpl = method.getImplementation()) == null) {
                MethodDefinition.writeEmptyMethodTo(methodWriter, method, this.options);
                continue;
            }
            MethodDefinition methodDefinition = new MethodDefinition(this, method, methodImpl);
            methodDefinition.writeTo(methodWriter);
        }
        return writtenMethods;
    }

    private void writeVirtualMethods(IndentingWriter writer, Set<String> directMethods) throws IOException {
        boolean wroteHeader = false;
        HashSet<String> writtenMethods = new HashSet<String>();
        Iterable<? extends Method> virtualMethods = this.classDef instanceof DexBackedClassDef ? ((DexBackedClassDef)this.classDef).getVirtualMethods(false) : this.classDef.getVirtualMethods();
        for (Method method : virtualMethods) {
            if (!wroteHeader) {
                writer.write("\n\n");
                writer.write("# virtual methods");
                wroteHeader = true;
            }
            writer.write(10);
            String methodString = ReferenceUtil.getMethodDescriptor(method, true);
            IndentingWriter methodWriter = writer;
            if (!writtenMethods.add(methodString)) {
                writer.write("# duplicate method ignored\n");
                methodWriter = new CommentingIndentingWriter(writer);
            } else if (directMethods.contains(methodString)) {
                writer.write("# There is both a direct and virtual method with this signature.\n# You will need to rename one of these methods, including all references.\n");
                System.err.println(String.format("Duplicate direct+virtual method found: %s->%s", this.classDef.getType(), methodString));
                System.err.println("You will need to rename one of these methods, including all references.");
            }
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null) {
                MethodDefinition.writeEmptyMethodTo(methodWriter, method, this.options);
                continue;
            }
            MethodDefinition methodDefinition = new MethodDefinition(this, method, methodImpl);
            methodDefinition.writeTo(methodWriter);
        }
    }
}

