---
category: Design Patterns
type: Principles
order: 2
title: Alignment
---

As is described in the Law of Continuity of Gestalt psychology, in the perceptual process, people usually tend to understand the object in the way that it is firstly perceived, to let the straight lines be straight and let the curve lines be curve. In the design of interface, aligning the elements meets users' perception, also delivers the information to users in a more smooth way.

> **Gestalt psychology or gestaltism (German：Gestalttheorie)**: Gestalttheorie is an important genre of psychology. It rose in the beginning of the 20 century in Germany.The central principle of gestalt psychology is that the mind forms a global whole with self-organizing tendencies.「The whole is other than the sum of the parts.」--Quote from Wikipedia

---

## Text Alignment

<img class="preview-img good" align="right" alt="good example" description="Align the title and text to the left; use one visual starting point." src="https://gw.alipayobjects.com/zos/rmsportal/lVDlIgxvuXSMQvJJVMnu.png">
<img class="preview-img bad" align="right" alt="bad example" description="The tile and the text start in different visual point. This is not recommended except the differences between title and text are emphasized. " src="https://gw.alipayobjects.com/zos/rmsportal/DAhkAEIoXYdljmxsJTjl.png">

If the paragraphs or the length of the words are too short or too loose, then a unified visual starting point is needed.

---

## Form Alignment

<img class="preview-img" align="right" alt="example of colon alignment" src="https://gw.alipayobjects.com/zos/rmsportal/OaTkwGfGxRSFsvAlzZMq.png">

Colon alignment(right-align) can encircle the content into a certain range. Users can infer where the chart is through the regular arranged colon so that the speed of filling in the chart can be speeded up.

---

## Numbers Alignment

<img class="preview-img good" align="right" alt="good example" src="https://gw.alipayobjects.com/zos/rmsportal/bIJAZcUmaRxJeFxZJwUp.png">
<img class="preview-img bad" align="right" alt="bad example" src="https://gw.alipayobjects.com/zos/rmsportal/zUmANVIhBanDnlyOhvaH.png">

To compare the numbers faster, we suggest that all numbers should keep the same digit numbers after decimal point; meanwhile all numbers should be right-aligned.
