% AMT - Model demonstrations
%
%   Demonstration of common functions
%     DEMO_ABSOLUTETHRESHOLD     - Absolute thresholds of hearing
%     DEMO_GAMMATONE             - Gammatone filterbank
%     DEMO_ADAPTLOOP             - Adaptation loops
%
%  Basilar membrane velocity
%     DEMO_HOHMANN2002                            - Invertible Gammatone filterbank
%     DEMO_LOPEZPOVEDA2001                        - Dual resonance non-linear filterbank
%     DEMO_LYON2011                               - CARFAC Model excitation patterns
%     DEMO_LYON2011_COMPRESSIVEFUNCTIONS          - CARFAC Model Cochlear compression
%     DEMO_LYON2011_IMPULSERESPONSES              - CARFAC Model impulse responses
%     DEMO_VERHULST2012                           - Verhulst et al. 2012
%
%   Auditory nerve
%     DEMO_BRUCE2018                              - Auditory cochlear processing
%     DEMO_BRUCE2018_AUDITORYNERVEMODEL           - processing across the auditory nerve
%     DEMO_CARNEY2015                             - Inferior colliculus response
%     DEMO_ZILANY2014                             - relative threshold as a function of the spontaneous firing rate
%
%   Temporal modulation sensitivity
%     DEMO_EWERT2000             - Modulation filterbank, EPSM version
%     DEMO_KING2019              - Modulation filterbank, PEMO version
%     DEMO_ROENNE2012            - Simulate ABR to given stimulus
%     DEMO_VERHULST2015          - Verhulst et al. 2015
%     DEMO_VERHULST2018          - Verhulst et al. 2018
%
%   Binaural processing
%     DEMO_BREEBAART2001         - Binaural Masking Level Differences
%     DEMO_LINDEMANN1986         - Binaural processing
%     DEMO_HAUTH2020             - Blind equalization cancellation
%
%   Loudness
%     DEMO_CHEN2011              - Fast excitation pattern estimation
%
%   Monaural speech perception
%     DEMO_JOERGENSEN2013        - Speech-based envelope power spectrum
%
%   Perceptual similarity
%     DEMO_MCKENZIE2021          - binaural perceptual similarity
%
%   Spatial perception
%     DEMO_BAUMGARTNER2013       - Localization in saggital planes (preliminary)
%     DEMO_BAUMGARTNER2014       - Localization in saggital planes (linear periphery)
%     DEMO_BAUMGARTNER2014_BLOCKPROCESSING - runs Baumgartner2014 in a blockprocessing framework
%     DEMO_BAUMGARTNER2016       - Localization in sagittal planes (nonlinear periphery)
%     DEMO_BAUMGARTNER2017       - Sound externalization model based on monaural spectral cues
%     DEMO_BAUMGARTNER2021       - Sound externalization based on perceptual-based decisions
%     DEMO_MCLACHLAN2021         - Dynamic ideal-observer model of human sound localization
%     DEMO_REIJNIERS2014         - Spherical sound localization based on Bayesian statistics
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/demos/Contents.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

