function definput=arg_verhulst2015(definput)
% ARG_VERHULST2015
%
%   #License: GPL
%   #Author: Piotr Majdak (2021)
%% General
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/defaults/arg_verhulst2015.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.
definput.flags.disp = {'no_debug','debug'};
definput.flags.ihc  = {'no_ihc','ihc'};
definput.flags.an   = {'an','no_an'}; 
definput.flags.cn   = {'cn','no_cn'}; 
definput.flags.ic   = {'ic','no_ic'}; 
definput.flags.mfb  = {'no_mfb','mfb'};
definput.flags.oae    = {'no_oae','oae'}; 

%% Outer and middle ear
definput.flags.outerear = {'no_outerear' ,'outerear'};
definput.flags.middleear= {'middleear','no_middleear','jepsen2008'};

%% cochlear filterbank parameters

definput.keyvals.hearing_profile = 'Flat00'; % hearing profile
definput.keyvals.subject= 1; % to control randomness in cochlear irregularities
definput.keyvals.irr_on = 1; % irregularities on (1) or off (0)
definput.keyvals.non_linear_type = 'vel'; % ???
definput.keyvals.IrrPct = 0.05;
definput.keyvals.fs_up  = 100000;

%% IHC
definput.keyvals.ihc_scal_constant=41e-6/200e-9;

%% AN
definput.keyvals.numH = 13; % default number of high-spontaneous rate neurones
definput.keyvals.kSR_H  = 60; % spikes/s, spontaneous rate
% definput.keyvals.kmax_H = []; % Peak exocytosis rate [spikes/s]

definput.keyvals.numM =  3; % default number of medium-spontaneous rate neurones
definput.keyvals.kSR_M  = 10; % spikes/s, spontaneous rate
% definput.keyvals.kmax_M = []; % Peak exocytosis rate [spikes/s]

definput.keyvals.numL =  3; % default number of low-spontaneous rate neurones
definput.keyvals.kSR_L  = 1; % spikes/s, spontaneous rate
% definput.keyvals.kmax_L = []; % Peak exocytosis rate [spikes/s]

definput.flags.anfH = {'anfH','no_anfH'};
definput.flags.anfM = {'anfM','no_anfM'};
definput.flags.anfL = {'anfL','no_anfL'};

%definput.groups.an_verhulst2015 = {'anfH','anfM','anfL','kSR_H',60, 'kmax_H',[],'kmax_M',[],'kmax_L',[]}; % unused here

%% Brainstem (CN and IC)
definput.keyvals.model_version = 2015;
definput.keyvals.version_year = 2015;
definput.keyvals.M1 = 1.4792e-14; % recalibrated for AMT by Alejandro
definput.keyvals.M3 = 3.5456e-14; % recalibrated for AMT by Alejandro
definput.keyvals.M5 = 4.53e-14; % recalibrated for AMT by Alejandro
%definput.keyvals.M1 = 1.845e14; % as in Verhulst2015
%definput.keyvals.M3 = 93.8e-6; % as in Verhulst2015
%definput.keyvals.M5 = 90.6e-6; % as in Verhulst2015


definput.keyvals.Tex_cn = 0.5e-3; % Tau excitation
definput.keyvals.Tin_cn = 2e-3; % Tau inhibition
definput.keyvals.dly_cn = 1e-3; % dly ms
definput.keyvals.Acn    = 1.5;
definput.keyvals.Scn    = 0.6;

definput.keyvals.Tex_ic = 0.5e-3; % Tau excitation
definput.keyvals.Tin_ic = 2e-3; % Tau inhibition
definput.keyvals.dly_ic = 2e-3; % dly ms
definput.keyvals.Aic    = 1.0;
definput.keyvals.Sic    = 1.5;
definput.keyvals.subfs  = 20000;

%% Remainings from Alejandro branch
%definput.groups.abr_verhulst2015 = {'an','cn','ic','no_oae','no_disp','no_ihc', ...
%                                    'subfs',20000,'no_mfb','model_version',2015,'version_year',2015, ...
%                                    'M1',1.4792e-14,'M3',3.5456e-14,'M5',4.53e-14}; % Recalibrated for AMT toolbox
