function definput = arg_bruce2018(definput)
% ARG_BRUCE2018
%
%   #License: GPL
%   #Author: Clara Hollomey (2021)
%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/defaults/arg_bruce2018.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

%% General
definput.flags.species = {'human','cat'};
definput.keyvals.fsmod   = 100e3; %tdres calculated therefrom later on

%% Parameters of the IHC
definput.keyvals.nrep = 1;
definput.keyvals.reptime = 1.2;

  % fitaudiogram: derive the inner and outer hair cell impairment factors 
  %   (ohcs and ihcs) via audiogram fitting given by ag_fs and ag_dbloss
  % no_fitaudiogram: use user-defined ohcs and ohcs parameters
definput.flags.fitHL = {'no_fitaudiogram', 'fitaudiogram'}; 

definput.keyvals.ag_fs = [125 250 500 1e3 2e3 4e3 8e3];
definput.keyvals.ag_dbloss = [0 0 0 0 0 0 0];
definput.keyvals.cihcs = 1;
definput.keyvals.cohcs = 1;

%% parameters to generate an auditory nerve population
  % 'outputPerSynapse' model will output results per synapse (slower)
  % 'outputPerCF' model will output average results over all synapses (faster)
definput.flags.output = {'outputPerCF', 'outputPerSynapse'};

  %PSTH parameters
definput.keyvals.psthbinwidth_mr = 100e-6;
definput.keyvals.windur_ft=32;
definput.keyvals.windur_mr=128;

  %synapse parameters
definput.flags.noiseType = {'fixedFGn','varFGn'};
definput.flags.powerLawImp = {'approxPL','actualPL'};%converted to '0' and '1' later on

  %nerve fiber paramters
definput.flags.SR={'autoSR','specificSR'};
  % Used only if autoSR (SRs will be calculated)
definput.keyvals.numL = 4;   % Number of low SR fibers at each CF
definput.keyvals.lossL = 1;
definput.keyvals.numM = 4;   % Number of medium SR fibers at each CF
definput.keyvals.lossM = 1;
definput.keyvals.numH = 12;   % Number of high SR fibers at each CF
definput.keyvals.lossH = 1;
  % Used only if specificSR (SR specified as below)
definput.keyvals.numsponts = 10; % number of fibers
definput.keyvals.spont = 50; % SR (spikes/s)
definput.keyvals.tabs = 0.6e-3; 
definput.keyvals.trel = 0.6e-3;



