function definput=arg_barumerli2021_featureextraction(definput)
    definput.flags.compute = {'all', 'template', 'target'};
    definput.flags.feature_lateral = {'itd_broadband', 'itd_multiband'};
    definput.flags.feature_polar = {'pge', 'dtf'};
    definput.flags.feature_polar_combine = {'monoaural', 'interaural_difference', 'reijniers'};
    definput.flags.source = {'source_broadband', 'source'};
    
    % filterbank options
    definput.keyvals.fs = 44.1e3;
    definput.keyvals.flow = 700;
    definput.keyvals.fhigh = 18e3;
    
    definput.keyvals.space = 1; % filterbank spacing
    definput.keyvals.monoaural_bw = [1 Inf]*1e3;
    
    % target directions
    definput.keyvals.targ_az = [];
    definput.keyvals.targ_el = [];

    % sound source (time domain)
    % (default) broad band sound source at 0dB
    definput.keyvals.source_ir = [];
    definput.keyvals.source_fs = 0;

%
%   Url: http://amtoolbox.sourceforge.net/amt-0.10.0/doc/defaults/arg_barumerli2021_featureextraction.php

% Copyright (C) 2009-2020 Piotr Majdak and the AMT team.
% This file is part of Auditory Modeling Toolbox (AMT) version 1.0.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

