function createSelectionHelpText() {
    var lbl = document.createElement("LABEL");
    lbl.innerHTML = "Select an object to view detailed results";
    lbl.id = "selectionHelpText";
    return lbl;
}

function clearSelectionHelpText() {
    if (document.getElementById("selectionHelpText")) {
        document.getElementById("selectionHelpText").remove();
    }
}

function createTable(rt, hdr, depth, isCollapsedinitially) {
    var myDiv = document.createElement('div');
    myDiv.className = "resultTableDivClass";

    var myTable = document.createElement('table');
    myTable.className = "resultTableClass";
    var hdrRow = myTable.createTHead().insertRow().insertCell();
    hdrRow.setAttribute("colspan", 90);
    var headerBtn = document.createElement('button');
    headerBtn.innerHTML = hdr;
    headerBtn.innerHTML = '<h' + depth + '>' + hdr + '</h' + depth + '>';
    headerBtn.setAttribute("colspan", 90);
    headerBtn.style.background = "DimGray";
    headerBtn.style.color = "white";
    headerBtn.style.width = "100%";
    hdrRow.appendChild(headerBtn);

    var colDef = document.createElement('col');
    colDef.className = "tableColumnClass";
    myTable.appendChild(colDef);

    var bdy = myTable.createTBody();
    for (var key in rt) {
        var val = rt[key];
        if (typeof val == "object") { //arrays
            continue;
        }
        if (isAttribute(key)) {
            continue;
        }
        var rw = bdy.insertRow();
        var h = document.createElement('th');
        h.innerHTML = key;
        rw.appendChild(h);
        rw.insertCell().innerHTML = val;
    }
	
    if (isCollapsedinitially) {
        $(bdy).toggle();
    }
	$(headerBtn).on('click', function() {
		$(bdy).toggle();
	});
    myDiv.appendChild(myTable);
    return myDiv;
}

function createMultiTable(rt, hdr, tableTitle, rowNameAttribute, arrayPtr, depth, parentDiv) {
    var arrayPtrAsArray = [];
    // If a node has a single child, XML converter does not convert it as a single element array.
    // So here, we make sure that the data we pass below is indeed an array (since it is indexed
    // like an array from this point on).
    if (arrayPtr.constructor === Array) {
        arrayPtrAsArray = arrayPtr;
    } else {
        arrayPtrAsArray[0] = arrayPtr;
    }

    var myDiv = document.createElement('div');
    myDiv.className = "resultTableDivClass";

    var myTable = document.createElement('table');
    myTable.className = "resultTableClass";

    var colDef = document.createElement('col');
    colDef.className = "tableColumnClass";
    myTable.appendChild(colDef);

    var hdrCell = myTable.createTHead().insertRow().insertCell();
    hdrCell.innerHTML = '<h' + depth + '>' + hdr + '</h' + depth + '>';
    hdrCell.setAttribute("colspan", 90);
    hdrCell.className = "fixedCellClass";

    var bdy = myTable.createTBody();
    var firstRow = bdy.insertRow();
    var h = document.createElement('th');
    h.innerHTML = tableTitle;
    firstRow.appendChild(h);
    h.className = "fixedCellClass";
    for (var key in arrayPtrAsArray[0]) {
        if (isAttribute(key)) {
            continue;
        }
        var h = document.createElement('th');
        h.innerHTML = key;
        h.className = "fixedCellClass";
        firstRow.appendChild(h);
    }

    for (var key in arrayPtrAsArray) {
        var row = bdy.insertRow();
        var h = document.createElement('th');
        h.innerHTML = arrayPtrAsArray[key]['-' + rowNameAttribute];
        row.appendChild(h);
        for (var v in arrayPtrAsArray[key]) {
            if (isAttribute(v)) {
                continue;
            }
            row.insertCell().innerHTML = arrayPtrAsArray[key][v];
        }
    }

    myDiv.appendChild(myTable);
    return myDiv;
}

function createMultiGraph(elementName, elementNo, elementPath) {
    var axisData = [];
    var elementPathAsArray = [];
    // If a node has a single child, XML converter does not convert it as a single element array.
    // So here, we make sure that the data we pass below is indeed an array (since it is indexed
    // like an array from this point on).
    if (elementPath.constructor === Array) {
        elementPathAsArray = elementPath;
    } else {
        elementPathAsArray[0] = elementPath;
    }
    for (var key in elementPathAsArray[0]) {
        if (isAttribute(key)) {
            continue;
        }
        axisData.push(key);
    }
    return createGraph(elementName, elementNo, elementPathAsArray, axisData);
}

function createGraph(elementName, elementNo, dataSet, axisData) {
    var myDiv = document.createElement('div');
    myDiv.className = "graph2dDiv";
    myDiv.appendChild(document.createElement('br'));

    myDiv.appendChild(document.createElement("p").appendChild(document.createTextNode("X: ")));
    var xAxisSelect = document.createElement("select");
    var graphName = elementName + elementNo.trim();
    xAxisSelect.id = graphName + '-xAxis';
    var l = axisData.length;
    for (var i = 0; i < l; i++) {
        xAxisSelect.appendChild(new Option(axisData[i], axisData[i]));
    }
    myDiv.appendChild(xAxisSelect);
    myDiv.appendChild(document.createElement('br'));

    myDiv.appendChild(document.createElement("p").appendChild(document.createTextNode("Y: ")));
    var yAxisSelect = document.createElement("select");
    yAxisSelect.id = graphName + '-yAxis';
    var l = axisData.length;
    for (var i = 0; i < l; i++) {
        yAxisSelect.appendChild(new Option(axisData[i], axisData[i], false, (i == 1) ? true : false));
    }
    myDiv.appendChild(yAxisSelect);

    var canvasName = graphName + '-multiChart';

    xAxisSelect.onchange = function () {
        graphAxisChanged(myDiv
                            , xAxisSelect[xAxisSelect.selectedIndex].value
                            , yAxisSelect[yAxisSelect.selectedIndex].value
                            , dataSet, canvasName);
    };
    yAxisSelect.onchange = function () {
        graphAxisChanged(myDiv
                            , xAxisSelect[xAxisSelect.selectedIndex].value
                            , yAxisSelect[yAxisSelect.selectedIndex].value
                            , dataSet, canvasName);
    };

    var xAxis = xAxisSelect[xAxisSelect.selectedIndex].value;
    var yAxis = yAxisSelect[yAxisSelect.selectedIndex].value;
    document.body.appendChild(myDiv);
    createGraphInDiv(myDiv, xAxis, yAxis, dataSet, canvasName);
    myDiv.appendChild(document.createElement('br'));
    myDiv.appendChild(document.createElement('br'));
    return myDiv;
}

function createGraphInDiv(myDiv, xAxis, yAxis, dataSet, canvasName) {
    var canvasCtx = document.createElement('canvas');
    canvasCtx.id = canvasName;
    canvasCtx.className = "graphCanvas";
    myDiv.appendChild(canvasCtx);

    var xAxisElements = [];
    var yAxisElements = [];
    for (var i in dataSet) {
        xAxisElements.push(dataSet[i][xAxis]);
        yAxisElements.push(dataSet[i][yAxis]);
    }
    var myChart = new Chart(canvasCtx, {
        type: 'line',
        data: {
            labels: xAxisElements,
            datasets: [{
                label: yAxis,
                data: yAxisElements,
                tension: 0,
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            legend: {
                display: false,
            },
            scales: {
                yAxes: [{
                    ticks: {
                        // beginAtZero: true
                    },
                    scaleLabel: {
                        display: true,
                        labelString: yAxis,
                    }
                }],
                xAxes: [{
                    scaleLabel: {
                        display: true,
                        labelString: xAxis,
                    }
                }]
            }
        }
    });
}

function graphAxisChanged(myDiv, xAxis, yAxis, dataSet, canvasName, label) {
    document.getElementById(canvasName).remove();
    createGraphInDiv(myDiv, xAxis, yAxis, dataSet, canvasName);
}

function createSubTables(base, subTables) {
    var myDiv = document.createElement('div');
    for (var t in subTables) {
        if (subTables[t]["subTable"].length && !base.hasOwnProperty(subTables[t]["subTable"])) {
            continue;
        }
		myDiv.appendChild(createTable(base[subTables[t]["subTable"]], subTables[t]["subTableName"], subTables[t]["depth"], subTables[t]["defaultCollapsed"]));
    }
    return myDiv;
}

g_chamberTables = [
    { subTable: "INPUT", subTableName: "INPUT", depth: "4", defaultCollapsed: false },
    { subTable: "OUTPUT", subTableName: "OUTPUT", depth: "4", defaultCollapsed: false }
];

g_chamberTablesTitle = [
    { subTable: "", subTableName: "", depth: "", defaultCollapsed: false },
];

g_elementTables = [
    { subTable: "FLOW", subTableName: "FLOW", depth: "4", defaultCollapsed: false  },
    { subTable: "CHAMBER_DOWNSTREAM", subTableName: "CHAMBER DOWNSTREAM", depth: "4", defaultCollapsed: true },
    { subTable: "CHAMBER_UPSTREAM", subTableName: "CHAMBER UPSTREAM", depth: "4", defaultCollapsed: true },
    { subTable: "ELEMENT_INPUT_DATA", subTableName: "ELEMENT INPUT_DATA", depth: "4", defaultCollapsed: true },
    { subTable: "UPSTREAM_RESULTS", subTableName: "UPSTREAM RESULTS", depth: "4", defaultCollapsed: true },
    { subTable: "DOWNSTREAM_RESULTS", subTableName: "DOWNSTREAM RESULTS", depth: "4", defaultCollapsed: true },
    { subTable: "ELEMENT_RESULTS", subTableName: "ELEMENT RESULTS", depth: "4", defaultCollapsed: true },
    { subTable: "INLET_CONDITIONS", subTableName: "INLET CONDITIONS", depth: "4", defaultCollapsed: true },
    { subTable: "EXIT_CONDITIONS", subTableName: "EXIT CONDITIONS", depth: "4", defaultCollapsed: true },
    { subTable: "BEFORE_COMBUSTION", subTableName: "BEFORE COMBUSTION", depth: "4", defaultCollapsed: true },
    { subTable: "AFTER_COMBUSTION", subTableName: "AFTER COMBUSTION", depth: "4", defaultCollapsed: true },
];

g_elementTablesTitle = [
    { subTable: "", subTableName: "", depth: "", defaultCollapsed: false },
];

g_tnodeTablesTitle = [
    { subTable: "", subTableName: "", depth: "", defaultCollapsed: false },
];

g_resistorTablesTitle = [
    { subTable: "", subTableName: "", depth: "", defaultCollapsed: false },
];

function createSingleResultDiv(component) {
    var myDiv = document.createElement('div');
    myDiv.id = "componentResultDiv";

    if (component.startsWith("tnode")) {
        var str = component.split('-');
        var tnId = Number(str[1]);
        var tnodeId = Number(str[2]);
		var tnode = db.getTNodeWithId(tnId, tnodeId);
		if (tnode === null) {
			return null;
		}

		g_tnodeTablesTitle[0] = {
			subTable: ""
			, subTableName: 'TNODE: ' + tnId + '/' + tnode["-TNODE_NO"] + ", " + tnode["TYPE"]
			, depth: "3"
		};
		myDiv.appendChild(createSubTables(tnode, g_tnodeTablesTitle));
		myDiv.appendChild(createTable(tnode, "OUTPUT", 4, false));
		return myDiv;
    } else if (component.startsWith("resistor")) {
        var str = component.split('-');
        var tnId = Number(str[1]);
        var resId = Number(str[2]);
		var resistor = db.getResistorWithId(tnId, resId);
		if (resistor === null) {
			return null;
		}
		
		g_resistorTablesTitle[0] = {
			subTable: ""
			, subTableName: 'RESISTOR: ' + tnId + '/' + resistor["-NUMBER"] + ", " + resistor["-TYPE"]
			, depth: "3"
		};
		myDiv.appendChild(createSubTables(resistor, g_resistorTablesTitle));
		myDiv.appendChild(createTable(resistor, "OUTPUT", 4, false));
		return myDiv;
    } else if (component.startsWith("chamber")) {
        var compNo = Number(component.substring("chamber".length));
		var cham = db.getChamberWithId(compNo);
		if (cham === null) {
			return null;
		}

		g_chamberTablesTitle[0] = {
							subTable: ""
							, subTableName: 'CHAMBER: ' + cham["-CHAMBER_NO"] + ", " + cham["CHAMBER_TYPE"]
							, depth: "3"
		};
		myDiv.appendChild(createSubTables(cham, g_chamberTablesTitle));
		myDiv.appendChild(createSubTables(cham, g_chamberTables));
		return myDiv;
    } else if (component.startsWith("element")) {
		var compNo = Number(component.substring("element".length));
		var elem = db.getElementWithId(compNo);
		if (elem === null) {
			return null;
		}

		g_elementTablesTitle[0] = {
							subTable: ""
							, subTableName: 'ELEMENT: ' + elem["-NUMBER"] + "," + elem["-TYPE"]
							, depth: "3"
		};
		myDiv.appendChild(createSubTables(elem, g_elementTablesTitle));
		if (elem.hasOwnProperty('STATION_DATA')) {
			myDiv.appendChild(createMultiTable(elem.STATION_DATA
								, 'STATION DATA'
								, 'STATION'
								, 'STA'
								, elem.STATION_DATA.STATION
								, 4));
			myDiv.appendChild(createMultiGraph("station"
								, elem["-NUMBER"]
								, elem.STATION_DATA.STATION));
		}
		if (elem.hasOwnProperty('SEGMENT_DATA')) {
			myDiv.appendChild(createMultiTable(elem.SEGMENT_DATA
								, 'SEGMENT DATA'
								, 'SEGMENTS'
								, 'NUMBER'
								, elem.SEGMENT_DATA.SEGMENT
								, 4));
			myDiv.appendChild(createMultiGraph("segment"
								, elem["-NUMBER"]
								, elem.SEGMENT_DATA.SEGMENT));

		}

		if (elem.hasOwnProperty('REACTANT_CONCENTRATIONS')) {
			myDiv.appendChild(createMultiTable(elem.REACTANT_CONCENTRATIONS
								, 'REACTANT CONCENTRATIONS'
								, 'REACTANT'
								, 'COMPOUND'
								, elem.REACTANT_CONCENTRATIONS.REACTANT
								, 4));
		}

		if (elem.hasOwnProperty('UNBURNT_REACTANT_CONCENTRATIONS')) {
			myDiv.appendChild(createMultiTable(elem.UNBURNT_REACTANT_CONCENTRATIONS
								, 'UNBURNT REACTANT CONCENTRATIONS'
								, 'REACTANT'
								, 'COMPOUND'
								, elem.UNBURNT_REACTANT_CONCENTRATIONS.REACTANT
								, 4));
		}

		if (elem.hasOwnProperty('PRODUCT_CONCENTRATIONS')) {
			myDiv.appendChild(createMultiTable(elem.REACTANT_CONCENTRATIONS
								, 'PRODUCT CONCENTRATIONS'
								, 'PRODUCT'
								, 'COMPOUND'
								, elem.PRODUCT_CONCENTRATIONS.PRODUCT
								, 4));
		}
		myDiv.appendChild(createSubTables(elem, g_elementTables));

		return myDiv;
    }
}

