var g_floObject = null;

var db = {
	floElements: [],
	floChambers: [],
	floTNetworks: [],

	init: function(tree) {
		if (!tree) {
			return;
		}
		
		if (tree.YFT_MODEL.CHAMBERS !== undefined) {
		    if (tree.YFT_MODEL.CHAMBERS.CHAMBER.constructor === Array) {
		        this.floChambers = tree.YFT_MODEL.CHAMBERS.CHAMBER;
		    } else {
		        this.floChambers[0] = tree.YFT_MODEL.CHAMBERS.CHAMBER;
		    }
		}

		if (tree.YFT_MODEL.ELEMENTS !== undefined) {
		    if (tree.YFT_MODEL.ELEMENTS.IEN.constructor === Array) {
		        this.floElements = tree.YFT_MODEL.ELEMENTS.IEN;
		    } else {
		        this.floElements[0] = tree.YFT_MODEL.ELEMENTS.IEN;
		    }
		}
		
		if (tree.YFT_MODEL.THERMAL_NETWORKS !== undefined) {
		    if (tree.YFT_MODEL.THERMAL_NETWORKS.THERMAL_NETWORK.constructor === Array) {
		        this.floTNetworks = tree.YFT_MODEL.THERMAL_NETWORKS.THERMAL_NETWORK;
		    } else {
		        this.floTNetworks[0] = tree.YFT_MODEL.THERMAL_NETWORKS.THERMAL_NETWORK;
		    }
		}
	},

	getElementAtIndex: function(ind) {
		return this.floElements[ind];
	},

	getChamberAtIndex: function(ind) {
		return this.floChambers[ind];
	},

	getElementWithId: function(id) {
        for (var i = 0; i < this.getNumberOfElements(); i++) {
			var elem = this.getElementAtIndex(i);
            if (id == Number(elem["-NUMBER"].trim())) {
				return elem;
			}
		}
		return null;
	},

	getChamberWithId: function(id) {
        for (var i = 0; i < this.getNumberOfChambers(); i++) {
			var cham = this.getChamberAtIndex(i);
            if (id == Number(cham["-CHAMBER_NO"].trim())) {
                return cham;
            }
		}
		return null;
	},

	getResistorWithId: function(tnet, id) {
		for (var i = 0; i < this.getNumberOfTNetworks(); i++) {
			if (tnet != Number(this.getTNetworkAtIndex(i)["-TN_ID"].trim())) {
				continue;
			}
			for (var j in this.getResistors(i)) {
				var res = this.getResistorAtIndex(i, j);
				if (id == Number(res["-NUMBER"])) {
					return res;
				}
			}
		}
		return null;
	},
	
	getTNodeWithId: function(tnet, id) {
		for (var i = 0; i < this.getNumberOfTNetworks(); i++) {
			if (tnet != Number(this.getTNetworkAtIndex(i)["-TN_ID"].trim())) {
				continue;
			}
			for (var j in this.getTNodes(i)) {
				var tn = this.getTNodeAtIndex(i, j);
				if (id == Number(tn["-TNODE_NO"])) {
					return tn;
				}
			}
		}
		return null;
	},

	getTNetworks: function() {
		return this.floTNetworks;
	},

	getNumberOfTNetworks: function() {
		return this.floTNetworks.length;
	},

	getNumberOfChambers: function() {
		return this.floChambers.length;
	},

	getNumberOfElements: function() {
		return this.floElements.length;
	},

	getNumberOfTNodes: function() {
	    var ret = 0;
	    for (var i = 0; i < this.getTNetworks().length; i++) {
	        ret += this.getTNodes(i).length;
	    }
	    return ret;
	},

	getNumberOfResistors: function() {
	    var ret = 0;
	    for (var i = 0; i < this.getTNetworks().length; i++) {
	        ret += this.getResistors(i).length;
	    }
	    return ret;
	},

	getTNetworkAtIndex: function(i) {
		return this.floTNetworks[i];
	},

	getTNodes: function(tNetId) {
		var currentTNetwork = this.getTNetworks()[tNetId];
		var currentTNodes = [];

		if (currentTNetwork.TNODES.TNODE.constructor === Array) {
			currentTNodes = currentTNetwork.TNODES.TNODE;
		} else {
			currentTNodes[0] = currentTNetwork.TNODES.TNODE;
		}

		return currentTNodes;
	},

	getResistors: function(tNetId) {
		var currentTNetwork = this.getTNetworks()[tNetId];
		var currentResistors = [];

		if (currentTNetwork.RESISTORS.RES.constructor === Array) {
			currentResistors = currentTNetwork.RESISTORS.RES;
		} else {
			currentResistors[0] = currentTNetwork.RESISTORS.RES;
		}

		return currentResistors;
	},

	getTNodeAtIndex: function(tNetId, tNodeId) {
		return this.getTNodes(tNetId)[tNodeId];
	},

	getResistorAtIndex: function(tNetId, resId) {
		return this.getResistors(tNetId)[resId];
	}
}

function isAttribute(key) {
    return (key.substring(0, 1) == '-');
}

function getComponentName(cmp) {
    var str;
    if (cmp["-NUMBER"]) {
        str = "Element" + cmp["-NUMBER"] + ", " + cmp["-TYPE"];
    } else {
        str = "Chamber" + cmp["-CHAMBER_NO"] + ", " + cmp["CHAMBER_TYPE"];
    }
    return str;
}

function getComponentShortName(cmp) {
    var str;
    if (cmp["-NUMBER"]) {
        str = "e-" + cmp["-NUMBER"].trim();
    } else {
        str = "c-" + cmp["-CHAMBER_NO"].trim();
    }
    return str;
}

function getComponentNo(cmp) {
    var str;
    if (cmp["-NUMBER"]) {
        str = cmp["-NUMBER"];
    } else {
        str = cmp["-CHAMBER_NO"];
    }
    return str;
}

function getComponentType(cmp) {
    var str;
    if (cmp["-NUMBER"]) {
        str = "Element";
    } else {
        str = "Chamber";
    }
    return str;
}

function getComponentSubType(cmp) {
    var str = "N/A";
    if (cmp["-NUMBER"]) {
        str = cmp["-TYPE"];
    } else if (cmp["-TNODE_NO"]) {
        str = cmp["TYPE"];
    } else {
        str = cmp["CHAMBER_TYPE"];
    }
    return str;
}

// Called by Floinhance
function displayObjectResult(objName) {
	openSingleEntity(objName);
}	

function handleStandAloneOrFloinhance() {

	if (typeof qt === "object") {
		new QWebChannel(qt.webChannelTransport, function (channel) {
			g_floObject = channel.objects.floinhanceRVW;
		});
		return;
	}
	
	var parentDiv = document.createElement('div');
	parentDiv.style = "position:fixed; \
								bottom:0px; \
								right:0px; \
								float:right; \
								background: gray; \
								color: white; \
								height:100px; \
								width:200px; \
								flaoting:bottom;\
								border:1px";

    // Not running in Floinhance, but in a browser
	var myTextEdit = document.createElement('input');
	myTextEdit.type = "text";
	myTextEdit.style = "color: red;";
	myTextEdit.placeholder = "i.e. element2, chamber223";

	var displayResultBtn = document.createElement('button');
	displayResultBtn.style = "color: black;";
	displayResultBtn.innerHTML = "Show component";
	displayResultBtn.onclick = function () {
		openSingleEntity(myTextEdit.value);
		activateTab("singleTab");
	};
	parentDiv.appendChild(myTextEdit);
	parentDiv.appendChild(displayResultBtn);

	document.body.appendChild(parentDiv);
}

function openSingleEntity(objectName) {
    if (document.getElementById("componentResultDiv")) {
        document.getElementById("componentResultDiv").remove();
    }
    clearSelectionHelpText();
    try {
        document.getElementById("singleTab").appendChild(createSingleResultDiv(objectName));
    } catch (e) {
        console.log("No such object. " + e.message);
    }
}

function init() {
	var xotree = new XML.ObjTree();
	var xmlStr = document.getElementById('myxml').innerHTML;
	
	var beg = xmlStr.search("<YFT_MODEL");
	var endStr = "</YFT_MODEL>";
	var end = xmlStr.search(endStr) + endStr.length;
	var tree = xotree.parseXML(xmlStr.substring(beg, end));
	if (!tree || !tree.YFT_MODEL || tree.YFT_MODEL.parsererror) {
	    document.write("Result XML parse error");
	    return false;
	}

	db.init(tree);
	handleStandAloneOrFloinhance();
	return true;
}


function activateTab(tab){
  $('.nav-tabs a[href="#' + tab + '"]').tab('show');
};

function prepareTabs() {
    var tabDef = '<ul class="nav nav-tabs">' +
    '  <li class="active"><a data-toggle="tab" href="#singleTab">Detailed Single Entity</a></li>' +
    '  <li><a data-toggle="tab" href="#entireTab">Entire Model</a></li>' +
    '  <li><a data-toggle="tab" href="#queryTab">Query Results</a></li>' +
    '</ul>' +
    '<div class="tab-content">' +
    '  <div id="singleTab" class="tab-pane fade in active"></div>' +
    '  <div id="entireTab" class="tab-pane fade"></div>' +
    '  <div id="queryTab" class="tab-pane fade"></div>' +
    '</div>'
    ;
    document.write(tabDef);

    $(document).ready(function () {
        document.getElementById("singleTab").appendChild(createSelectionHelpText());
        document.getElementById("queryTab").appendChild(createQueryResultsScreen());
        document.getElementById("entireTab").appendChild(createEntireModelScreen());
    });

    $('.nav-tabs a').on('shown.bs.tab', function (event) {
        var x = $(event.target);         // active tab
        var y = $(event.relatedTarget).text();  // previous tab
    });
}
	

if (init()) {
	prepareTabs();
}
