# UDE to calculate a flowrate using the Hazen-Willimas formula
# Restrictions: Only good for liquid Water at moderate temperatures and turbulent Reynolds number.
#                     Water fills entire pipe area

# Get input variables
PIPE_DIA      = 36 #= ude.get_scalar_property('PIPE_DIA')              # in
PIPE_LENGTH   = 4000*12 #= ude.get_scalar_property('PIPE_LENGTH')           # ft
HW_ROUGH_COEF = 120 #= ude.get_scalar_property('HW_ROUGH_COEF')         # no units

# Get required properties
PTS         = 20 #= ude.get_boundary_condition(ude.PTS)         # upstream pressure (psia)
PSEB        = 14.7 #= ude.get_boundary_condition(ude.PSEB)        # downstream static pressure (psia)
RHO_INLET   = 60 #= ude.get_fluid_property(ude.RHO_INLET)       # upstream density (lbm/ft^3)
MU_INLET    = 2.35 #= ude.get_fluid_property(ude.MU_INLET)        # upstream viscosity (lbm/hr/ft)

# Get automatically determined flow direction (based on inlet and exit pressures)
#flow_direction = ude.get_flow_direction()

gc = 32.17405

PIPE_AREA   = 0.25 * 3.14 * PIPE_DIA**2            # in^2
HYD_RAD     = PIPE_DIA  /  4. / 12.                   # ft
HEAD_LOSS   = (PTS - PSEB) * 144. / RHO_INLET         # ft
S           = HEAD_LOSS / PIPE_LENGTH

# Hazen Williams water velocity equation
VEL                  = 1.318 * HW_ROUGH_COEF * HYD_RAD**0.63 * S**0.54      # ft/sec

Q                     = VEL * PIPE_AREA / 144.                               # ft^3/sec
MASS_FLOW             = RHO_INLET * Q                                        # lbm/sec
GPM                   = Q / 0.13368                                          # gallon per minute

RE                    = RHO_INLET * VEL * PIPE_DIA / 12. / MU_INLET * 3600.  # Reynolds number (unitless)

# Return results to main solver
#ude.set_solved_value(ude.MDOT1, MASS_FLOW)
#ude.set_solved_value(ude.VEL_EXIT, VEL)
#
#ude.set_extra_result('VOL_FLOW' , Q, '')
#ude.set_extra_result('REYNOLDS NUMBER' , RE, '')