
var defaultCommonVariable = {
    "Chamber": "OUTPUT/PTC",
    "Element": "FLOW/PPS",
    "TNode": "TOTAL_TEMP",
    "Resistor": "HEAT_FLOW"
};

function FilterData() {
    this.componentTypes = {};
    this.selectedType = "";
    this.componentSubTypes = {};
    this.selectedSubType = "";

    this.filteredComponents = [];
    this.commonVariables = {};
    this.autoCompleteItems = [];

    this.filteredComponentsList = null;
    this.filteredComponentsListParent = null;
    this.componentSubTypesList = null;
    this.componentSubTypesListParent = null;
    this.commonVariablesListSelect = null;
    this.commonVariablesList = null;
    this.commonVariablesListParent = null;
    this.defaultCommonVariableIndex = 0;


    this.populateComponentTypes = function () {
        var i = 0;
        if (db.getNumberOfElements()) {
            this.componentTypes[i] = "Elements";
            i++;
        }
        if (db.getNumberOfChambers()) {
            this.componentTypes[i] = "Chambers";
            i++;
        }
        if (db.getNumberOfResistors()) {
            this.componentTypes[i] = "Thermal Resistors";
            i++;
        }
        if (db.getNumberOfTNodes()) {
            this.componentTypes[i] = "Thermal Nodes";
            i++;
        }
        if (i) {
            this.selectedType = this.componentTypes[0];
        }
    }

    this.populateComponentSubTypes = function () {
        this.componentSubTypes = {};
        this.componentSubTypes["All"] = 0;
        this.selectedSubType = "All";

        if (this.selectedType == "Chambers" || this.selectedType == "All") {
            this.componentSubTypes["All"] += db.getNumberOfChambers();

            var numChambers = db.getNumberOfChambers();
            for (var i = 0; i < numChambers; i++) {
                var currentSubType = getComponentSubType(db.getChamberAtIndex(i));
                if (!this.componentSubTypes[currentSubType]) {
                    this.componentSubTypes[currentSubType] = 0;
                }
                this.componentSubTypes[currentSubType]++;
            }
        }
        if (this.selectedType == "Elements" || this.selectedType == "All") {
            this.componentSubTypes["All"] += db.getNumberOfElements();

            var numElements = db.getNumberOfElements();
            for (var i = 0; i < numElements; i++) {
                var currentSubType = getComponentSubType(db.getElementAtIndex(i));
                if (!this.componentSubTypes[currentSubType]) {
                    this.componentSubTypes[currentSubType] = 0;
                }
                this.componentSubTypes[currentSubType]++;
            }
        }
        if (this.selectedType == "Thermal Nodes" || this.selectedType == "All") {
            this.componentSubTypes["All"] += db.getNumberOfTNodes();
            for (var i = 0; i < db.getNumberOfTNetworks() ; i++) {
                for (var j = 0; j < db.getTNodes(i).length; j++) {
                    var currentSubType = getComponentSubType(db.getTNodeAtIndex(i, j));
                    if (!this.componentSubTypes[currentSubType]) {
                        this.componentSubTypes[currentSubType] = 0;
                    }
                    this.componentSubTypes[currentSubType]++;
                }

            }
        }
        if (this.selectedType == "Thermal Resistors" || this.selectedType == "All") {
            this.componentSubTypes["All"] += db.getNumberOfResistors();
            for (var i = 0; i < db.getNumberOfTNetworks() ; i++) {
                for (var j = 0; j < db.getResistors(i).length; j++) {
                    var currentSubType = getComponentSubType(db.getResistorAtIndex(i, j));
                    if (!this.componentSubTypes[currentSubType]) {
                        this.componentSubTypes[currentSubType] = 0;
                    }
                    this.componentSubTypes[currentSubType]++;
                }

            }
        }
    }

    this.filterComponents = function () {
        this.filteredComponents = [];
        if (this.selectedType == "Chambers" || this.selectedType == "All") {
            var numChambers = db.getNumberOfChambers();
            for (var i = 0; i < numChambers; i++) {
                var currentSubType = getComponentSubType(db.getChamberAtIndex(i));
                if (this.selectedSubType == "All" || currentSubType == this.selectedSubType) {
                    this.filteredComponents.push(db.getChamberAtIndex(i));
                }
            }
        }
        if (this.selectedType == "Elements" || this.selectedType == "All") {
            var numElements = db.getNumberOfElements();
            for (var i = 0; i < numElements; i++) {
                var currentSubType = getComponentSubType(db.getElementAtIndex(i));
                if (this.selectedSubType == "All" || currentSubType == this.selectedSubType) {
                    this.filteredComponents.push(db.getElementAtIndex(i));
                }
            }
        }
        if (this.selectedType == "Thermal Nodes" || this.selectedType == "All") {
            for (var i = 0; i < db.getNumberOfTNetworks() ; i++) {
                for (var j = 0; j < db.getTNodes(i).length; j++) {
                    var currentSubType = getComponentSubType(db.getTNodeAtIndex(i, j));
                    if (this.selectedSubType == "All" || currentSubType == this.selectedSubType) {
                        this.filteredComponents.push(db.getTNodeAtIndex(i, j));
                    }
                }

            }
        }
        if (this.selectedType == "Thermal Resistors" || this.selectedType == "All") {
            for (var i = 0; i < db.getNumberOfTNetworks() ; i++) {
                for (var j = 0; j < db.getResistors(i).length; j++) {
                    var currentSubType = getComponentSubType(db.getResistorAtIndex(i, j));
                    if (this.selectedSubType == "All" || currentSubType == this.selectedSubType) {
                        this.filteredComponents.push(db.getResistorAtIndex(i, j));
                    }
                }

            }
        }
    }

    this.populateCommonVariables = function () {
        this.commonVariables = {};

        for (var i in this.filteredComponents) {
            for (var j in this.filteredComponents[i]) {
                if (j == "INPUT"
                    || j == "ELEMENT_INPUT_DATA"
                    || j == "SEGMENT_DATA"
                    || j == "STATION_DATA"
                    || j == "CHAMBER_UPSTREAM"
                    || j == "CHAMBER_DOWNSTREAM"
                    || j == "UPSTREAM_RESULTS"
                    || j == "DOWNSTREAM_RESULTS"
                    || j == "ELEMENT_BEND_INPUT_DATA"
                    || j == "ELEMENT_INPUT_DATA"
                    || j == "ELEMENT_VLV_INPUT_DATA"
                    ) {
                    continue;
                }
                if (isAttribute(j)) {
                    continue;
                };
                if (typeof this.filteredComponents[i][j] !== 'object') {
                    if (this.selectedType != "Thermal Resistors" && this.selectedType != "Thermal Nodes") {
                        continue;
                    }
                    if (!this.commonVariables[j]) {
                        this.commonVariables[j] = 0;
                    }
                    this.commonVariables[j]++;
                } else {
                    for (var k in this.filteredComponents[i][j]) {
                        if (isAttribute(k)) {
                            continue;
                        }
                        if (!this.commonVariables[j + "/" + k]) {
                            this.commonVariables[j + "/" + k] = 0;
                        }
                        this.commonVariables[j + "/" + k]++;
                    }
                }
            }
        }

        this.autoCompleteItems = [];
        var count = 0;
        this.defaultCommonVariableIndex = 0;
        for (var i in this.commonVariables) {
            if (i.includes("/")) {
                // Add variable to autocomplete list
                var lbl = i.split("/")[1];
                var ctg = i.split("/")[0];
                var entry = "[" + ctg + "][" + lbl + "]";
                this.autoCompleteItems.push(entry);
            } else {
                var entry = "[" + i + "]";
                this.autoCompleteItems.push(entry);
            }
            // Determine default common variable that will be selected initially
            if (i == defaultCommonVariable["Chamber"] || i == defaultCommonVariable["Element"]
                || i == defaultCommonVariable["TNode"] || i == defaultCommonVariable["Resistor"]) {
                this.defaultCommonVariableIndex = count;
            }
            count++;
        }
    }

    this.createComponentTypeSelection = function () {
        var myDiv = document.createElement('div');
        myDiv.className = "resultsFilterDropDownDiv";
        myDiv.id = "resultsFilterType";

        myDiv.appendChild(document.createElement("p").appendChild(document.createTextNode("Filter by object type: ")));
        var componentSelect = document.createElement("select");
        for (var i in this.componentTypes) {
            componentSelect.appendChild(new Option(this.componentTypes[i], this.componentTypes[i]));
        }
        myDiv.appendChild(componentSelect);

        var self = this;
        componentSelect.onchange = function () {
            self.onComponentTypeChanged(componentSelect[componentSelect.selectedIndex].value);
        }
        return myDiv;
    }

    this.createComponentSubTypeSelection = function () {
        var myDiv = document.createElement('div');
        myDiv.className = "resultsFilterDropDownDiv";
        myDiv.id = "resultsFilterSubType";

        myDiv.appendChild(document.createElement("p").appendChild(document.createTextNode("Filter by object subtype: ")));
        var subComponentSelect = document.createElement("select");
        for (var i in this.componentSubTypes) {
            var sttext = i + " (" + this.componentSubTypes[i] + ")";
            subComponentSelect.appendChild(new Option(sttext, i));
        }

        var self = this;
        subComponentSelect.onchange = function () {
            self.onComponentSubTypeChanged(subComponentSelect[subComponentSelect.selectedIndex].value);
        }
        myDiv.appendChild(subComponentSelect);

        this.componentSubTypesList = myDiv;
        return myDiv;
    }

    this.createCommonVariablesSelection = function () {
        var cntDiv = document.createElement('div');

        var mySelect = document.createElement('select');

        for (var i in this.commonVariables) {
            mySelect.appendChild(new Option(i, i));
        }

        var self = this;
        mySelect.onchange = function () {
            if (mySelect.selectedIndex == -1) {
                return;
            }
            if (document.getElementById("variableGraphDiv")) {
                document.getElementById("variableGraphDiv").remove();
            }
            if (document.getElementById("variableTableDiv")) {
                document.getElementById("variableTableDiv").remove();
            }
            var tableDiv = self.createArrayTable(mySelect[mySelect.selectedIndex].value);
            if (tableDiv) {
                var graphDiv = self.createArrayGraph(mySelect[mySelect.selectedIndex].value, "Graph", 4);
                cntDiv.appendChild(tableDiv);
                cntDiv.appendChild(graphDiv);
            }
        };

        cntDiv.appendChild(document.createElement("p").appendChild(document.createTextNode("Results list: ")));
        cntDiv.appendChild(mySelect);
        cntDiv.appendChild(document.createElement('br'));

        this.commonVariablesListSelect = mySelect;
        this.commonVariablesList = cntDiv;
        return cntDiv;
    }

    this.createFilteredComponentsList = function () {
        var myDiv = document.createElement('div');
        myDiv.className = "resultsFilterListDiv";
        myDiv.appendChild(document.createElement('br'));

        var l = this.filteredComponents.length;
        var s = document.createElement('span');
        s.className = "objectListTitleClass";
        s.appendChild(document.createTextNode("Number of objects passing filter: " + l));
        s.appendChild(document.createElement('br'));
        myDiv.appendChild(s);

        for (var i = 0; i < l; i++) {
            var str = getComponentName(this.filteredComponents[i]);
            myDiv.appendChild(document.createTextNode(str));
            myDiv.appendChild(document.createElement('br'));
        }

        var createGroupButton = document.createElement('button');
        createGroupButton.innerHTML = "Create group";
        var self = this;
        createGroupButton.onclick = function () {
            console.log("Creating group of listed components in Floinhance.");
            var groupName = prompt("Enter name of component group", "filteredGroup");
            if (groupName == null) {
                return;
            }
            var groupInfo = "";
            for (var i in self.filteredComponents) {
                groupInfo += getComponentShortName(self.filteredComponents[i]) + ",";
            }

            if (g_floObject) {
                g_floObject.createGroup(groupName, groupInfo);
            }
        };

        var parentDiv = document.createElement('div');
        parentDiv.id = "resultsFilterComponents";
        parentDiv.appendChild(myDiv);
        parentDiv.appendChild(createGroupButton);

        this.filteredComponentsList = parentDiv;
        return parentDiv;
    }

    this.createFilterTextBox = function () {
        var myDiv = document.createElement('div');

        myDiv.appendChild(document.createTextNode("Filter by result: "));

        var myTextEdit = document.createElement('input');
        myTextEdit.id = "filterTextEdit";
        myTextEdit.type = "text";
        myTextEdit.name = "filterText";
        myTextEdit.placeholder = "i.e. Math.pow([OUTPUT][RADIUS], 2) * Math.PI < 4";
        myTextEdit.className = "filterTextClass";
        var self = this;
        myTextEdit.onkeyup = function () {
            self.onFilterTextEntered(myTextEdit.value);
        }
        myDiv.appendChild(myTextEdit);

        return myDiv;
    }

    this.createArrayTable = function (selected) {
        var myDiv = document.createElement('div');
        myDiv.className = "analyzeResultTableDivClass";
        myDiv.id = "variableTableDiv";

        var myTable = document.createElement('table');
        myTable.className = "resultTableClass";
        myTable.id = "resultTable";
        myTable.style = "height: 200px; overflow-y:auto";

        var tableHeader = myTable.createTHead();
        var hdRow = tableHeader.insertRow();
        hdRow.insertCell().innerHTML = "Index";
        hdRow.insertCell().innerHTML = "Object Type";
        hdRow.insertCell().innerHTML = "Object ID";
        hdRow.insertCell().innerHTML = "Object Sub Type";
        hdRow.insertCell().innerHTML = selected;

        var bdy = myTable.createTBody();
        var index = 0;
        for (var i = 0; i < this.filteredComponents.length; i++) {
            var resCat, res = "N/A";
            if (selected.includes("/")) {
                resCat = selected.split('/')[0];
                res = selected.split('/')[1];
                if (!this.filteredComponents[i][resCat] || !this.filteredComponents[i][resCat][res]) {
                    continue;
                }
            } else {
                resCat = selected;
                if (!this.filteredComponents[i][resCat]) {
                    continue;
                }
            }

            var rw = bdy.insertRow();
            var h = document.createElement('th');
            h.innerHTML = index++;
            rw.appendChild(h);
            rw.insertCell().innerHTML = getComponentType(this.filteredComponents[i]);
            rw.insertCell().innerHTML = getComponentNo(this.filteredComponents[i]);
            rw.insertCell().innerHTML = getComponentSubType(this.filteredComponents[i]);
            if (res == "N/A") {
                rw.insertCell().innerHTML = this.filteredComponents[i][resCat];
            } else {
                rw.insertCell().innerHTML = this.filteredComponents[i][resCat][res];
            }
        }
        myDiv.appendChild(myTable);

        return myDiv;
    }

    this.createArrayGraph = function (selected, hdr, depth) {
        var myDiv = document.createElement('div');
        myDiv.className = "graph2dDiv";
        myDiv.id = "variableGraphDiv";

        var canvasCtx = document.createElement('canvas');
        canvasCtx.id = "arrayGraph";
        canvasCtx.className = "graphCanvas";
        myDiv.appendChild(canvasCtx);

        var xAxisElements = [];
        var yAxisElements = [];
        for (var i = 0; i < this.filteredComponents.length; i++) {
            var resCat, res = "N/A";
            if (selected.includes("/")) {
                resCat = selected.split('/')[0];
                res = selected.split('/')[1];
                if (!this.filteredComponents[i][resCat] || !this.filteredComponents[i][resCat][res]) {
                    continue;
                }
            } else {
                resCat = selected;
                if (!this.filteredComponents[i][resCat]) {
                    continue;
                }
            }
            xAxisElements.push(getComponentNo(this.filteredComponents[i]));
            if (res == "N/A") {
                yAxisElements.push(this.filteredComponents[i][resCat]);
            } else {
                yAxisElements.push(this.filteredComponents[i][resCat][res]);
            }
        }

        var myChart = new Chart(canvasCtx.getContext("2d"), {
            type: 'line',
            data: {
                labels: xAxisElements,
                datasets: [{
                    label: selected,
                    data: yAxisElements,
                    tension: 0,
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                legend: {
                    display: false,
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            // beginAtZero: true
                        },
                        scaleLabel: {
                            display: true,
                            labelString: selected,
                        }
                    }],
                    xAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: "Objects",
                        }
                    }]
                }
            }
        });
        return myDiv;
    }

    this.onComponentTypeChanged = function (typ) {
        this.selectedType = typ;
        this.populateComponentSubTypes();
        this.filterComponents();
        this.populateCommonVariables();

        if (this.componentSubTypesList) {
            this.componentSubTypesList.remove();
        }
        this.componentSubTypesListParent.appendChild(this.createComponentSubTypeSelection());

        if (this.filteredComponentsList) {
            this.filteredComponentsList.remove();
            this.filteredComponentsListParent.appendChild(this.createFilteredComponentsList());
        }

        if (this.commonVariablesList) {
            this.commonVariablesList.remove();
            this.commonVariablesListParent.appendChild(this.createCommonVariablesSelection());
        }

        if (this.commonVariablesListSelect) {
            this.commonVariablesListSelect.selectedIndex = this.defaultCommonVariableIndex;
            this.commonVariablesListSelect.onchange();
        }
    }

    this.onComponentSubTypeChanged = function (st) {
        this.selectedSubType = st;
        this.filterComponents();
        this.populateCommonVariables();

        if (this.filteredComponentsList) {
            this.filteredComponentsList.remove();
            this.filteredComponentsListParent.appendChild(this.createFilteredComponentsList());
        }

        if (this.commonVariablesList) {
            this.commonVariablesList.remove();
            this.commonVariablesListParent.appendChild(this.createCommonVariablesSelection());
            this.commonVariablesListSelect.selectedIndex = this.defaultCommonVariableIndex;
            this.commonVariablesListSelect.onchange();
        }
    }

    this.onFilterTextEntered = function (str) {
        this.filterComponents();
        if (!str || str.length == 0) {
            this.filteredComponentsList.remove();
            this.filteredComponentsListParent.appendChild(this.createFilteredComponentsList());
            return;
        }

        // User enters something like: [CHAMBER_UPSTREAM][CHTYP] < 0 && [INPUT][MACH] < 0
        // This code finds the items [A][B] and transforms them to this.filteredComponents[i]["A"]["B"] 
        // so that the entered string is a valid JS code and can be eval()'d
        var resultStr = "";
        var state = "findFirst[";
        var l = str.length;
        for (var i = 0; i < l; i++) {
            if (state == "findFirst[") {
                if (str.charAt(i) == '[') {
                    resultStr += 'this.filteredComponents[i]["';
                    state = "findFirst]";
                    continue;
                }
            } else if (state == "findFirst]") {
                if (str.charAt(i) == ']') {
                    resultStr += '"]';
                    state = "findSecond[";
                    continue;
                }
            } else if (state == "findSecond[") {
                if (str.charAt(i) == '[') {
                    resultStr += '["';
                    state = "findSecond]";
                    continue;
                }
            } else if (state == "findSecond]") {
                if (str.charAt(i) == ']') {
                    resultStr += '"]';
                    state = "findFirst[";
                    continue;
                }
            }
            resultStr += str.charAt(i);
        }
        var i = this.filteredComponents.length;
        while (i--) {
            var res = false;
            try {
                var res = eval(resultStr);
            } catch (e) {
                res = false;
            };
            if (!res) {
                this.filteredComponents.splice(i, 1);
            }
        }
        this.filteredComponentsList.remove();
        this.filteredComponentsListParent.appendChild(this.createFilteredComponentsList());
    }
}

$(function () {
    function split(val) {
        return val.split(/\s/);
    }
    function extractLast(term) {
        return split(term).pop();
    }

    $("#filterTextEdit")
      // don't navigate away from the field on tab when selecting an item
      .on("keydown", function (event) {
          if (event.keyCode === $.ui.keyCode.TAB &&
              $(this).autocomplete("instance").menu.active) {
              event.preventDefault();
          }
      })
      .autocomplete({
          minLength: 0,
          source: function (request, response) {
              // delegate back to autocomplete, but extract the last term
              response($.ui.autocomplete.filter(
                queryResultData.autoCompleteItems, extractLast(request.term)));
          },
          focus: function () {
              // prevent value inserted on focus
              return false;
          },
          select: function (event, ui) {
              var terms = split(this.value);
              // remove the current input
              terms.pop();
              // add the selected item
              terms.push(ui.item.value);
              // add placeholder to get the space at the end
              terms.push("");
              this.value = terms.join(" ");
              return false;
          }
      });
});

var entireModelData = new FilterData();
var queryResultData = new FilterData();

function createQueryResultsScreen() {
    var fd = queryResultData;
    fd.populateComponentTypes();
    fd.populateComponentSubTypes();
    fd.filterComponents();
    fd.populateCommonVariables();

    rfDiv = document.createElement('div');
    rfDiv.className = "resultsFilterClass";
    rfDiv.id = "resultsFilterDiv";
    rfDiv.style = "width: 400px;";

    rfTypeDiv = document.createElement('div');
    rfTypeDiv.className = "resultsFilterClass";
    rfTypeDiv.id = "resultsFilterTypeParent";
    rfDiv.appendChild(rfTypeDiv);

    rfSubTypeDiv = document.createElement('div');
    rfSubTypeDiv.className = "resultsFilterClass";
    rfSubTypeDiv.id = "resultsFilterSubTypeParent";
    rfDiv.appendChild(rfSubTypeDiv);
    fd.componentSubTypesListParent = rfSubTypeDiv;

    rfFilterTextDiv = document.createElement('div');
    rfFilterTextDiv.className = "resultsFilterClass";
    rfFilterTextDiv.id = "resultsFilterTextParent";
    rfDiv.appendChild(rfFilterTextDiv);

    rfComponentListDiv = document.createElement('div');
    rfComponentListDiv.className = "resultsFilterComponentsClass";
    rfComponentListDiv.id = "resultsFilterComponentListParent";
    rfDiv.appendChild(rfComponentListDiv);
    fd.filteredComponentsListParent = rfDiv;

    rfTypeDiv.appendChild(fd.createComponentTypeSelection());
    rfSubTypeDiv.appendChild(fd.createComponentSubTypeSelection());
    rfFilterTextDiv.appendChild(fd.createFilterTextBox());
    rfComponentListDiv.appendChild(fd.createFilteredComponentsList());

    return rfDiv;
}

function createEntireModelScreen() {
    var fd = entireModelData;
    fd.populateComponentTypes();
    fd.populateComponentSubTypes();
    fd.filterComponents();
    fd.populateCommonVariables();

    var myDiv = document.createElement('div');
    myDiv.id = "variableSelect";

    rfTypeDiv = document.createElement('div');
    rfTypeDiv.className = "resultsFilterClass";
    rfTypeDiv.id = "resultsFilterTypeParent";
    myDiv.appendChild(rfTypeDiv);

    rfSubTypeDiv = document.createElement('div');
    rfSubTypeDiv.className = "resultsFilterClass";
    rfSubTypeDiv.id = "resultsFilterSubTypeParent";
    myDiv.appendChild(rfSubTypeDiv);
    fd.componentSubTypesListParent = rfSubTypeDiv;

    rfCommonVarsDiv = document.createElement('div');
    rfCommonVarsDiv.className = "resultsFilterClass";
    rfCommonVarsDiv.id = "resultsFilterSubTypeParent";
    myDiv.appendChild(rfCommonVarsDiv);
    fd.commonVariablesListParent = rfCommonVarsDiv;

    rfTypeDiv.appendChild(fd.createComponentTypeSelection());
    rfSubTypeDiv.appendChild(fd.createComponentSubTypeSelection());
    rfCommonVarsDiv.appendChild(fd.createCommonVariablesSelection());

    fd.commonVariablesListSelect.selectedIndex = fd.defaultCommonVariableIndex;
    fd.commonVariablesListSelect.onchange();
    return myDiv;
}
