@echo off
setlocal ENABLEDELAYEDEXPANSION

rem Start: ENVIRONMENT SETUP SECTION
rem The "ENVIRONMENT SETUP SECTION"  is used to setup the environment needed for the FORTRAN compiler.
rem It can be modified as needed for your computer system.
SET ifort_cmd_dir=C:\Program Files (x86)\Intel\Composer XE 2015\bin
SET ifort_cmd_dir=%ifort_cmd_dir:/=\%

SET link_cmd_dir=C:\Program Files (x86)\Microsoft Visual Studio 10.0\VC\bin\amd64
SET link_cmd_dir=%link_cmd_dir:/=\%
 

if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
 
rem   set PLATFORM_DIR=winx64
   set IFORT_PLATFORM=intel64
rem   set BIT_TARGET=64
   set LIB=.\lib\winx64;!LIB!

) else if "%PROCESSOR_ARCHITEW6432%"=="AMD64" (

rem   set PLATFORM_DIR=winx64
   set IFORT_PLATFORM=intel64
rem   set BIT_TARGET=64
   set LIB=.\lib\winx64;!LIB!

) else if "%PROCESSOR_ARCHITECTURE%"=="x86" (

rem   set PLATFORM_DIR=Intel
   set IFORT_PLATFORM=ia32
rem   set BIT_TARGET=32
   set LIB=.\lib\intel;!LIB!
)



call "%ifort_cmd_dir%\compilervars.bat" %IFORT_PLATFORM% %vs_ver%

 
rem  Set the ifort path based on the processor
set PATH=%ifort_cmd_dir%;%ifort_cmd_dir%\%IFORT_PLATFORM%;%link_cmd_dir%;%PATH%

rem End: ENVIRONMENT SETUP SECTION




rem Start: COMPILE SECTION
rem This section will compile the myelib.f file to create the myelib.obj

rem The compiler searches the INCLUDE directory for modules used in USE statement.
rem There are 2 module files from the main solver that need to be in the INCLUDE1 directory:
rem myelib_interface_mod.mod and myelib_param_mod.mod
set INCLUDE1="/include:.\build_W764_IN15"


set OBJ1="/object:.\build_W764_IN15\myelib.obj"



rem Compiler options (should use - for linux and / for windows)
rem  /c                          : compile only
rem  /Gm                         : really should use /iface:cvf
rem /iface:nomixed_str_len_arg   : calling convention for mixed language
rem /Qip                         : enables optimization by inline code
rem /4L132                       : extend line column limit to 132
rem /nofree                      : files are not in free format
rem /4Na                         : 4Na causes local variables to retain values (prevents NaNs for uninitialized variables)
rem /libs                    : 
rem /threads                     : Tells the linker to search for unresolved references in a multithreaded run-time library
rem /fpconstant                  : Tells the compiler that single-precision constants assigned to double-precision variables should be evaluated in double precision
rem /convert:big_endian          : Specifies that the format will be big endian for integer data and big endian IEEE floating-point for real and complex data
rem /traceback                   : adds traceback information to the executable for easier debugging
rem /fpe:0                       : enables floating point invalid, divide by zero, and overflow exceptions


set comp_flags="/c /Gm /iface:nomixed_str_len_arg /nologo /Qip /4L132 /nofree /4Na /libs /threads /fpconstant /convert:big_endian /traceback /fpe:0 /Od /check:nooutput_conversion"

rem set dbg_flags to "" for no debug.  Use the /debug:full line for full debugging
set dbg_flags=" "
rem set dbg_flags="/debug:full /Z7 /check:all"


rem remove the file that contains the compile errors and warnings
del /Q compile.out 


ifort "%comp_flags%" "%dbg_flags%" "%INCLUDE1%"  "%OBJ1%" myelib.f >>compile.out  2>&1

echo Compiling complete.  Check f_comp.log for errors and warnings.

rem End: COMPILE SECTION
 

 

rem Start: LINK SECTION
rem This section will create the myelib.dll from the myelib.obj

rem remove the file that contains the linker errors and warnings
del /Q link.out


link /VERBOSE /DLL  .\build_W764_IN15\myelib.obj  /out:.\build_W764_IN15\myelib.dll >> .\link.out 2>&1

echo Linking complete.  Check link.out.log for errors and warnings.
echo Copy myelib.dll into a directory that is in your PATH, or the model directory, or the executable directory.

@echo off

rem End: LINK SECTION