!
!#################################################################################
!                                                                                # 
!                  M O D U L E       M Y E L I B _ P A R A M _ M O D             #
!                                                                                #
!#################################################################################
!
!   ============================ MODULE: MYELIB_PARAM_MOD =============================
!
!   WRITTEN BY/DATE:    Shane Cline (GE Power)                   February 26, 2017
!
!   COPYRIGHT (c) 2017  GE Aircraft Engines
!
!   SECURITY:           Company Proprietary
!
!   FUNCTION/PURPOSE:   To help engineers develop custom flow elements inside Flow Simulator
!        
!
!
!   ************************
!   *** REVISION HISTORY ***
!   ************************
!
!   RELEASE EDITION:    Initial Demo for Oil&Gas Engineers
!   REVISED BY/DATE:    Shane Cline (GE Power)                   February 26, 2017
!   ACTION:             Developed using parts of existing UDE infrastructure
!                       This allows users to keep using the UDE designer in the GUI
!
!
!   RELEASE EDITION:    19r1
!   REVISED BY/DATE:    Jim Bruns                   May 2019
!   ACTION:             Moved from myelib_core_module.f90 so it can be easily used by user's myelib
!
!   ============================ MODULE: MYELIB_PARAM_MOD ==============================
!
      MODULE MYELIB_PARAM_MOD
      
      IMPLICIT NONE
      
!     Boundary Condition Identifiers (BC_ID), use in function GET_UDE_BOUNDARY_CONDITION and GET_UDE_FLUID_PROPERTY
      INTEGER, PARAMETER                                   ::   UDE_MIN_BC_ID                 =  0
      INTEGER, PARAMETER                                   ::   UDE_PTS                       =  0       ! Element-aligned Source Total Pressure (psia)
      INTEGER, PARAMETER                                   ::   UDE_TTS                       =  1       ! Element Source Total Temperature (degF)
      INTEGER, PARAMETER                                   ::   UDE_FS                        =  2       ! The mass fraction of the secondary fluid
      INTEGER, PARAMETER                                   ::   UDE_PSEB                      =  3       ! Element Sink Static Pressure (psia)
      INTEGER, PARAMETER                                   ::   UDE_RELANGL                   =  4       ! Angle (Degrees) between upstream fluid velocity vector and element centerline (For advance use only)
      INTEGER, PARAMETER                                   ::   UDE_DQ_IN                     =  5       ! Total Pressure loss parameter at the Inlet
      INTEGER, PARAMETER                                   ::   UDE_THETA_INLET               =  6       ! Flow Path Tangential Angle (Degrees) at Element Inlet (For advanced use only) 
      INTEGER, PARAMETER                                   ::   UDE_PHI_INLET                 =  7       ! Flow Path Radial Angle (Degrees) at Element Inlet (For advanced use only
      INTEGER, PARAMETER                                   ::   UDE_THETA_EXIT                =  8       ! Flow Path Tangential Angle (Degrees) at Element Exit (For advanced use only)
      INTEGER, PARAMETER                                   ::   UDE_PHI_EXIT                  =  9       ! Flow Path Radial Angle (Degrees) at Element Exit (For advanced use only)
      INTEGER, PARAMETER                                   ::   UDE_RHO_INLET                 = 20       ! Density in (Lbm/ft^3) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_RGAS_INLET                = 21       ! Gas Constant in (Lbf*ft/Lbm/degF) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_CP_INLET                  = 22       ! Specific Heat (Btu/Lbm/degF) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_GAMMA_INLET               = 23       ! Specific Heats Ratio (unitless) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_MU_INLET                  = 24       ! Dynamic Viscosity (Lbm/ft/hr) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_KOND_INLET                = 25       ! Thermal Conductivity (Btu/hr/ft/degF) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_PRANDTL_INLET             = 26       ! Prandtl Number (unitless) at Inlet
      INTEGER, PARAMETER                                   ::   UDE_RHO_AVG                   = 30       ! Density in (Lbm/ft^3) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_RGAS_AVG                  = 31       ! Gas Constant in (Lbf*ft/Lbm/degF) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_CP_AVG                    = 32       ! Specific Heat (Btu/Lbm/degF) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_GAMMA_AVG                 = 33       ! Specific Heats Ratio (unitless) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_MU_AVG                    = 34       ! Dynamic Viscosity (Lbm/ft/hr) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_KOND_AVG                  = 35       ! Thermal Conductivity (Btu/hr/ft/degF) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_PRANDTL_AVG               = 36       ! Prandtl Number (unitless) averaged across Inlet and Exit
      INTEGER, PARAMETER                                   ::   UDE_RHO_EXIT                  = 40       ! Density in (Lbm/ft^3) at Exit
      INTEGER, PARAMETER                                   ::   UDE_RGAS_EXIT                 = 41       ! Gas Constant in (Lbf*ft/Lbm/degF) at Exit
      INTEGER, PARAMETER                                   ::   UDE_CP_EXIT                   = 42       ! Specific Heat (Btu/Lbm/degF) at Exit
      INTEGER, PARAMETER                                   ::   UDE_GAMMA_EXIT                = 43       ! Specific Heats Ratio (unitless) at Exit
      INTEGER, PARAMETER                                   ::   UDE_MU_EXIT                   = 44       ! Dynamic Viscosity (Lbm/ft/hr) at Exit
      INTEGER, PARAMETER                                   ::   UDE_KOND_EXIT                 = 45       ! Thermal Conductivity (Btu/hr/ft/degF) at Exit
      INTEGER, PARAMETER                                   ::   UDE_PRANDTL_EXIT              = 46       ! Prandtl Number (unitless) at Exit
      INTEGER, PARAMETER                                   ::   UDE_MAX_BC_ID                 = 46       ! make this this == the last valid BC number

!     Solution Identifiers (SOL_ID), use in subroutine SET_UDE_SOLVED_VALUE
!     The derivatives UDE_D_MDOT1_D_PTS and UDE_D_MDOT1_D_PSEB help the main solver to converge better.
!     A rough estimate is calculated by default, so you do not need to spend time improving your flow function derivatives until
!     the final stage when you want to converge quickly and robustly.      
      INTEGER, PARAMETER                                   ::   UDE_MIN_SOLUTION_ID           = 100       ! 
      INTEGER, PARAMETER                                   ::   UDE_MDOT1                     = 100       ! Mass Flow Rate in (Lbm/s), Always positive.  The “1” signifies this is for a single stream in case the element has multiple streams.
      INTEGER, PARAMETER                                   ::   UDE_TT_EXIT                   = 101       ! Total Temperature (degR) at Element Exit before downstream chamber mixing.  This is set equal to TTS by default, so if your flow function is adiabatic, then you do not need to set TT_EXIT.
      INTEGER, PARAMETER                                   ::   UDE_VEL_EXIT                  = 102       ! Fluid Velocity (ft/s) at Element Exit
      INTEGER, PARAMETER                                   ::   UDE_D_MDOT1_D_PTS             = 103       ! Derivative of MDOT1 with respect to PTS.
      INTEGER, PARAMETER                                   ::   UDE_D_MDOT1_D_PSEB            = 104       ! Derivative of MDOT1 with respect to PSEB.
      INTEGER, PARAMETER                                   ::   UDE_MAX_SOLUTION_ID           = 104       ! make this this == the last valid solution number

!     Error Codes (ISTATUS)      
      INTEGER, PARAMETER                                   ::   UDE_UNITS_MISMATCH_ERROR      = -8
      INTEGER, PARAMETER                                   ::   UDE_UNRECOGNIZED_VARNAME      = -7                                                                                  
      INTEGER, PARAMETER                                   ::   UDE_INVALID_TYPE_INDEX        = -6
      INTEGER, PARAMETER                                   ::   UDE_INVALID_LOOKUP_ID_ERROR   = -5
      INTEGER, PARAMETER                                   ::   UDE_ARRAY_INDEX_BOUNDS_ERROR  = -4
      INTEGER, PARAMETER                                   ::   UDE_TYPE_NOT_FOUND            = -3
      INTEGER, PARAMETER                                   ::   UDE_ELEM_NOT_FOUND            = -2
      INTEGER, PARAMETER                                   ::   UDE_KEY_VALUE_NOT_FOUND       = -1
      INTEGER, PARAMETER                                   ::   UDE_PREDICATE_SUCCESS         =  0

!     Flow direction returned from function GET_UDE_FLOW_DIRECTION      
      INTEGER, PARAMETER                                   ::   FORWARD_FLOW_DIRECTION        =  1
      INTEGER, PARAMETER                                   ::   REVERSED_FLOW_DIRECTION       = -1
      INTEGER, PARAMETER                                   ::   UNDEFINED_FLOW_DIRECTION      =  0
      
      INTEGER, PARAMETER                                   ::   SEND_RESULTS_TO_FOR033DAT     =  1
      INTEGER, PARAMETER                                   ::   SEND_RESULTS_TO_UDERESULTSDAT =  2
      
      INTEGER, PARAMETER                                   ::   UDE_PROP_IS_IN_DOMAIN         =   0
      INTEGER, PARAMETER                                   ::   UDE_PROP_LT_LOWER_BOUND       = -11
      INTEGER, PARAMETER                                   ::   UDE_PROP_LTE_LOWER_BOUND      = -12
      INTEGER, PARAMETER                                   ::   UDE_PROP_GT_UPPER_BOUND       = -13
      INTEGER, PARAMETER                                   ::   UDE_PROP_GTE_UPPER_BOUND      = -14

!     (ELEMENT_SUBTYPE)      
      INTEGER, PARAMETER                                   ::   UDE_RESISTIVE_ELEMENT         =   0
      INTEGER, PARAMETER                                   ::   UDE_PUMP_LIKE_ELEMENT         =   1
                        
      INTEGER, PARAMETER                                   ::   UDE_ARRAY_SIZE                = -999999999
      
      INTEGER, PARAMETER                                   ::   VECTOR_STARTING_CAPACITY      = 8
      
      DOUBLE PRECISION, PARAMETER                          ::   POS_INFINITY                  =  99999999999999999999.0D0
      DOUBLE PRECISION, PARAMETER                          ::   NEG_INFINITY                  = -99999999999999999999.0D0
      DOUBLE PRECISION, PARAMETER                          ::   NOT_SET                       = -1D-30
      
      INTEGER, PARAMETER                                   ::   UDE_REAL                      = 1
      INTEGER, PARAMETER                                   ::   UDE_REAL_ARRAY                = 2

!     (LANGUEAGE)      
      INTEGER, PARAMETER                                   ::   UDE_FORTRAN                   = 1
      INTEGER, PARAMETER                                   ::   UDE_PYTHON                    = 2

!     the maximum number of character strings in the python code
      INTEGER, PARAMETER                                   ::   MAX_SCRIPT_LENGTH             =  32767
      

      CONTAINS
      
      SUBROUTINE JUNK_FOR_IN9
      END SUBROUTINE JUNK_FOR_IN9

      END MODULE MYELIB_PARAM_MOD      