!
!#################################################################################
!                                                                                # 
!                  M O D U L E       M Y E L I B _ I N T E R F A C E _ M O D     #
!                                                                                #
!#################################################################################
!
!   ============================ MODULE: MYELIB_PARAM_MOD =============================
!
!   WRITTEN BY/DATE:    Jim Bruns                             May, 2019
!
!   COPYRIGHT (c) 2019  GE Aircraft Engines
!
!   SECURITY:           Company Proprietary
!
!   FUNCTION/PURPOSE:   Contain interfaces to subroutines and functions in myelib_core_module.
!                       These interfaces are needed in the user supplied code (myelib.f)
!        
!
!   ************************
!   *** REVISION HISTORY ***
!   ************************
!
!
!
!   RELEASE EDITION:    19r1
!   REVISED BY/DATE:    Jim Bruns                   May, 2019
!   ACTION:             Original
!
!   ============================ MODULE: MYELIB_INTERFERFACE_MOD ==============================
!
      MODULE MYELIB_INTERFACE_MOD
      
      IMPLICIT NONE
      
      INTERFACE
         
         SUBROUTINE ERROR_IF_UDE_PROPERTY_IS_OUT_OF_DOMAIN_INTERF (UDE_ELNUM, PROPNAME, LB, L, U, UB, STOP_FLAG, ISTATUS)
!           Argument variables
            INTEGER,          INTENT(IN)                         ::   UDE_ELNUM           ! element # from .flo file
            CHARACTER(*),     INTENT(IN)                         ::   PROPNAME            ! UDE element input property name from .flo file
            CHARACTER*1,      INTENT(IN)                         ::   LB                  ! lower limit check method '(' or '['  :   '(' uses <=   ;   '[' uses <
            DOUBLE PRECISION, INTENT(IN)                         ::   L                   ! lower limit value
            DOUBLE PRECISION, INTENT(IN)                         ::   U                   ! upper limit value
            CHARACTER*1,      INTENT(IN)                         ::   UB                  ! upper limit check method ')' or ']'  :   ')' uses >=   ;   ']' uses >
            LOGICAL,          INTENT(INOUT)                      ::   STOP_FLAG           ! .TRUE. if there is a problem
            INTEGER,          INTENT(OUT)                        ::   ISTATUS             ! <0 means the function or subroutine has failed           
         END SUBROUTINE ERROR_IF_UDE_PROPERTY_IS_OUT_OF_DOMAIN_INTERF
         
         SUBROUTINE WARN_IF_UDE_PROPERTY_IS_OUT_OF_DOMAIN_INTERF (UDE_ELNUM, PROPNAME, LB, L, U, UB, STOP_FLAG, ISTATUS)
!           Argument variables
            INTEGER,          INTENT(IN)                         ::   UDE_ELNUM           ! element # from .flo file
            CHARACTER(*),     INTENT(IN)                         ::   PROPNAME            ! UDE element input property name from .flo file
            CHARACTER*1,      INTENT(IN)                         ::   LB                  ! lower limit check method '(' or '['  :   '(' uses <=   ;   '[' uses <
            DOUBLE PRECISION, INTENT(IN)                         ::   L                   ! lower limit value
            DOUBLE PRECISION, INTENT(IN)                         ::   U                   ! upper limit value
            CHARACTER*1,      INTENT(IN)                         ::   UB                  ! upper limit check method ')' or ']'  :   ')' uses >=   ;   ']' uses >
            LOGICAL,          INTENT(INOUT)                      ::   STOP_FLAG           ! .TRUE. if there is a problem
            INTEGER,          INTENT(OUT)                        ::   ISTATUS             ! <0 means the function or subroutine has failed         
         END SUBROUTINE WARN_IF_UDE_PROPERTY_IS_OUT_OF_DOMAIN_INTERF         

         CHARACTER(LEN=31) FUNCTION GET_UDE_TYPE_INTERF (UDE_ELNUM, ISTATUS)
!           Argument variables
            INTEGER, INTENT(IN)                                  ::   UDE_ELNUM             ! element # from .flo file
            INTEGER, INTENT(OUT)                                 ::   ISTATUS               ! <0 means the function or subroutine has failed    
         END FUNCTION GET_UDE_TYPE_INTERF

         DOUBLE PRECISION FUNCTION GET_UDE_SCALAR_PROPERTY_INTERF (UDE_ELNUM, PROP_NAME, ISTATUS)
!           Argument variables
            INTEGER,      INTENT(IN)                             ::   UDE_ELNUM                 ! element # from .flo file
            CHARACTER(*), INTENT(IN)                             ::   PROP_NAME                 ! UDE element input property name from .flo file
            INTEGER,      INTENT(INOUT)                          ::   ISTATUS                   ! <0 means the function or subroutine has failed            
         END FUNCTION GET_UDE_SCALAR_PROPERTY_INTERF
         
         DOUBLE PRECISION FUNCTION GET_UDE_ARRAY_PROPERTY_INTERF (UDE_ELNUM, PROP_NAME, IDX, ISTATUS)
!           Argument variables
            INTEGER,      INTENT(IN)                             ::   UDE_ELNUM                ! element # from .flo file
            CHARACTER(*), INTENT(IN)                             ::   PROP_NAME                ! UDE element input property name from .flo file
            INTEGER,      INTENT(IN)                             ::   IDX                      ! table index to retrieve or UDE_ARRAY_SIZE to return the table size
            INTEGER,      INTENT(OUT)                            ::   ISTATUS                  ! <0 means the function or subroutine has failed            
         END FUNCTION GET_UDE_ARRAY_PROPERTY_INTERF
         
         DOUBLE PRECISION FUNCTION GET_UDE_BOUNDARY_CONDITION_INTERF (UDE_ELNUM, BC_ID, ISTATUS)
!           Argument variables         
            INTEGER, INTENT(IN)                                  ::   UDE_ELNUM                ! element # from .flo file
            INTEGER, INTENT(IN)                                  ::   BC_ID                    ! ID of the boundary condition to return. (UDE_PTS, UDE_PSEB, etc..)
            INTEGER, INTENT(OUT)                                 ::   ISTATUS                  ! <0 means the function or subroutine has failed        
         END FUNCTION GET_UDE_BOUNDARY_CONDITION_INTERF
         
         DOUBLE PRECISION FUNCTION GET_UDE_FLUID_PROPERTY_INTERF (UDE_ELNUM, BC_ID, ISTATUS)
!           Argument variables         
            INTEGER, INTENT(IN)                                  ::   UDE_ELNUM             ! element # from .flo file
            INTEGER, INTENT(IN)                                  ::   BC_ID                 ! ID of the fluid property to return. (UDE_CP_INLET, UDE_PRANDTL_INLET etc..)
            INTEGER, INTENT(OUT)                                 ::   ISTATUS               ! <0 means the function or subroutine has failed
         END FUNCTION GET_UDE_FLUID_PROPERTY_INTERF

         INTEGER FUNCTION GET_UDE_FLOW_DIRECTION_INTERF  (UDE_ELNUM, ISTATUS)
!           Argument variables
            INTEGER, INTENT(IN)                                  ::   UDE_ELNUM             ! element # from .flo file
            INTEGER, INTENT(OUT)                                 ::   ISTATUS               ! <0 means the function or subroutine has failed        
         END FUNCTION GET_UDE_FLOW_DIRECTION_INTERF

         DOUBLE PRECISION FUNCTION UDE_GET_REFERENCE_CONDITION_INTERF (ITEMTYPE, ITEMNUM, LOCAT1, LOCAT2, LOCAT3, PROP, ISTATUS)
            CHARACTER(LEN=*), INTENT(IN)                          ::   ITEMTYPE             ! "CHAMBER", "ELEMENT", "THERMAL", "GENERAL", "MISSION", "COMPONENT"
            INTEGER,          INTENT(IN)                          ::   ITEMNUM              ! Number from the .flo file of the item (chamber, element, etc..)
            CHARACTER(LEN=*), INTENT(IN)                          ::   LOCAT1               ! First additional index. Ex "5" for tube station 5, "INLET" for element inlet, "NONE" if not needed, etc..
            CHARACTER(LEN=*), INTENT(IN)                          ::   LOCAT2               ! Second additional index. Ex "2" for tube wall side 2, "NONE" if not needed, etc..
            CHARACTER(LEN=*), INTENT(IN)                          ::   LOCAT3               ! Third additional index. Ex "2" for ?, "NONE" if not needed, etc..
            CHARACTER(LEN=*), INTENT(IN)                          ::   PROP                 ! A property name recognized by the controller (like PT, PS, TT, MDOT_TOTAL etc..)
            INTEGER,          INTENT(OUT)                         ::   ISTATUS              ! =0 means no error, <0 is error, >0 is unusual           
         END FUNCTION UDE_GET_REFERENCE_CONDITION_INTERF         

         SUBROUTINE WRITE_UDE_ERROR_MESSAGE_INTERF (MSG, UDE_ELNUM, PROPNAME, VALUE1, VALUE2, ISTATUS)
!           Argument variables
            CHARACTER(*),     INTENT(IN)                         ::   MSG                   ! message to write ("%..." text will be replaced with arguments)
            INTEGER,          INTENT(IN)                         ::   UDE_ELNUM             ! element # from .flo file                       (will replace %ELNUM in MSG)
            CHARACTER(*),     INTENT(IN)                         ::   PROPNAME              ! UDE element input property name from .flo file (will replace %PROPNAME in MSG)
            DOUBLE PRECISION, INTENT(IN)                         ::   VALUE1                ! a number used in the error check               (will replace %VALUE1 in MSG)
            DOUBLE PRECISION, INTENT(IN)                         ::   VALUE2                ! another number used in the error check         (will replace %VALUE2 in MSG)
            INTEGER,          INTENT(OUT)                        ::   ISTATUS               ! <0 means the function or subroutine has failed       
         END SUBROUTINE WRITE_UDE_ERROR_MESSAGE_INTERF

         SUBROUTINE SET_UDE_SOLVED_VALUE_INTERF (UDE_ELNUM, SOL_ID, SOL_VAL, ISTATUS)
!           Argument variables         
            INTEGER,          INTENT(IN)                         ::   UDE_ELNUM             ! element # from .flo file
            INTEGER,          INTENT(IN)                         ::   SOL_ID                ! ID of the solution being sent in SOL_VAL
            DOUBLE PRECISION, INTENT(IN)                         ::   SOL_VAL               ! solution value
            INTEGER,          INTENT(OUT)                        ::   ISTATUS               ! <0 means the function or subroutine has failed        
         END SUBROUTINE SET_UDE_SOLVED_VALUE_INTERF
 
         SUBROUTINE SET_UDE_EXTRA_RESULT_INTERF (UDE_ELNUM, RSLT_NAM, RSLT_VAL, RSLT_UNITS, ISTATUS)
!           Argument variables
            INTEGER,          INTENT(IN)                         ::   UDE_ELNUM             ! element # from .flo file
            CHARACTER(*),     INTENT(IN)                         ::   RSLT_NAM              ! Name of the extra result to write
            DOUBLE PRECISION, INTENT(IN)                         ::   RSLT_VAL              ! value of the extra result to write
            CHARACTER(*),     INTENT(IN)                         ::   RSLT_UNITS            ! units of the extra result to write
            INTEGER,          INTENT(OUT)                        ::   ISTATUS               ! <0 means the function or subroutine has failed
         END SUBROUTINE SET_UDE_EXTRA_RESULT_INTERF        
         
      END INTERFACE

      CONTAINS
      
      SUBROUTINE JUNK2_FOR_IN9
      END SUBROUTINE JUNK2_FOR_IN9      

      END MODULE MYELIB_INTERFACE_MOD