//modify by alex
//--------------------------------------------

/**
 * 修改原则:
 * 1. 对原库的任何改动都要在该库中实现,不要将实现散落在原库codes里面
 * 2. 即使不使用该修改代码也要保证原库能够按照未修改之前那样运行
 * 3. 任何对源库的修改都要写修改原因
**/

//--------------------------------------------
//for global controll.
(function(global) {

  var Alo7Delegate = Class.create({
    initialize: function() {
      var showUrl = decodeURIComponent(getUrlParameter('showUrl')) || "../";//default parent
      if(showUrl[showUrl.length - 1] !== '/') {
        showUrl = showUrl + '/';
      }
      this.showUrl = showUrl;

      document.observe(kScriptProgressDownloadEvent, this.handleScriptProgressDownloadEvent.bind(this));
      document.observe(kScriptDidDownloadEvent, this.handleScriptDidDownloadEvent.bind(this));
    },

    handleScriptDidDownloadEvent: function(evt) {
      document.title = evt.memo.script.title;
    },

    handleScriptProgressDownloadEvent: function(evt) {
    },

    showDidLoad: function() {
    },
    showExited: function () {
      history.go(-1)
    },
    propertyChanged: function (prop, val) {
      //console.log(prop, val);
      if(prop === 'currentSlide') {
        var hasPre = val > 0;
        var hasNext = val < gShowController.script.slideCount;
      }
    },
    setPlaybackReadyHandler: function (a) {
      a()
    },

    getSlideHeadJsonURL: function(slideName) {
      return this.showUrl + slideName + "/" + slideName + ".json";
    },

    getSlideThumbnailURL: function(slideName) {
      return this.showUrl + slideName + "/thumbnail.jpeg";
    },

    getFontFamilyDefinitionsJsonpURL: function(fontFamilyDefinitionsJsonp) {
      return "./font_family_definitions_jsonp.js";
    },

    updateWindowHistory: function(id) {
      //var url = location.origin + location.pathname + location.search + "#" + id;
      //window.history.replaceState(null, null, url);
    },

    processTexture: function(textureDocument) {
      if(!textureDocument || !textureDocument.documentElement) return;

      textureDocument.documentElement.style.overflow = 'overlay';
      //textureDocument.documentElement.setAttribute('clip-rule', 'nonzero')
      var textElements = textureDocument.getElementsByTagName('text');
      var textElement;
      var n = textElements.length;
      for(var i = 0; i < n; i++) {
        textElement = textElements[i];
        //"<text xmlns="http://www.w3.org/2000/svg" xml:space="preserve" font-family="Calibri" font-size="24.0" fill="#FFFFFF" transform="matrix(1.00, 0.00, -0.00, -1.00, 340.0, 15.0)">1</text>"
        var fontFamily = textElement.getAttribute('font-family') || '';
        fontFamily += ',Helvetica,Aria,"sans-serif';
        textElement.setAttribute('font-family', fontFamily);
        //font-family: Arial, sans-serif
        //textElement.style.fontFamily = fontFamily + ',Aria,sans-serif';
      }
    }
  });

  global.Alo7Delegate = Alo7Delegate;
})(this);
