'use strict';

/**
 * Created by lixuexin on 2017/8/30.
 */
self.importScripts('workbox-sw.prod.v2.0.0.js');

var wb = new self.WorkboxSW({ clientsClaim: false, skipWaiting: false });
wb.precache([]);

var list = [{
  name: 'courseware-runtime-assets-2.5.0',
  matchers: ['https://www.alo7.com/(.*)', 'https://course-assets.alo7.com/(.*)'],
  options: {
    cacheExpiration: {
      maxAgeSeconds: 14 * 24 * 60 * 60
    },
    cacheableResponse: { statuses: [0, 200] }
  },
  strategy: wb.strategies.networkFirst
}, {
  name: 'networkFirst',
  matchers: ['https://www.alo7.com/app/courseware/version.json*'],
  strategy: wb.strategies.networkFirst
}];

self.addEventListener('activate', function (event) {
  var cacheWhitelist = list.map(function (item) {
    return item.name;
  });
  event.waitUntil(caches.keys().then(function (keyList) {
    return Promise.all(keyList.map(function (key) {
      if (cacheWhitelist.indexOf(key) === -1) {
        // console.log('模拟删除', key);
        return caches.delete(key);
      }
    }));
  }));
});

list.forEach(function (item) {
  item.matchers.forEach(function (match) {
    var cfg = Object.assign({ cacheName: item.name }, item.options);
    wb.router.registerRoute(match, wb.strategies.cacheFirst(cfg));
  });
});