// light direction (view space)
float3 lightDir <  string UIDirectional = "Light Direction"; > = { 0.0, -1.0, 0.0 };

// light intensity
float4 I_a = { 0.5f, 0.5f, 0.5f, 0.0f }; // ambient
const uint lightTotal = 32;
float4 LightColor[32];
float2 LightPosition[32];
float LightRange[32];
uint numLights = 0;
float lavaCoords[32];
uint numLavas = 0;

float4 I_s = { 0.2f, 0.2f, 0.2f, 0.2f }; // specular


// material reflectivity
//float4 k_a : MATERIALAMBIENT = { 0.3f, 0.3f, 0.3f, 1.0f };    // ambient
float4 k_a : AMBIENT = { 1.0f, 1.0f, 1.0f, 1.0f }; // ambient
float4 k_d : DIFFUSE = { 1.0f, 1.0f, 1.0f, 1.0f }; // diffuse
float4 k_s : SPECULAR = { 1.0f, 1.0f, 1.0f, 1.0f }; // specular
int n : POWER = 32; // power
float3 PlayerPos = { 0, 0, 0 };
bool doLighting = false;

texture glowTexture;
// texTrans is a transform used to map a 1x1 quad
// to fill the screen.
float4x4 texTrans : Projection;
// pSize is the pixel size of the texture,
// equivalent to the inverse of the texture width.
//float pSize = 1 / 128.0f;
float pSize = 0.01f;
static const float PI = 3.14159265f;
// transformations
float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 Projection : PROJECTION;
float Noise = 0;
//bool PickupGlow = false;
//bool PickupEnergy = false;
//bool PickupBolts = false;
///bool PickupPassive = false;
//bool PickupActive = false;
//float PickupGreen;
bool BlackAndWhiteMode = false;
bool BlackAndWhiteFade = false;
float BlackAndWhitePerc = 0;
//bool drawFire = false;
//bool drawParticle = false;
//float ForceAlphaValue = 0.0f;
//bool ForceAlpha = false;
float2 EnemyFlash = { 0, 0 };
//float EnemyDie = 0.0f;
//bool menuFade = false;
float Time;
float gTime;
bool HUD = false;
//float Fader = -1.0f;
//bool MenuLit = false;
//bool CYCLE = false;
bool FLSHADER = false;
bool SJSHADER = false;
bool ATSHADER = false;
//bool HalveBlue = false;
//bool FlipIntensity = false;
//bool SJTest = false;
//bool ATTest = false;
//bool ATTest2 = false;
bool usePointSampler = false;
//bool PopOut = false;
float FCVSat = 1.0f;

//bool IntensityMod = false;
//float IntensityModValue = 1.0f;
bool SideWipeIn = false;
bool SideWipeOut = false;
float SideWipePerc = 0.;
int SideWipeWidth = 1280;
float HealthBarPerc = 1.0f;
bool HealthBar = false;
//bool EnemyChilled = false;
//float4 Bluezo = {0.0f, 0.0f, 1.0f, 0.0f};
bool fadeToWhite = false;
bool flipFade = false;
//bool stallFade = false;
//bool fullFade = false;
//bool fullFadeAlpha = false;
//float fullFadePerc = 1.0f;
float fadeToPerc = 0.0f;
bool backLight = true;
float4 pickupGlowColor = { 0.0f, 0.0f, 0.0f, 0.0f };
bool doWavy = false;
bool dw2 = false;
bool drawingbg = false;
float wavePer = 1.0f;
float waveAmp = 1.0f;
float waveSpd = 1.0f;
float maxHeight = 1;
float maxWidth = 1;
int screenHeight = 1000;
int screenWidth = 1000;
float4 FCV;
float4x4 ColorShift;
float fadeColor = 1.0f;
float fadeAlpha = 1.0f;
float UIGPerc = 0.0f;
float4 UIGInfo = { 0.0f, 0.0f, 0.0f, 0.0f };
float2 cpos = { 0.0f, 0.0f };

float2 mousePos;

//float bloomRadius;
//float bloomThreshold;
//float bloomSoften;
//float bloomAlpha;

float bloomRadius = 0.005;
float bloomThreshold = 0.27;
float bloomSoften = 2.6;
float bloomAlpha = 0.75;

float vfxElapsedTime;
float vfxDuration;
float vfxRandom;
float vfxBlackout = 1.0f;

float4 recolorColor;
float4 recolorAspect;
float recolorGradientStrength;
float recolorGradientAngle;


struct GLOW_INPUT
{
    float4 pos : POSITION;
    float2 texCoord : TEXCOORD;
};

struct GLOW_OUTPUT
{
    float4 pos : POSITION;
    float2 texCoord0 : TEXCOORD0;
    float2 texCoord1 : TEXCOORD1;
    float2 texCoord2 : TEXCOORD2;
    float2 texCoord3 : TEXCOORD3;
    float2 texCoord4 : TEXCOORD4;
    float2 texCoord5 : TEXCOORD5;
    float2 texCoord6 : TEXCOORD6;
};

struct VS_OUTPUT
{
    float4 Pos : POSITION;
    float4 Diff : COLOR0;
    float4 Spec : COLOR1;
    float2 Tex : TEXCOORD0;
    float3 PosW : TEXCOORD1;
};


float random(float2 p)
{
  // We need irrationals for pseudo randomness.
  // Most (all?) known transcendental numbers will (generally) work.
    const float2 r = float2(
    23.1406926327792690, // e^pi (Gelfond's constant)
     2.6651441426902251); // 2^sqrt(2) (Gelfond?Schneider constant)
    return frac(cos(fmod(123456789., 1e-7 + 256. * dot(p, r))));
 // return 0.0f;
}

float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

float2 unlerp(float min, float max, float2 t)
{
    return float2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

float3 unlerp(float min, float max, float3 t)
{
    return float3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

float4 unlerp(float min, float max, float4 t)
{
    return float4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}

float bias(float b, float x)
{
    return x / ((1 / b - 2) * (1 - x) + 1);
}

float sigmoidBias(float x, float bias)
{
    x *= 2;
    return x < 1 ? (x / ((1 / bias - 2) * (1 - x) + 1)) / 2 : ((x - 1) / ((1 / (1 - bias) - 2) * (1 - (x - 1)) + 1) + 1) / 2;
}

float backOut(float t)
{
    float f = clamp(1.0 - t, 0.000001, 1.0); //Look I don't know why okay
    return 1.0 - (pow(f, 1.5) - f * sin(f * PI));
}

float backInOut(float t)
{
    float f = t < 0.5
		? 2.0 * t
		: 1.0 - (2.0 * t - 1.0);

    float g = pow(f, 1.5) - f * sin(f * PI);

    return t < 0.5
		? 0.5 * g
		: 0.5 * (1.0 - g) + 0.5;
}

VS_OUTPUT VS(
    float3 Pos : POSITION,
    float3 Norm : NORMAL,
    float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;

    float4x4 WorldView = mul(World, View);

    float3 P = mul(float4(Pos, 1), (float4x3) WorldView); // position (view space)
    Out.PosW = mul(Pos, World);
    Out.Pos = mul(float4(P, 1), Projection); // position (projected)
	
    if (doWavy && maxHeight > 0)
    {
        Out.Pos[1] += (((cos((gTime / 1000 + Pos[0] / 2) / wavePer) + 1.0f) * waveAmp) * Pos[1] / maxHeight);
        if (dw2)
            Tex[0] += fmod(gTime, 20000.0f / waveSpd) / (20000.0f / waveSpd);
    }

	//fade = 0.5f;
    Out.Diff = float4(fadeColor, fadeColor, fadeColor, fadeAlpha);
		
    Out.Tex = Tex;
    Out.Spec[0] = 1.0f - Norm[0];
	
    return Out;
}

VS_OUTPUT VSUIGlow(
    float3 Pos : POSITION,
    float3 Norm : NORMAL,
    float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;

    float4x4 WorldView = mul(World, View);
	
    Pos[0] += UIGInfo[2] * UIGPerc * sign(Pos[0] - UIGInfo[0]) * screenHeight / 1080.0f;
    Pos[1] += UIGInfo[3] * UIGPerc * sign(Pos[1] - UIGInfo[1]) * screenHeight / 1080.0f;

    float3 P = mul(float4(Pos, 1), (float4x3) WorldView); // position (view space)
	
    Out.Pos = mul(float4(P, 1), Projection); // position (projected)
    Out.Diff = float4(fadeColor, fadeColor, fadeColor, fadeAlpha);
		
    Out.Tex = Tex;
    Out.Spec[0] = 1.0f - Norm[0];
	
	
    return Out;
}

GLOW_OUTPUT BlurAttemptVSH(GLOW_INPUT IN)
{
    GLOW_OUTPUT OUT;

    float3 L = -lightDir;

    float4x4 WorldView = mul(World, View);

    float4 newp = mul(IN.pos, 2.0f);
	//newp[1] += 2.0f;
	
    float3 P = mul(IN.pos, (float4x3) WorldView); // position (view space)

    OUT.pos = mul(float4(P, 1), Projection);
	//OUT.pos = mul(OUT.pos, 110.5f);// position (projected)

    OUT.texCoord0 = IN.texCoord + float2(-pSize * 3, 0);
    OUT.texCoord1 = IN.texCoord + float2(-pSize * 2, 0);
    OUT.texCoord2 = IN.texCoord + float2(-pSize * 1, 0);
    OUT.texCoord3 = IN.texCoord + float2(0, 0);
    OUT.texCoord4 = IN.texCoord + float2(pSize * 1, 0);
    OUT.texCoord5 = IN.texCoord + float2(pSize * 2, 0);
    OUT.texCoord6 = IN.texCoord + float2(pSize * 3, 0);
    return OUT;
}

GLOW_OUTPUT BlurAttemptVSV(GLOW_INPUT IN)
{
    GLOW_OUTPUT OUT;

    float3 L = -lightDir;

    float4x4 WorldView = mul(World, View);

	//float4 newp = mul(IN.pos, 2.0f);
	//newp[1] += 2.0f;
	
    float3 P = mul(IN.pos, (float4x3) WorldView); // position (view space)

    OUT.pos = mul(float4(P, 1), Projection);
	//OUT.pos = mul(OUT.pos, 110.5f);// position (projected)

    OUT.texCoord0 = IN.texCoord + float2(0, -pSize * 3);
    OUT.texCoord1 = IN.texCoord + float2(0, -pSize * 2);
    OUT.texCoord2 = IN.texCoord + float2(0, -pSize * 1);
    OUT.texCoord3 = IN.texCoord + float2(0, 0);
    OUT.texCoord4 = IN.texCoord + float2(0, pSize * 1);
    OUT.texCoord5 = IN.texCoord + float2(0, pSize * 2);
    OUT.texCoord6 = IN.texCoord + float2(0, pSize * 3);
    return OUT;
}

Texture2D g_txY : register(t0);
//Texture2D g_txU : register(t1);
//Texture2D g_txV : register(t2);

sampler Sampler = sampler_state
{
	//texture = NULL;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler Sampler2 = sampler_state
{
	//texture = NULL;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler Sampler3 = sampler_state
{
	//texture = NULL;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler SamplerP = sampler_state
{
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
};

sampler SamplerClamp = sampler_state
{
	//texture = NULL;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture noiseTexture;
sampler noiseSampler = sampler_state
{
    Texture = noiseTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};

texture sceneTexture;
sampler sceneSampler = sampler_state
{
    Texture = sceneTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture blurTexture;
sampler blurSampler = sampler_state
{
    Texture = blurTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture distortTexture;
sampler distortSampler = sampler_state
{
    Texture = distortTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture recolorTexture;
sampler recolorSampler = sampler_state
{
    Texture = recolorTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture lumpTexture;
sampler lumpSampler = sampler_state
{
    Texture = lumpTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};
sampler lumpColorSampler = sampler_state
{
    Texture = lumpTexture;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

BlendState AlphaBlendingOn
{
    BlendEnable[0] = TRUE;
    SrcBlend = SRC_ALPHA;
    DestBlend = INV_SRC_ALPHA;
    BlendOp = ADD;
    SrcBlendAlpha = ONE;
    DestBlendAlpha = ONE;
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

float4 FCVD(float4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
	
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1 - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0;
    l = 1 - l;
	
    float3 c2 = float3((FCV[3]) * l * float3(FCV[0], FCV[1], FCV[2]) + (1 - FCV[3]) * float3(cin[0], cin[1], cin[2]));
    return float4(c2[0], c2[1], c2[2], cin[3]);
}

float4 CSD(float4 cin)
{
	//return float4(0,0,0,0);
    return mul(cin, ColorShift);
}

float4 EFD(float4 cin)
{
//	color[1] = EnemyFlash[1] * (1.0f - EnemyFlash[0]) + (1-EnemyFlash[1]) * color[1];
	//color[2] = EnemyFlash[1] * (1.0f - EnemyFlash[0]) + (1-EnemyFlash[1]) * color[2];
	//color[1] = 1.0f - EnemyFlash[0];
	//color[2] = 1.0f - EnemyFlash[0];
    return float4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}

//does everything
float4 PSFTW(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color;
	
    color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
    color = FCVD(color);

	//color = mul(color, ColorShift);
	
	//float l = (color[0] + color[1] + color[2]) / 3.0f;
	//float3 c2 = float3((FCV[3]) * l * float3(FCV[0], FCV[1], FCV[2]) + (1-FCV[3]) * float3(color[0], color[1], color[2]));
	//color = float4(c2[0], c2[1], c2[2], color[3]);
	
	
	//color = EFD(color);
	//color[1] = EnemyFlash[1] * (1.0f - EnemyFlash[0]) + (1-EnemyFlash[1]) * color[1];
	//color[2] = EnemyFlash[1] * (1.0f - EnemyFlash[0]) + (1-EnemyFlash[1]) * color[2];
	
    if (HealthBar)
    {
        if (input.Tex[1] > HealthBarPerc)
        {
            color[3] = 0;
        }
    }
	
	//used to include FTW
    if (!doWavy)
    {
        if (flipFade)
        {
            color[0] = color[0] * (1 - fadeToPerc);
            color[1] = color[1] * (1 - fadeToPerc);
            color[2] = color[2] * (1 - fadeToPerc);
        }
        else
        {
            color[0] = color[0] * (1 - fadeToPerc) + fadeToPerc;
            color[1] = color[1] * (1 - fadeToPerc) + fadeToPerc;
            color[2] = color[2] * (1 - fadeToPerc) + fadeToPerc;
        }
    }
	
    return color;
}
//does only basic draw
float4 PSYUV(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    const float3 offset = { -0.0627451017, -0.501960814, -0.501960814 };
    const float3 Rcoeff = { 1.164, 0.000, 1.596 };
    const float3 Gcoeff = { 1.164, -0.391, -0.813 };
    const float3 Bcoeff = { 1.164, 2.018, 0.000 };

    float3 yuv;
	//yuv.x = g_txY.Sample(Sampler, input.Tex).r;
	//yuv.y = g_txY.Sample(Sampler, input.Tex).r;
	//yuv.z = g_txY.Sample(Sampler, input.Tex).r;
	
    yuv.x = tex2D(Sampler, input.Tex).a;
    yuv.y = tex2D(Sampler2, input.Tex).a;
    yuv.z = tex2D(Sampler3, input.Tex).a;
	
    yuv += offset;
	
    float4 color;
    color.b = dot(yuv, Rcoeff);
    color.g = dot(yuv, Gcoeff);
    color.r = dot(yuv, Bcoeff);
    color.a = 1.0f;
	
	//float4 color = tex2D(Sampler, input.Tex);
	
	//* input.Diff;
//	color[3] = min(color[3], input.Spec[0]);
	
    return color;
}
float4 PS(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
	float4 tcolor = tex2D(Sampler, input.Tex);
	
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
	
    color[3] = min(color[3], input.Spec[0]);

    return color;
}
float4 PSEF(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = EFD(color);
	
    return color;
}

//does FCV draw
float4 PSFCV(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
	//return float4(0,0,0,0);
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = FCVD(color);
	
	//float l = ( color[0] +color[1] +  color[2]) / 3.0f;
	//float3 c2 = float3((FCV[3]) * l * float3(FCV[0], FCV[1], FCV[2]) + (1-FCV[3]) * float3( color[0],  color[1],color[2]));
	//color =  float4(c2[0], c2[1], c2[2],  color[3]);
	
    return color;
}
float4 PSFCVEF(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
	//return float4(0,0,0,0);
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = FCVD(color);
    color = EFD(color);
    return color;
}

float4 PSCS(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
	
    return color;
}

float4 PSCS2(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
	
    return color;
}

float4 PSCSEF(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
    color = EFD(color);
	
    return color;
}

float4 PSHB(
		VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    if (input.Tex[1] > HealthBarPerc)
    {
        color[3] = 0;
    }
	
    return color;
}

float4 glowPS(GLOW_OUTPUT IN) : COLOR
{
    float4 color = tex2D(Sampler, IN.texCoord0) * 0.25;
    color += tex2D(Sampler, IN.texCoord1) * 0.1;
    color += tex2D(Sampler, IN.texCoord2) * 0.2;
    color += tex2D(Sampler, IN.texCoord3) * 0.3;
    color += tex2D(Sampler, IN.texCoord4) * 0.2;
    color += tex2D(Sampler, IN.texCoord5) * 0.1;
    color += tex2D(Sampler, IN.texCoord6) * 0.25;
	
    color[1] = 1.0f; //color[0] / 3.0f + color[1] / 3.0f + color[2] / 3.0f;
    color[0] = 0.0f;
    color[2] = 0.0f;
	
	//color.a = 1.0f;
	
    return float4(pickupGlowColor[0], pickupGlowColor[1], pickupGlowColor[2], color[3]);
}

float4 glowPSH(VS_OUTPUT IN) : COLOR
{
    float2 Tex = IN.Tex;
    float blur = 0.05f;

    float4 sum = float4(0.0, 0.0, 0.0, 0.0);
    sum += tex2D(Sampler, float2(Tex.x - 4.0 * blur, Tex.y)) * 0.05;
    sum += tex2D(Sampler, float2(Tex.x - 3.0 * blur, Tex.y)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x - 2.0 * blur, Tex.y)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x - blur, Tex.y)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y)) * 0.16;
    sum += tex2D(Sampler, float2(Tex.x + blur, Tex.y)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x + 2.0 * blur, Tex.y)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x + 3.0 * blur, Tex.y)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x + 4.0 * blur, Tex.y)) * 0.05;

    return sum;
}

float4 glowPSV(VS_OUTPUT IN) : COLOR
{
    float2 Tex = IN.Tex;
    float blur = 0.05f;
    float opacity = 0.5f;

    float4 sum = float4(0.0, 0.0, 0.0, 0.0);
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - 4.0 * blur)) * 0.05;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - 3.0 * blur)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - 2.0 * blur)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - blur)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y)) * 0.16;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + blur)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + 2.0 * blur)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + 3.0 * blur)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + 4.0 * blur)) * 0.05;

    float4 result = sum * opacity;
    float3 glowColor = float3(pickupGlowColor[0], pickupGlowColor[1], pickupGlowColor[2]);
    result.rgb = float3(glowColor.r, glowColor.g, glowColor.b) / 255.0f;
//secondforeground??

    float4 src = tex2D(Sampler, IN.Tex.xy);
    return result * (1 - src.a) + src;
}

float4 getCursor(float2 uv)
{
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);
    float dist = length((uv - mousePos) * aspect);
    float result = 1 - step(0.002, abs(dist - 0.01));
    return float4(result, result, result, result);
};

float4 additiveBloom(float4 baseImage, float4 blurImage)
{
	//bloomAlpha = mousePos.x;
    return baseImage + 0.5f * blurImage * bloomAlpha;
}

float4 maxBloom(float4 baseImage, float4 blurImage)
{
    return max(baseImage, blurImage);
}

float4 compositePS(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);

    float4 baseImage = tex2D(sceneSampler, uv);
    float4 blurImage = tex2Dlod(blurSampler, float4(uv, 0, bloomSoften));
	
	//return baseImage;
	//return maxBloom(baseImage, blurImage);
    return additiveBloom(baseImage, blurImage);
}

float4 bloomSample(sampler samplerState, float2 uv, float2 direction, float radius, float threshPower)
{
    float2 aspect = float2(1.0, float(screenWidth) / float(screenHeight));
    float4 sum = float4(0, 0, 0, 0);
    sum += pow(tex2D(samplerState, uv + (direction * radius * -4.0f) * aspect), threshPower) * 0.0162162f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * -3.0f) * aspect), threshPower) * 0.0540541f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * -2.0f) * aspect), threshPower) * 0.121622f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * -1.0f) * aspect), threshPower) * 0.194595f;
    sum += pow(tex2D(samplerState, uv), threshPower) * 0.227027f;
    sum += pow(tex2D(samplerState, uv + (direction * radius) * aspect), threshPower) * 0.194595f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * 2.0f) * aspect), threshPower) * 0.121622f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * 3.0f) * aspect), threshPower) * 0.0540541f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * 4.0f) * aspect), threshPower) * 0.016216f;
    return sum;
}

float4 postProcessBloomPass1(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);

	//bloomThreshold = mousePos.y;
    float thresh = lerp(1, 5, bloomThreshold);
    return bloomSample(blurSampler, uv, normalize(float2(1, 1)), bloomRadius, thresh);
}

float4 postProcessBloomPass2(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);

    return bloomSample(blurSampler, uv, normalize(float2(1, -1)), bloomRadius, 1);
}

float4 distort(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float maxDistortion = 0.05;
	//maxDistortion = mousePos.x;
    float4 offsetSample = tex2D(distortSampler, uv);
	//return offsetSample;
    offsetSample.y = 1.0 - offsetSample.y;
    float2 offsets = (offsetSample.xy * 2.0 - 1.0) * maxDistortion / aspect;
    return tex2D(sceneSampler, uv + offsets);
}

float4 distortShockwave(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 center = float2(0.5, 0.5);
    float2 loc = IN.Tex.xy - center;
    float2 direction = normalize(loc);
    float radius = length(loc);
    float magnitude;

    float edgeSoften = 0.01;
    float outerEdge = 0.5 - edgeSoften;
    float innerEdge = 0.392;

    magnitude = unlerp(innerEdge, outerEdge, radius);
    magnitude = bias(0.1, magnitude);
    magnitude = lerp(magnitude, 0, smoothstep(outerEdge, outerEdge + edgeSoften, radius));

    float2 result = unlerp(-1.0, 1.0, direction);
    return float4(result, 1.0, magnitude);
}

float4 distortRipple(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 center = float2(0.5, 0.5);
    float2 loc = IN.Tex.xy - center;
    float2 direction = normalize(loc);
	
    float radius = length(loc);
	float rr = 2.0;
	direction = (max((rr - (radius-0.2) * 5) / rr, 0)) * direction;
	//direction = 0.2 * direction;
	direction.y = 0;
    float magnitude;

    float edgeSoften = 0.01;
    float outerEdge = 0.5 - edgeSoften;
    float innerEdge = 0.392;

    magnitude = unlerp(innerEdge, outerEdge, radius);
    magnitude = bias(0.1, magnitude);
    magnitude = lerp(magnitude, 0, smoothstep(outerEdge, outerEdge + edgeSoften, radius));

    float2 result = unlerp(-1.0, 1.0, direction);
    return float4(result, 1.0, magnitude);
}

float4 distortLava(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float noiseScale = 0.1;
    float modSpeed = 0.0005;
    float slideSpeed = 0.0001;
    float squish = 2;
    float maskScale = 0.6;
    float strength = 0.04;

    float2 uv = IN.PosW.xy * noiseScale;
    uv.y *= squish;
    uv.y -= slideSpeed * Time;
    float noise = tex2D(noiseSampler, uv).r;
	
    noise = sin(PI * 2.0 * fmod(noise + Time * modSpeed, 1.0));

    float2 direction = normalize(float2(sin(PI * 2.0 * noise), cos(PI * 2.0 * noise)));

    float magnitude = pow(tex2D(noiseSampler, uv * maskScale).r, 2);

    float topFade = 0.4;
    float bottomFade = 0.2;
    float sideFade = 0.05;
    magnitude *= smoothstep(1.0, 1.0 - topFade, IN.Tex.y);
    magnitude *= smoothstep(0, bottomFade, IN.Tex.y);
    magnitude *= smoothstep(0, sideFade, IN.Tex.x);
    magnitude *= smoothstep(1.0, 1.0 - sideFade, IN.Tex.x);
    magnitude *= strength;

    direction = unlerp(-1.0, 1.0, direction);
    return float4(direction, 1.0, magnitude);
}

float4 debugColorFill(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    return float4(IN.Tex.x, IN.Tex.y, 1, 1);
}

float4 blast(float2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0) * speed - timeOffset;
    float timeStomp = step(0, time);
    float noiseAmount = clamp(lerp(0.4, 0.16, time - 0.1), 0.0, 1.0);
    float threshold = clamp(lerp(1.0, 0.0, time - 0.1), 0.0, 1.0);

    uv -= 0.5;
    uv /= scale;
    uv += 0.5;
    float2 baseUv = uv;
    float minZoom = 1.0;
    float maxZoom = 2.0;
    float zoom = 1 / lerp(minZoom, maxZoom, time);
    uv -= 0.5;
    uv *= zoom;
    uv += 0.5;

    float noise = tex2D(lumpSampler, uv + rand).a;
    float noise2 = tex2D(lumpSampler, (uv - rand) * 0.6).a;

    float baseRadius = 0.3;
    float bout = abs(backOut(bias(unlerp(0.0, 0.6, time), 0.75)));
    float radius = lerp(0.0, 1.0, bout) * baseRadius;
    radius += noise2 * lerp(0.15, 0.07, threshold) * timeStomp;
    float arm = unlerp(0.0, radius, length(baseUv - 0.5));
    float power = sqrt(1.0 - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0 - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0;

    power = unlerp(0.0, threshold, power);

    float colorPicker = bias(power, noise) - (1.0 - threshold) + power * 0.16;
    float3 color = tex2D(lumpColorSampler, float2(colorPicker, 0.5)).rgb;
	
    float alpha = 1.0 - step(power, 0.0);
    float4 final = float4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

float4 smoke(float2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0) * speed - timeOffset;
    float noiseAmount = clamp(lerp(0.4, 0.16, time - 0.1), 0.0, 1.0);
    float threshold = saturate(lerp(0, 1, time - 0.1));

    float baseRadius = 0.3;
    float bout = abs(backOut(bias(unlerp(0.0, 0.6, time), 0.75)));
    float radius = lerp(0.0, 1.0, bout) * baseRadius;

    uv -= 0.5;
    uv /= scale;
    uv += 0.5;
    float2 baseUv = uv;
    float minZoom = 1.0;
    float maxZoom = 1.9;
    float zoom = 1 / lerp(minZoom, maxZoom, time);
    uv -= 0.5;
    uv *= zoom;
    uv += 0.5;

    float slide = time * -0.5;
    uv.y += slide;

    float noise = tex2D(lumpSampler, uv + rand).a;
    float noise2 = tex2D(lumpSampler, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1 - threshold) * 0.25;
    float3 color = tex2D(lumpColorSampler, float2(colorPicker, 0.5)).rgb * 0.75;

    float growthTime = 0.1;
    float edgeRaggedness = 0.2;
    float expansion = smoothstep(growthTime, 0, time) / 2;
    float falloff = 1 - ((length(baseUv - 0.5) + (1 - noise2) * edgeRaggedness) + expansion) * 2;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2);

    float4 final = float4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

float4 spark(float2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0) * speed - timeOffset;
    float timeStomp = step(0, time);
    float burstPower = time * 0.1;
    
    uv -= 0.5;
    uv /= scale;
    uv += 0.5;
    float2 epicenter = uv - 0.5;
    float r = length(epicenter);
    float2 burstUv = epicenter * 1.0 / pow(r, lerp(1.06, 2.0, burstPower)) / lerp(0.715, 0.57, bias(0.6, time));

    float threshold = lerp(0.682, 1.2, bias(0.755, time));
    float4 noise = tex2D(lumpSampler, burstUv - rand).a;
    float limit = 1.0 - (smoothstep(1.8, 0.531, r * 2)) - 0.066 * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    float3 color = tex2D(lumpColorSampler, float2(lerp(1, 0.5, time), 0.5));
    color.rgb *= vfxBlackout;
    return float4(color, alpha);
}

float4 comp(float4 src, float4 dst)
{
    return lerp(src, dst, 1.0 - src.a);
}

float4 explosion(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex.xy;
    float rand = random(float2(vfxRandom, 0));
    float4 blaast = blast(uv, 0.66, vfxElapsedTime, rand, 0.21, 2.0);
    float4 smooke = smoke(uv, 0.66, vfxElapsedTime, rand, 0, 0.7);
    float4 spaark = spark(uv, 1, vfxElapsedTime, rand, 0.08125, 0.9);
    float4 final = comp(spaark, comp(blaast, smooke));
    final.rgb *= vfxBlackout;
    return final;
}

float4 blastPass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float rand = random(float2(vfxRandom, 0));
    return blast(IN.Tex.xy, 0.66, vfxElapsedTime, rand, 0.21, 2.0);
}

float4 smokePass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float rand = random(float2(vfxRandom, 0));
    return smoke(IN.Tex.xy, 0.66, vfxElapsedTime, rand, 0.0, 0.7);
}

float4 sparkPass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float rand = random(float2(vfxRandom, 0));
    return spark(IN.Tex.xy, 1, vfxElapsedTime, rand, 0.0, 0.9);
}

float3 zapLine(float2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323;
    const float scale = 0.5354330708661418;
    const float texSpeed = 1.0;
    const float sinSpeed = 0.1968503937007874;
    const float taper = 0.28346456692913385;
    const float timeScale = 1.0;
    const float bloomPower = 0.007874015748031496;

    float fatness = 0.023622047244094488;
    float maxOffset = 0.48031496062992124;
    float bloomRadius = 0.25196850393700787;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961, strength);


    float3 final = float3(0, 0, 0);
    float time = Time * timeScale;

    float2 texUv = uv;
    float2x2 rot = float2x2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5;
    texUv = mul(rot, texUv);
    texUv += 0.5;

    texUv.y += rand;
    texUv.x += time * 0.001 * texSpeed;
    texUv *= 1 / lerp(1, 3, scale);

    uv -= 0.5;
    uv = mul(rot, uv);
    uv += 0.5;

    float bwoopShrink = smoothstep(0.4094488, 0, strength);
    float bwoop = saturate(bias(taper, 1 - lerp(0, 1, abs(uv.y - 0.5) * 2 + bwoopShrink)));

    float lumps = tex2D(lumpSampler, texUv).a;
    float sinOff = (time * 0.001 * sinSpeed) + rand;
    float shift = (lumps - 0.5) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100) * bwoop;
    float width = bwoop * fatness;
    float power = 1 - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5 + shift)));
    power = bias(bloomPower, power);
    final.rgb = power;
    return final;
}

float3 zapRing(float2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826;
    float endRadius = startRadius + 0.27559055;
    
    float bloomRadius = lerp(0.71653543, 0, bias(0.13385826, age));
    float innerRadius = lerp(0, endRadius, bias(0.25196850, age));
    float outerRadius = lerp(startRadius, endRadius, bias(0.18110236, age));
    
    float bloomPower = 0.007874015748031496 * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5));
    float outer = 1 - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5));
    float power = bias(bloomPower, inner * outer);

    float3 final = float3(0, 0, 0);
    final.rgb = power;
    return final;
}

float4 zap(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float time = vfxElapsedTime / 1000.0;
    float lifetime = 0.22834645f;
    float progress = unlerp(0, lifetime, time);
    float strength = 1 - (progress % (0.5)) * 2;
    strength = time > lifetime ? 0 : strength;
    strength = bias(0.7244094488188977, strength);

    float angle = 0.97637795 * (PI * 2 * vfxRandom) + step(0.5, progress) * PI / 4;

    float4 col = float4(0, 0, 0, 1);
    col.rgb += zapLine(IN.Tex.xy, angle, strength, random(float2(0, 0)));
    col.rgb += zapLine(IN.Tex.xy, angle + PI / 2, strength, random(float2(0, 1)));
    col.rgb += zapRing(IN.Tex.xy, progress, 1);
    col.rgb = saturate(col.rgb);

    float3 white = float3(1, 1, 1);
    float3 black = float3(0, 0, 0);
    float3 blue = float3(0.1, 0.5, 1);
    col.a = bias(0.3543307, col.r);
    col.rgb = lerp(lerp(black, blue, unlerp(0, 0.5, col.r)), lerp(blue, white, unlerp(0.5, 1, col.r)), step(0.5, col.r));
    col.rgb *= vfxBlackout;
    return col;
}

float4 zapLinePass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float time = vfxElapsedTime / 1000.0;
    float lifetime = 0.22834645f;
    float progress = unlerp(0, lifetime, time);
    float strength = 1 - progress;
    strength = time > lifetime ? 0 : strength;
    strength = bias(0.7244094488188977, strength);

    float rand = random(float2(vfxRandom, 0));

    float4 col = float4(0, 0, 0, 1);
    col.rgb = saturate(zapLine(IN.Tex.xy, PI/2.0, strength, rand));

    float3 white = float3(1, 1, 1);
    float3 black = float3(0, 0, 0);
    float3 blue = float3(0.1, 0.5, 1);
    col.a = bias(0.3543307, col.r);
    col.rgb = lerp(lerp(black, blue, unlerp(0, 0.5, col.r)), lerp(blue, white, unlerp(0.5, 1, col.r)), step(0.5, col.r));
    col.rgb *= vfxBlackout;
    return col;
}

float4 simpleRingPass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float time = vfxElapsedTime / 1000.0;
    float lifetime = 0.22834645f;
    float progress = unlerp(0, lifetime, time);
    float4 col = float4(0, 0, 0, 1);
    col.rgb = zapRing(IN.Tex.xy, progress, 0.0001);
    col.a = length(col.rgb);
    col.rgb *= vfxBlackout;
    return col;
}

float4 distortCharge(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    const float uvScale         = 0.283464566f;
    const float uvInversionBias = 0.629921258f;
    const float ringSoften      = 0.039370075f;
    const float ringAnimBias    = 0.29921259f;
    const float ringRadiusScale = 0.57480314f;
    const float ringFadeIn      = 0.05511811f;

    float2 center = float2(0.5, 0.5);
    float2 loc = IN.Tex.xy - center;
    float2 direction = normalize(loc);

    float radius = length(loc);
    float angle = Time / 1000.0;
    float2 texUvA = IN.Tex.xy;
    float2 texUvB = IN.Tex.xy;
    float2x2 rot = float2x2(cos(angle), -sin(angle), sin(angle), cos(angle));
    texUvA -= 0.5;
    texUvB -= 0.5;
    texUvA /= uvScale * 5;
    texUvB /= uvScale * 7;
    texUvA = mul(rot, texUvA);
    texUvB = mul(texUvB, rot);
    texUvA += 0.5;
    texUvB += 0.5;

    float stellate = pow(radius, uvInversionBias);
    texUvA = texUvA / stellate;
    texUvB = texUvB / stellate;
    float4 texA = tex2D(lumpSampler, texUvA);
    float4 texB = tex2D(lumpSampler, texUvB);

    float magnitude;
    direction *= lerp(-1.0, 1.0, texA.a * texB.a);

    float ringAnimProgress = (vfxElapsedTime / vfxDuration) % 1.0;
    float ringAnim = bias(ringAnimBias, 1.0 - ringAnimProgress);
    float ringRadius = lerp(0, 0.5 - ringSoften, ringAnim) * ringRadiusScale;
    float fadeIn = smoothstep(0, ringFadeIn, ringAnimProgress);

    magnitude = smoothstep(ringSoften, 0, length(radius - ringRadius));

    magnitude *= ringAnim * fadeIn;

    float2 result = unlerp(-1.0, 1.0, direction);

    return float4(result, 1.0, magnitude);
}

float4 recolorCircle(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 center = float2(0.5, 0.5);
    float arm = length(IN.Tex.xy - center) * 2;
    float alpha = saturate(recolorColor.a * smoothstep(1, 0, arm));
    return float4(recolorColor.rgb * alpha, alpha);
}

float udRoundBox(float2 p, float2 b, float r)
{
    return length(max(abs(p) - b + r, 0.0)) - r;
}

float4 recolorRectangle(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    const float radius = 0.34645669f;
    const float sharpness = 0.0f;
    
    float2 uv = IN.Tex.xy;
    float2 center = float2(0.5, 0.5);
    
    uv *= recolorAspect.xy;
    center *= recolorAspect.xy;
    
    float b = udRoundBox(uv.xy - center, center, radius);
    float val = smoothstep(0.0, radius, -b);

    float2x2 rot = float2x2(cos(recolorGradientAngle), -sin(recolorGradientAngle), sin(recolorGradientAngle), cos(recolorGradientAngle));
    float2 spunUv = IN.Tex.xy;
    spunUv -= 0.5;
    spunUv = mul(rot, spunUv);
    spunUv += 0.5;
    //val = lerp(val, val*smoothstep(0.0, 0.75, spunUv.x), recolorGradientStrength);
    val *= smoothstep(0.0, 1.0, spunUv.x + (1.0 - recolorGradientStrength));
    float alpha = saturate(recolorColor.a * val);
    return float4(recolorColor.rgb * alpha, alpha);
}

float4 navy(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    return float4(0.085, 0.155, 0.225, 1.0);
}






///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

float4 recolorMix(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorDarken(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = min(under, over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorMultiply(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under * over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorColorBurn(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = 1.0 - (1.0 - under) / over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLinearBurn(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under + over - 1.0;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLighten(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = max(under, over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorScreen(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = 1.0 - (1.0 - under) * (1.0 - over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorColorDodge(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under / (1.0 - over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLinearDodge(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under + over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorOverlay(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (under > 0.5) ? (1.0 - (1.0 - 2.0 * (under - 0.5)) * (1.0 - over)) : ((2.0 * under) * over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorSoftLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (1.0 - (1.0 - under) * (1.0 - (over - 0.5))) : (under * (over + 0.5));
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorHardLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (1.0 - (1.0 - under) * (1.0 - 2.0 * (over - 0.5))) : (under * (2.0 * over));
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorVividLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (1.0 - (1.0 - under) / (2.0 * (over - 0.5))) : (under / (1.0 - 2.0 * over));
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLinearLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (under + 2.0 * (over - 0.5)) : (under + 2.0 * over - 1.0);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorPinLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (max(under, 2.0 * (over - 0.5))) : min(under, 2.0 * over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorDifference(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = abs(under - over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorExclusion(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = 0.5 - 2.0 * (under - 0.5) * (over - 0.5);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////





float4 postRenderPS(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 Tex = IN.Tex;
    float blur = 0.01f;

    float2 texSpot = Tex;
    const float dist = 0.13f;
	
	//if (false)
	//{
		//float tyt = texSpot.y - fmod(texSpot.y + Time/(100.0f/dist), dist);
	
//		const float dt = texSpot.y - tyt;
	
	//	if (dt <= dist/2.0f)
	//		texSpot.y = (dt/(dist/2.0f)) * texSpot.y + (1.0f - (dt/(dist/2.0f))) * tyt;
	//	else
	//		texSpot.y = (1.0f-((dt-(dist/2.0f))/(dist/2.0f))) * texSpot.y + ((dt-(dist/2.0f))/(dist/2.0f)) * (tyt+dist);
//	
//		texSpot.y += sin(ss[1]/300.0f)/1000.0f;
//	
//		if (texSpot.y > 1.0f) texSpot.y = 1.0f;
//		if (texSpot.y < 0) texSpot.y = 0;
//}
	
	//if (true)
//	{
	//	for (unsigned int i = 0; i < numLavas; i++)
	//	{
	//		if (ss[0] > lavaCoords[i*4] && ss[0] < lavaCoords[i*4+2] && ss[1] > lavaCoords[i*4+1] && ss[1] < lavaCoords[i*4+3])
		//	{	
				//float tyt = texSpot.y - fmod(texSpot.y + Time/40000.0f, dist);
				//float newSpot = texSpot.y;
				//const float dt = texSpot.y - tyt;
				
				//float ssScaled = ss[1] / 1080.;
				//float tyt = ssScaled - fmod(ssScaled + fmod(lavaCoords[i*4+1],dist) + Time/80000.0f, dist);
				//float newSpot = ssScaled;
				//const float dt = ssScaled - tyt;
	
				//if (dt <= dist/2.0f)
				//	newSpot = (dt/(dist/2.0f)) * ssScaled + (1.0f - (dt/(dist/2.0f))) * tyt;
				//else
				//	newSpot = (1.0f-((dt-(dist/2.0f))/(dist/2.0f))) * ssScaled + ((dt-(dist/2.0f))/(dist/2.0f)) * (tyt+dist);
	
				//newSpot += sin(ss[1]/300.0f)/1000.0f;
				
		//		float preMod = (ss[1] - lavaCoords[i*4+1])/screenHeight;
		//		float mod = preMod - fmod(preMod , dist);
				
		//		float newSpot = 0;				
		//		const float dt = preMod - mod;
				
		//		const float bp = dist/2.0f;
		//		if (dt <= bp)
		//			newSpot = (dt/bp) * preMod + (1.0f - (dt/bp)) * mod;
		//		else
		//			newSpot = (1.0f-((dt-bp)/bp)) * preMod + ((dt-bp)/bp) * (mod+dist);
				
		//		float contrib = 1.0f;
		//		float xd = abs(lavaCoords[i*4+2] - lavaCoords[i*4])/2.0f;
		//		float xc = (lavaCoords[i*4+2] + lavaCoords[i*4]) / 2.0f;
		//		if (xd != 0)
		//			contrib = min(contrib, 1.0f - (abs(ss[0]-xc)/xd));
				
		//		xd = abs(lavaCoords[i*4+3] - lavaCoords[i*4+1])/2.0f;
		//		xc = (lavaCoords[i*4+3] + lavaCoords[i*4+1]) / 2.0f;
		//		if (xd != 0)
		//			contrib = min(contrib, 1.0f - (abs(ss[1]-xc)/xd));
				
		//		float changeDiff = newSpot - preMod;
		//		texSpot.y = contrib * (newSpot + (lavaCoords[i*4+1] / screenHeight)) + (1.0f - contrib) * texSpot.y;
	
		//		if (texSpot.y > 1.0f) texSpot.y = 1.0;
		//		if (texSpot.y < 0) texSpot.y = 0;
		//	}
		//}
	//} //else
    texSpot.y = (ss[1] + 0.5f) / screenHeight;
    texSpot.x = (ss[0] + 0.5f) / screenWidth;
    float2 normTex = texSpot;
//	for (unsigned int i = 0; i < numLavas; i++)
//	{
//		if (ss[0] > lavaCoords[i*4] && ss[0] < lavaCoords[i*4+2] && ss[1] > lavaCoords[i*4+1] && ss[1] < lavaCoords[i*4+3])
//		{	
//			float cx = (lavaCoords[i*4] + lavaCoords[i*4+2]) * 0.5f;
//			float cxm = abs(ss[0]-cx) * 2.0f / (lavaCoords[i*4+2] - lavaCoords[i*4] + 1);
//			
//			float cy = (lavaCoords[i*4+1] + lavaCoords[i*4+3]) * 0.5f;
//			float cym = abs(ss[1]-cy) * 2.0f / (lavaCoords[i*4+3] - lavaCoords[i*4+1] + 1);
//			
//			normTex.x += (Time * 0.0001f);
//			float2 jam = normalize(2 *tex2D(SamplerD, 0.5f * normTex) - 1) ;
//		
//			float cnt = (1.0f - cxm) * (1.0f - cym);
//			texSpot.y += jam[1] / screenHeight * 10.0f * cnt;
//			texSpot.x += jam[0] / screenWidth * 20.0f * cnt;
//		}
//	}
	
	//float2 jam = tex2D(SamplerD, texSpot);
	//texSpot.y += jam[1] * 0.05f * cos(Time * 0.001f);
	
	//if (texSpot.y > 1.0f) texSpot.y = 1.0f;
	//if (texSpot.y < 0) texSpot.y = 0.0f;
	//if (texSpot.x > 1.0f) texSpot.x = 1.0f;
	//if (texSpot.x < 0) texSpot.x = 0.0f;
	
    float4 sum = tex2D(SamplerP, texSpot);
	//sum += (tex2D(Sampler, texSpot)) * (1.0f - cpos[0]);
	//sum += (tex2D(Sampler3, texSpot)) * 0.005f;
		
    if (FLSHADER && false)
    {
        for (int i = 0; i < numLavas; i++)
        {
            if (ss[0] > lavaCoords[i * 4] && ss[0] < lavaCoords[i * 4 + 2] && ss[1] > lavaCoords[i * 4 + 1] && ss[1] < lavaCoords[i * 4 + 3])
            {
                float4 c = (0, 0, 0, 0);
			
                float xc = (lavaCoords[i * 4] + lavaCoords[i * 4 + 2]) / 2.;
                float yc = (lavaCoords[i * 4 + 1] + lavaCoords[i * 4 + 3]) / 2.;
                float xd = abs(lavaCoords[i * 4] - lavaCoords[i * 4 + 2]) / 2.;
                float yd = abs(lavaCoords[i * 4 + 1] - lavaCoords[i * 4 + 3]) / 2.;
			
                float4 p = float4(ss[0] - xc, ss[1] - lavaCoords[i * 4 + 1], 0., 1.) / screenHeight - float4(.9, .5, 0, 0);
                float t = gTime / 1000.0f;
                float r = length(p.xy + sin(t + sin(t * .8)) * .4);
                float a = atan(p.y / p.x);
                for (float i = 0.; i < 5.; i++)
                    c = c * .98 + (sin(i + float4(5, 3, 2, 1)) * .5 + .5) * smoothstep(.99, 1., sin(log(r + i * .05) - t - i + sin(a += t * .01)));
				 
                float contrib = 1.0f;
                if (xd != 0)
                    contrib = min(contrib, 1.0f - (abs(ss[0] - xc) / xd));
			
                float ycontrib = 1.0f;
                if (yd != 0)
                    ycontrib = min(contrib, 1.0f - (abs(ss[1] - yc) / yd));
                contrib = dot(contrib, ycontrib);
                float clum = (c.x + c.y + c.z) / 3.;
			//c[0] = clum * contrib; c[1] = c[2] = 0.;
                c[0] = c[1] = c[2] = clum * contrib;
                sum += c * r; //* abs(p.x * 2.0f) * abs(p.y* 2.0f) * 0.4;
            }
        }
    }
	
    if (false)
    {
        float4x3 palette =
        {
            58 / 256.0f, 58 / 256.0f, 58 / 256.0f,
							99 / 256.0f, 99 / 256.0f, 99 / 256.0f,
							134 / 256.0f, 134 / 256.0f, 134 / 256.0f,
							204 / 256.0f, 204 / 256.0f, 204 / 256.0f
        };
        float4 palgray = { 0, 0, 0, 0 };
        float3 lum = { 0.34f, 0.24f, 0.64f };
		
        for (int i = 0; i < 4; ++i)
            palgray[i] = dot(float3(palette[i][0], palette[i][1], palette[i][2]), lum);
        for (int i = 0; i < 4; ++i)
            palgray[i] /= palgray[3];
    
        float2 uv555 = ss / float2(screenWidth, screenHeight);
        uv555 = uv555 - fmod(uv555, 0.002);
		
        float gray = dot((float3) sum, lum);
		//float gray = dot(tex2D(Sampler, uv555).rgb, lum);
		//float3 colorb;
        for (int i = 0; i < 4; i++)
        {
            if (gray <= palgray[i] || i == 3)
            {
                sum = float4(palette[i], sum[3]);
                break;
            }
        }
		
    
		//fragColor = vec4(color, 1);
    }
	
    if (false)
    {
        sum += float4(sin(ss[1]) * 0.01f, sin(ss[1]) * 0.01f, sin(ss[1]) * 0.01f, 0.0);
	
	//const float lightRadius = 1.1f;
		//for (int i = 0; i < 3; i++)
		//{
			//sum[i] *= 1.0f - (abs(IN.Spec[1])) - (abs(IN.Spec[2]))  ;
		//	sum[i] *= (1.0f - (min(abs(IN.Spec[1]*lightRadius  ),1.0f))) * (1.0f - (min(abs(IN.Spec[2]*lightRadius  ),1.0f))) * 1.0f + 0.0f ;
			//color[i] *= 1.0f );
	//	}
    }
	
    if (ATSHADER && false)
    {
        float4 c = (0, 0, 0, 0);
			
        float4 p = float4(ss[0] - (screenWidth / 2.), ss[1] + (screenHeight / 10.), 0., 1.) / screenHeight - float4(.9, .5, 0, 0);
        float t = gTime / 1000.0f;
        float r = length(p.xy + sin(t + sin(t * .8)) * .4);
        float a = atan(p.y / p.x);
        for (float i = 0.; i < 60.; i++)
            c = c * .98 + (sin(i + float4(5, 3, 2, 1)) * .5 + .5) * smoothstep(.99, 1., sin(log(r + i * .05) - t - i + sin(a += t * .01)));
        float clum = (c.x + c.y + c.z) / 3.;
        c[0] = c[1] = c[2] = clum / 6.0;
		
        sum += c * r * abs(p.x * 2.0f) * abs(p.y * 2.0f) * 0.4;
		//float4 c = (0,0,0,0);
			
  		//float4 p = float4(ss[0] , ss[1],0.,1.)/1080. - float4(.9,.5,0,0);
		//float t = Time/1000.0f;
		//float r=length(p.xy+sin(t+sin(t*.8))*.4);
		//float a=atan(p.y/p.x);
		//for (float i = 0.;i<60.;i++)
   		 //    c = c*.98 + (sin(i+float4(5,3,2,1))*.5+.5)*smoothstep(.99, 1., sin(log(r+i*.05)-t-i+sin(a +=t*.01)));
		//sum+= c*r * abs(p.x * 2.0f) * abs(p.y* 2.0f) * 0.4;
    }
	
    if (SideWipeIn)
    {
        float swpt = SideWipePerc * 3.0f;
		
        float dLeft = 2.0f - ss[0] / screenWidth;
        float dVert = ss[1] / screenHeight;
        float cMult = dLeft - swpt + cos(dVert * 15. + Time / 100.) / 4.;
        cMult = clamp(cMult, 0., 1.);
        sum *= float4(cMult, cMult, cMult, 1.);
    }
    else if (SideWipeOut)
    {
        float dLeft = ss[0] / screenWidth;
        float dVert = ss[1] / screenHeight;
        float cMult = dLeft - SideWipePerc + 1. + (cos(dVert * 15. + Time / 100.) / 4.);
        cMult = clamp(cMult, 0., 1.);
        sum *= float4(cMult, cMult, cMult, 1.);
    }
	
    if (BlackAndWhiteMode || BlackAndWhiteFade)
    {
		//if (BlackAndWhiteMode) BlackAndWhitePerc = 1.0f;
        float value = (sum[0] + sum[1] + sum[2]) / 3;
		// value = (1-value) * (1-value);
		//BlackAndWhitePerc = -31.0f;
        sum[0] = value * BlackAndWhitePerc + sum[0] * (1.0f - BlackAndWhitePerc);
        sum[1] = value * BlackAndWhitePerc + sum[1] * (1.0f - BlackAndWhitePerc);
        sum[2] = value * BlackAndWhitePerc + sum[2] * (1.0f - BlackAndWhitePerc);
		// color[1] = value;
		// color[2] = value;
    }
	
    return sum;
}

technique TVertexAndPixelShader
{
    pass P0
    {
	
	//	SetBlendState(AlphaBlendingOn, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
        CullMode = none;
    //    VertexShader = compile vs_2_0 VS();
    //    PixelShader  = compile ps_2_0 PS();
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
	//	BlendOp = ADD;
	
    }
    pass P1
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCV();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P2
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P3
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P4
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCVEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P5
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P6
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P7
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCV();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
	
    pass P8
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P9
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
	
    pass P10
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCVEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
	
    pass P11
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P12
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSHB();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P13
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFTW();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P14
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
       // PixelShader  = compile ps_3_0 PS();
        PixelShader = compile ps_3_0 postRenderPS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
	//OH SHIT
    pass P15
    {
        CullMode = none;
        VertexShader = compile vs_3_0 BlurAttemptVSH();
        PixelShader = compile ps_3_0 glowPS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P16
    {
        CullMode = none;
        VertexShader = compile vs_3_0 BlurAttemptVSV();
        PixelShader = compile ps_3_0 glowPS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P17
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSYUV();
        AlphaBlendEnable = FALSE;
		//AlphaTestEnable = TRUE;
        //SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;
    }
    pass P18
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VSUIGlow();
        PixelShader = compile ps_3_0 PSFCV();
		//AlphaBlendEnable = TRUE;
		//AlphaTestEnable = TRUE;
        //SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P19
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 compositePS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P20
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 postProcessBloomPass1();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P21
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 postProcessBloomPass2();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P22 //Debug gradient
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 debugColorFill();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P23 //Distort
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distort();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P24 //Shockwave distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortShockwave();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P25 //Lava distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortLava();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P26 //Navy
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 navy();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P27 //Explosion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 explosion();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P28 //Zap
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 zap();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = One;
        DestBlend = InvSrcAlpha;
    }
    pass P29 //ZapLine
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 zapLinePass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = One;
        DestBlend = InvSrcAlpha;
    }
    pass P30 //Smoke
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 smokePass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P31 //Sparks
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 sparkPass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P32 //Fire ring
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 blastPass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P33 //Simple ring
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 simpleRingPass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P34 //Ripple distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortRipple();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P35 //Charge distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortCharge();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P36 //Recolor circular region
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorCircle();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = InvSrcAlpha;
    }
    pass P37 //Recolor rectangular region
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorRectangle();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = InvSrcAlpha;
    }

    ///////////////////////////////////////
    // BEGIN RIDICULOUS BLEND-MODE BLOCK //
    ///////////////////////////////////////
    pass P38
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorMix();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P39
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorDarken();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P40
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorMultiply();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P41
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorColorBurn();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P42
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLinearBurn();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P43
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLighten();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P44
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorScreen();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P45
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorColorDodge();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P46
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLinearDodge();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P47
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorOverlay();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P48
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorSoftLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P49
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorHardLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P50
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorVividLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P51
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLinearLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P52
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorPinLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P53
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorDifference();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P54
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorExclusion();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    /////////////////////////////////////
    // END RIDICULOUS BLEND-MODE BLOCK //
    /////////////////////////////////////
}
technique Default
{
    pass P0
    {
        // transforms
        WorldTransform[0] = (World);
        ViewTransform = (View);
        ProjectionTransform = (Projection);

        // material
        MaterialAmbient = (k_a);
        MaterialDiffuse = (k_d);
        MaterialSpecular = (k_s);
        MaterialPower = (n);
        
        // lighting
        LightType[0] = DIRECTIONAL;
        LightAmbient[0] = (I_a);
        LightDiffuse[0] = (LightColor[0]);
        LightSpecular[0] = (I_s);
        LightDirection[0] = (lightDir);
        LightRange[0] = 100000.0f;

        LightEnable[0] = TRUE;
        Lighting = TRUE;
        SpecularEnable = TRUE;
        AlphaBlendEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        CullMode = none;
		
        // samplers
        Sampler[0] = (Sampler);
        
        // texture stages
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;

        ColorOp[1] = DISABLE;
        AlphaOp[1] = DISABLE;

        // shaders
        VertexShader = NULL;
        PixelShader = NULL;
    }
}

technique TVertexShaderOnly
{
    pass P0
    {
        // lighting
        Lighting = FALSE;
        SpecularEnable = TRUE;

        // samplers
        Sampler[0] = (Sampler);

        // texture stages
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;

        ColorOp[1] = DISABLE;
        AlphaOp[1] = DISABLE;

        // shaders
        VertexShader = NULL; //compile vs_2_0 VS();
        PixelShader = NULL;
    }
}

