//--- CONSTANTS ---//
static const float3 lightDir = { 0.0, -1.0, 0.0 }; // light direction (view space)
static const float PI = 3.14159265f;

//--- MATRICES ---//
float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 Projection : PROJECTION;

//--- OTHER UNIFORMS ---//
float pSize = 0.01f; // pixel size of the texture, equivalent to the inverse of the texture width
float phMult = 1.0f;
float pvMult = 1.0f;

bool BlackAndWhiteMode = false;
bool BlackAndWhiteFade = false;
float BlackAndWhitePerc = 0;

float2 EnemyFlash = { 0, 0 };

float Time; // Used for many many effects
float gTime; // Just used for wavy effect in VS()

float FCVSat = 1.0f;

int SideWipeIn = 0;
int SideWipeOut = 0;
float SideWipePerc = 0.;
float HealthBarPerc = 1.0f;
bool HealthBar = false;
int flipFade = 0;
float fadeToPerc = 0.0f;
float4 pickupGlowColor = { 0.0f, 0.0f, 0.0f, 0.0f };

//float3 ambient = {0.0f, 0.0f, 0.0f};

//int MAX_LIGHT_COUNT = 16;
//int lightCount = 0;
//float lightColors[16 * 4] ;//= {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
//float lightPositions[16* 2];// = {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
//float lightRadii[16 * 1] ;//= {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
//float lightPower[16 * 1];

int doWavy = 0;
int dw2 = 0;

float wavePer = 1.0f;
float waveAmp = 1.0f;
float waveSpd = 1.0f;
float maxHeight = 1;
float maxWidth = 1;
int screenHeight = 1000;
int screenWidth = 1000;

float4 FCV;
float4x4 ColorShift;

float fadeColor = 1.0f;
float fadeAlpha = 1.0f;
float UIGPerc = 0.0f;
float4 UIGInfo = { 0.0f, 0.0f, 0.0f, 0.0f };

float2 mousePos;

float bloomRadius = 0.005;
float bloomThreshold = 0.27;
float bloomSoften = 2.6; 
float bloomAlpha = 0.75;
float bloomAlpha2 = 0.75;

float vfxElapsedTime;
float vfxDuration;
float vfxRandom;
float vfxBlackout = 1.0f;

float4 recolorColor;
float4 recolorAspect;
float recolorGradientStrength;
float recolorGradientAngle;

struct BLUR_INPUT
{
    float4 pos : POSITION;
    float2 texCoord : TEXCOORD;
};

struct BLUR_OUTPUT
{
    float4 pos : POSITION;
    float2 texCoord0 : TEXCOORD0;
    float2 texCoord1 : TEXCOORD1;
    float2 texCoord2 : TEXCOORD2;
    float2 texCoord3 : TEXCOORD3;
    float2 texCoord4 : TEXCOORD4;
    float2 texCoord5 : TEXCOORD5;
    float2 texCoord6 : TEXCOORD6;
    float2 texCoord7 : TEXCOORD7;
    float2 texCoord8 : TEXCOORD8;
};

struct VS_OUTPUT
{
    float4 Pos : POSITION;
    float4 Diff : COLOR0;
    float4 Spec : COLOR1;
    float2 Tex : TEXCOORD0;
    float3 PosW : TEXCOORD1;
};

//--- SAMPLERS ---//
texture samplerTex1;
sampler Sampler = sampler_state
{
    Texture = samplerTex1;
   // Filter = MIN_MAG_MIP_LINEAR;
    Filter = MIN_MAG_MIP_POINT;
};

texture samplerTex2;
sampler Sampler2 = sampler_state
{
    Texture = samplerTex2;
    Filter = ANISOTROPIC;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture samplerTex3;
sampler Sampler3 = sampler_state
{
    Texture = samplerTex3;
    Filter = MIN_MAG_MIP_LINEAR;
};

texture samplerTex1p;
sampler SamplerP = sampler_state
{
    Texture = samplerTex1p;
    Filter = MIN_MAG_MIP_POINT;
};

texture noiseTexture;
sampler noiseSampler = sampler_state
{
    Texture = noiseTexture;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};

texture sceneTexture;
sampler sceneSampler = sampler_state
{
    Texture = sceneTexture;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture uiNoClampTexture;
sampler uiNoClampSampler = sampler_state
{
    Texture = uiNoClampTexture;
    Filter = ANISOTROPIC;
    AddressU = WRAP;
    AddressV = WRAP;
};

texture blurTexture;
sampler blurSampler = sampler_state
{
    Texture = blurTexture;
    Filter = MIN_MAG_MIP_POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture blurTexture2;
sampler blurSampler2 = sampler_state
{
    Texture = blurTexture2;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture distortTexture;
sampler distortSampler = sampler_state
{
    Texture = distortTexture;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture recolorTexture;
sampler recolorSampler = sampler_state
{
    Texture = recolorTexture;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

texture lumpTexture1;
sampler lumpSampler = sampler_state
{
    Texture = lumpTexture1;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};
texture lumpTexture2;
sampler lumpColorSampler = sampler_state
{
    Texture = lumpTexture2;
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};


float random(float2 p)
{
  // We need irrationals for pseudo randomness.
  // Most (all?) known transcendental numbers will (generally) work.
    const float2 r = float2(
    23.1406926327792690, // e^pi (Gelfond's constant)
     2.6651441426902251); // 2^sqrt(2) (Gelfond?Schneider constant)
    return frac(cos(fmod(123456789., 1e-7 + 256. * dot(p, r))));
 // return 0.0f;
}

float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

float2 unlerp(float min, float max, float2 t)
{
    return float2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

float3 unlerp(float min, float max, float3 t)
{
    return float3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

float4 unlerp(float min, float max, float4 t)
{
    return float4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}

float bias(float b, float x)
{
    return x / ((1 / b - 2) * (1 - x) + 1);
}

float sigmoidBias(float x, float bias)
{
    x *= 2;
    return x < 1 ? (x / ((1 / bias - 2) * (1 - x) + 1)) / 2 : ((x - 1) / ((1 / (1 - bias) - 2) * (1 - (x - 1)) + 1) + 1) / 2;
}

float backOut(float t)
{
    float f = clamp(1.0 - t, 0.000001, 1.0); //Look I don't know why okay
    return 1.0 - (pow(f, 1.5) - f * sin(f * PI));
}

float backInOut(float t)
{
    float f = t < 0.5
		? 2.0 * t
		: 1.0 - (2.0 * t - 1.0);

    float g = pow(f, 1.5) - f * sin(f * PI);

    return t < 0.5
		? 0.5 * g
		: 0.5 * (1.0 - g) + 0.5;
}

VS_OUTPUT VS(
    float3 Pos : POSITION,
    float3 Norm : NORMAL,
    float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;

    float4x4 WorldView = mul(World, View);

    float3 P = mul(float4(Pos, 1), (float4x3) WorldView); // position (view space)
    Out.PosW = mul(Pos, World);
    Out.Pos = mul(float4(P, 1), Projection); // position (projected)
	
    Out.Diff = float4(fadeColor , fadeColor , fadeColor , fadeAlpha );
		
    Out.Tex = Tex;
    Out.Spec[0] = 1.0f - Norm[0];
    Out.Spec[1] = Norm[0];
    Out.Spec[2] = Norm[1];
    Out.Spec[3] = Norm[2];
	
    return Out;
}

VS_OUTPUT VSLava1(
    float3 Pos : POSITION,
    float3 Norm : NORMAL,
    float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;

    float4x4 WorldView = mul(World, View);

    float3 P = mul(float4(Pos, 1), (float4x3) WorldView); // position (view space)
    Out.PosW = mul(Pos, World);
    Out.Pos = mul(float4(P, 1), Projection); // position (projected)
    
    Out.Pos[1] += (((cos((gTime / 1000 + Pos[0] / 2) / wavePer) + 1.0f) * waveAmp) * Pos[1] / maxHeight);

    //fade = 0.5f;
    Out.Diff = float4(fadeColor, fadeColor, fadeColor, fadeAlpha);
        
    Out.Tex = Tex;
    Out.Spec[0] = 1.0f - Norm[0];
    
    return Out;
}

VS_OUTPUT VSLava2(
    float3 Pos : POSITION,
    float3 Norm : NORMAL,
    float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;

    float4x4 WorldView = mul(World, View);

    float3 P = mul(float4(Pos, 1), (float4x3) WorldView); // position (view space)
    Out.PosW = mul(Pos, World);
    Out.Pos = mul(float4(P, 1), Projection); // position (projected)
    
    Out.Pos[1] += (((cos((gTime / 1000 + Pos[0] / 2) / wavePer) + 1.0f) * waveAmp) * Pos[1] / maxHeight);
    Tex[0] += fmod(gTime, 20000.0f / waveSpd) / (20000.0f / waveSpd);

    //fade = 0.5f;
    Out.Diff = float4(fadeColor, fadeColor, fadeColor, fadeAlpha);
        
    Out.Tex = Tex;
    Out.Spec[0] = 1.0f - Norm[0];
    
    return Out;
}

VS_OUTPUT VSUIGlow(
    float3 Pos : POSITION,
    float3 Norm : NORMAL,
    float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;

    float4x4 WorldView = mul(World, View);
	
    Pos[0] += UIGInfo[2] * UIGPerc * sign(Pos[0] - UIGInfo[0]) * screenHeight / 1080.0f;
    Pos[1] += UIGInfo[3] * UIGPerc * sign(Pos[1] - UIGInfo[1]) * screenHeight / 1080.0f;

    float3 P = mul(float4(Pos, 1), (float4x3) WorldView); // position (view space)
	
    Out.Pos = mul(float4(P, 1), Projection); // position (projected)
    Out.Diff = float4(fadeColor, fadeColor, fadeColor, fadeAlpha);
		
    Out.Tex = Tex;
    Out.Spec[0] = 1.0f - Norm[0];
	
	
    return Out;
}

BLUR_OUTPUT PickupVS(BLUR_INPUT IN)
{
    BLUR_OUTPUT OUT;

    OUT.texCoord0 = IN.texCoord + float2(         0.0f, 0.0f);
    OUT.texCoord1 = IN.texCoord + float2(-pSize * 2.0f * phMult, 0.0f);
    OUT.texCoord2 = IN.texCoord + float2(-pSize * 1.0f * phMult, 0.0f);
    OUT.texCoord3 = IN.texCoord + float2( pSize * 1.0f * phMult, 0.0f);
    OUT.texCoord4 = IN.texCoord + float2( pSize * 2.0f * phMult, 0.0f);
    OUT.texCoord5 = IN.texCoord + float2(         0.0f, -pSize * 2.0f * pvMult);
    OUT.texCoord6 = IN.texCoord + float2(         0.0f, -pSize * 1.0f * pvMult);
    OUT.texCoord7 = IN.texCoord + float2(         0.0f, pSize * 1.0f * pvMult);
    OUT.texCoord8 = IN.texCoord + float2(         0.0f, pSize * 2.0f * pvMult);

    float4x4 WorldView = mul(World, View);
    float3 P = mul(IN.pos, (float4x3) WorldView); // position (view space)
    OUT.pos = mul(float4(P, 1), Projection);
	return OUT;
}

BLUR_OUTPUT BlurAttemptVSH(BLUR_INPUT IN)
{
    BLUR_OUTPUT OUT;

    float3 L = -lightDir;

    float4x4 WorldView = mul(World, View);

    float4 newp = mul(IN.pos, 2.0f);
	
    float3 P = mul(IN.pos, (float4x3) WorldView); // position (view space)
    OUT.pos = mul(float4(P, 1), Projection);
	
	//OUT.pos = mul(OUT.pos, 110.5f);// position (projected)

    OUT.texCoord0 = IN.texCoord + float2(-pSize * 3, 0);
    OUT.texCoord1 = IN.texCoord + float2(-pSize * 2, 0);
    OUT.texCoord2 = IN.texCoord + float2(-pSize * 1, 0);
    OUT.texCoord3 = IN.texCoord + float2(0, 0);
    OUT.texCoord4 = IN.texCoord + float2(pSize * 1, 0);
    OUT.texCoord5 = IN.texCoord + float2(pSize * 2, 0);
    OUT.texCoord6 = IN.texCoord + float2(pSize * 3, 0);
    return OUT;
}

BLUR_OUTPUT BlurAttemptVSV(BLUR_INPUT IN)
{
    BLUR_OUTPUT OUT;

    float3 L = -lightDir;

    float4x4 WorldView = mul(World, View);

	//float4 newp = mul(IN.pos, 2.0f);
	//newp[1] += 2.0f;
	
    float3 P = mul(IN.pos, (float4x3) WorldView); // position (view space)

    OUT.pos = mul(float4(P, 1), Projection);
	//OUT.pos = mul(OUT.pos, 110.5f);// position (projected)

    OUT.texCoord0 = IN.texCoord + float2(0, -pSize * 3);
    OUT.texCoord1 = IN.texCoord + float2(0, -pSize * 2);
    OUT.texCoord2 = IN.texCoord + float2(0, -pSize * 1);
    OUT.texCoord3 = IN.texCoord + float2(0, 0);
    OUT.texCoord4 = IN.texCoord + float2(0, pSize * 1);
    OUT.texCoord5 = IN.texCoord + float2(0, pSize * 2);
    OUT.texCoord6 = IN.texCoord + float2(0, pSize * 3);
    return OUT;
}

BlendState AlphaBlendingOn
{
    BlendEnable[0] = TRUE;
    SrcBlend = SRC_ALPHA;
    DestBlend = INV_SRC_ALPHA;
    BlendOp = ADD;
    SrcBlendAlpha = ONE;
    DestBlendAlpha = ONE;
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

float4 FCVD(float4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
	
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1 - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0;
    l = 1 - l; 
	
	//removed * l from first term down there
    float3 c2 = float3((FCV[3]) * float3(FCV[0], FCV[1], FCV[2]) + (1 - FCV[3]) * float3(cin[0], cin[1], cin[2]));
    return float4(c2[0], c2[1], c2[2], cin[3]);
}

float4 CSD(float4 cin)
{
    return mul(cin, ColorShift);
}

float4 EFD(float4 cin)
{
    return float4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}

//does everything
float4 PSFTW(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color;
	
    color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
    color = FCVD(color);
	
    color[0] = color[0] * (1 - fadeToPerc);
    color[1] = color[1] * (1 - fadeToPerc);
    color[2] = color[2] * (1 - fadeToPerc);
	
    return color;
}
//does only basic draw
float4 PSYUV(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    const float3 offset = { -0.0627451017, -0.501960814, -0.501960814 };
    const float3 Rcoeff = { 1.164, 0.000, 1.596 };
    const float3 Gcoeff = { 1.164, -0.391, -0.813 };
    const float3 Bcoeff = { 1.164, 2.018, 0.000 };

    float3 yuv;
	
    yuv.x = tex2D(Sampler, input.Tex).a;
    yuv.y = tex2D(Sampler2, input.Tex).a;
    yuv.z = tex2D(Sampler3, input.Tex).a;
	
    yuv += offset;
	
    float4 color;
    color.b = dot(yuv, Rcoeff);
    color.g = dot(yuv, Gcoeff);
    color.r = dot(yuv, Bcoeff);
    color.a = 1.0f;
	
    return color;
}
float4 PSYUVInterleave(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    const float3 offset = { -0.0627451017, -0.501960814, -0.501960814 };
    const float3 Rcoeff = { 1.164, 0.000, 1.596 };
    const float3 Gcoeff = { 1.164, -0.391, -0.813 };
    const float3 Bcoeff = { 1.164, 2.018, 0.000 };

    float3 yuv;

    yuv.xyz = tex2D(Sampler, input.Tex).zyx;
	
    yuv += offset;
	
    float4 color;
    color.b = dot(yuv, Rcoeff);
    color.g = dot(yuv, Gcoeff);
    color.r = dot(yuv, Bcoeff);
    color.a = 1.0f;
	
    return color;
}
float4 PS(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
	
	//float4 baseLight = float4(ambient, 1.0f);
	
	//color = color * baseLight;
	
    color[3] = min(color[3], input.Spec[0]);

    return color;
}

float4 PS_UI(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler2, input.Tex) * input.Diff;
	
	//float4 baseLight = float4(ambient, 1.0f);
	
	//color = color * baseLight;
	
    color[3] = min(color[3], input.Spec[0]);

    return color;
}

float4 PS_UI_NoClamp(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(uiNoClampSampler, input.Tex) * input.Diff;
	
	//float4 baseLight = float4(ambient, 1.0f);
	
	//color = color * baseLight;
	
    color[3] = min(color[3], input.Spec[0]);

    return color;
}

float4 PSUI(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
	
	//float4 baseLight = float4(ambient, 1.0f);
	
	//baseLight = clamp(baseLight, 0.0f, 1.05f);
	
	//color = color * baseLight;
	
    color[3] = min(color[3], input.Spec[0]);

    return color;
}

float4 PSClamp(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
	float maxBleed = 0.01f;
	float tx0 = (1.0f - (clamp(abs(input.Tex.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(input.Tex.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    float4 color =  tex2D(blurSampler, input.Tex) * tx0 * input.Diff;
	
    color[3] = min(color[3], input.Spec[0]);

    return color;
}
float4 PSFont(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    float4 color2 = float4(1.0, 1.0, 1.0, min(color[3], input.Spec[0]));

    color2 = FCVD(color2);

    return color2;
}
float4 PSEF(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = EFD(color);
	
    return color;
}

//does FCV draw
float4 PSFCV(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = FCVD(color);
	
    return color;
}
float4 PSFCVEF(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
	//return float4(0,0,0,0);
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = FCVD(color);
    color = EFD(color);
    return color;
}

float4 PSCS(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
	
    return color;
}

float4 PSCS_UI(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler2, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
	
    return color;
}

float4 PSCS2(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
	
    return color;
}

float4 PSCSEF(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    color = CSD(color);
    color = EFD(color);
	
    return color;
}

float4 PSHB(VS_OUTPUT input, float4 ss : VPOS) : COLOR
{
    float4 color = tex2D(Sampler, input.Tex) * input.Diff;
    color[3] = min(color[3], input.Spec[0]);
	
    if (input.Tex[1] > HealthBarPerc)
    {
        color[3] = 0;
    }
	
    return color;
}

float4 glowPS_old(BLUR_OUTPUT IN) : COLOR
{
    float4 color = tex2D(Sampler, IN.texCoord0) * 0.25;
    color += tex2D(Sampler, IN.texCoord1) * 0.1;
    color += tex2D(Sampler, IN.texCoord2) * 0.2;
    color += tex2D(Sampler, IN.texCoord3) * 0.3;
    color += tex2D(Sampler, IN.texCoord4) * 0.2;
    color += tex2D(Sampler, IN.texCoord5) * 0.1;
    color += tex2D(Sampler, IN.texCoord6) * 0.25;
	
    color[1] = 1.0f;
    color[0] = 0.0f;
    color[2] = 0.0f;
	
    return float4(pickupGlowColor[0], pickupGlowColor[1], pickupGlowColor[2], color[3]);
}

float4 glowPS(BLUR_OUTPUT IN) : COLOR
{
    float4 color;
	
	float maxBleed = 0.01f;
	float tx0 = (1.0f - (clamp(abs(IN.texCoord0.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord0.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    color =  tex2D(blurSampler, IN.texCoord0) * tx0;
	
	float4 addColor;
	float tx1 = (1.0f - (clamp(abs(IN.texCoord1.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord1.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
	addColor  = tex2D(blurSampler, IN.texCoord1) * 0.1f * tx1;
	
	float tx2 = (1.0f - (clamp(abs(IN.texCoord2.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord2.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += tex2D(blurSampler, IN.texCoord2) * 0.2f * tx2;
	
	float tx3 = (1.0f - (clamp(abs(IN.texCoord3.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord3.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += tex2D(blurSampler, IN.texCoord3) * 0.2f * tx3;
	
	float tx4 = (1.0f - (clamp(abs(IN.texCoord4.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord4.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += tex2D(blurSampler, IN.texCoord4) * 0.1f * tx4;
	
	float tx5 = (1.0f - (clamp(abs(IN.texCoord5.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord5.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
	addColor += tex2D(blurSampler, IN.texCoord5) * 0.1f * tx5;
	
	float tx6 = (1.0f - (clamp(abs(IN.texCoord6.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord6.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += tex2D(blurSampler, IN.texCoord6) * 0.2f * tx6;
	
	float tx7 = (1.0f - (clamp(abs(IN.texCoord7.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord7.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += tex2D(blurSampler, IN.texCoord7) * 0.2f * tx7;
	
	float tx8 = (1.0f - (clamp(abs(IN.texCoord8.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(IN.texCoord8.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += tex2D(blurSampler, IN.texCoord8) * 0.1f * tx8;
    
    addColor = float4(pickupGlowColor.xyz, addColor.w);
	addColor.w = clamp(addColor.w, 0.0f, 1.0f);
	
	color += addColor * (1.0f - clamp(color[3], 0.0f, 1.0f));
	
	return color;
}

float4 glowPSH(VS_OUTPUT IN) : COLOR
{
    float2 Tex = IN.Tex;
    float blur = 0.05f;

    float4 sum = float4(0.0, 0.0, 0.0, 0.0);
    sum += tex2D(Sampler, float2(Tex.x - 4.0 * blur, Tex.y)) * 0.05;
    sum += tex2D(Sampler, float2(Tex.x - 3.0 * blur, Tex.y)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x - 2.0 * blur, Tex.y)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x - blur, Tex.y)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y)) * 0.16;
    sum += tex2D(Sampler, float2(Tex.x + blur, Tex.y)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x + 2.0 * blur, Tex.y)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x + 3.0 * blur, Tex.y)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x + 4.0 * blur, Tex.y)) * 0.05;

    return sum;
}

float4 glowPSV(VS_OUTPUT IN) : COLOR
{
    float2 Tex = IN.Tex;
    float blur = 0.05f;
    float opacity = 0.5f;

    float4 sum = float4(0.0, 0.0, 0.0, 0.0);
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - 4.0 * blur)) * 0.05;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - 3.0 * blur)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - 2.0 * blur)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y - blur)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y)) * 0.16;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + blur)) * 0.15;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + 2.0 * blur)) * 0.12;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + 3.0 * blur)) * 0.09;
    sum += tex2D(Sampler, float2(Tex.x, Tex.y + 4.0 * blur)) * 0.05;

    float4 result = sum * opacity;
    float3 glowColor = float3(pickupGlowColor[0], pickupGlowColor[1], pickupGlowColor[2]);
    result.rgb = float3(glowColor.r, glowColor.g, glowColor.b) / 255.0f;
//secondforeground??

    float4 src = tex2D(Sampler, IN.Tex.xy);
    return result * (1 - src.a) + src;
}

float4 additiveBloom(float4 baseImage, float4 blurImage, float4 blurImage2)
{
    return baseImage + (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}

float4 maxBloom(float4 baseImage, float4 blurImage)
{
    return max(baseImage, blurImage);
}

float4 compositePS(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);

    float4 baseImage = tex2D(sceneSampler, uv);
    float4 blurImage = tex2Dlod(blurSampler, float4(uv, 0, bloomSoften));
    float4 blurImage2 = tex2Dlod(blurSampler2, float4(uv, 0, bloomSoften));
	
	//return baseImage;
	//return maxBloom(baseImage, blurImage);
    return additiveBloom(baseImage, blurImage, blurImage2);
}

float4 bloomSample(sampler samplerState, float2 uv, float2 direction, float radius, float threshPower)
{
    float2 aspect = float2(1.0, float(screenWidth) / float(screenHeight));
    float4 sum = float4(0, 0, 0, 0);
    sum += pow(tex2D(samplerState, uv + (direction * radius * -4.0f) * aspect), threshPower) * 0.0162162f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * -3.0f) * aspect), threshPower) * 0.0540541f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * -2.0f) * aspect), threshPower) * 0.121622f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * -1.0f) * aspect), threshPower) * 0.194595f;
    sum += pow(tex2D(samplerState, uv), threshPower) * 0.227027f;
    sum += pow(tex2D(samplerState, uv + (direction * radius) * aspect), threshPower) * 0.194595f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * 2.0f) * aspect), threshPower) * 0.121622f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * 3.0f) * aspect), threshPower) * 0.0540541f;
    sum += pow(tex2D(samplerState, uv + (direction * radius * 4.0f) * aspect), threshPower) * 0.016216f;
    return sum;
}

float4 postProcessBloomPass1(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);

    float thresh = lerp(1, 5, bloomThreshold);
    return bloomSample(blurSampler, uv, normalize(float2(1, 1)), bloomRadius, thresh);
}

float4 postProcessBloomPass2(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);

    return bloomSample(blurSampler, uv, normalize(float2(1, -1)), bloomRadius, 1);
}

float4 distort(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float maxDistortion = 0.05;
    float4 offsetSample = tex2D(distortSampler, uv);
    offsetSample.y = 1.0 - offsetSample.y;
    float2 offsets = (offsetSample.xy * 2.0 - 1.0) * maxDistortion / aspect;
    return tex2D(sceneSampler, uv + offsets);
}

float4 distortShockwave(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 center = float2(0.5, 0.5);
    float2 loc = IN.Tex.xy - center;
    float2 direction = normalize(loc);
    float radius = length(loc);
    float magnitude;

    float edgeSoften = 0.01;
    float outerEdge = 0.5 - edgeSoften;
    float innerEdge = 0.392;

    magnitude = unlerp(innerEdge, outerEdge, radius);
    magnitude = bias(0.1, magnitude);
    magnitude = lerp(magnitude, 0, smoothstep(outerEdge, outerEdge + edgeSoften, radius));

    float2 result = unlerp(-1.0, 1.0, direction);
    return float4(result, 1.0, magnitude);
}

float4 distortRipple(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 center = float2(0.5, 0.5);
    float2 loc = IN.Tex.xy - center;
    float2 direction = normalize(loc);
	
    float radius = length(loc);
	float rr = 2.0;
	direction = (max((rr - (radius-0.2) * 5) / rr, 0)) * direction;
	//direction = 0.2 * direction;
	direction.y = 0;
    float magnitude;

    float edgeSoften = 0.01;
    float outerEdge = 0.5 - edgeSoften;
    float innerEdge = 0.392;

    magnitude = unlerp(innerEdge, outerEdge, radius);
    magnitude = bias(0.1, magnitude);
    magnitude = lerp(magnitude, 0, smoothstep(outerEdge, outerEdge + edgeSoften, radius));

    float2 result = unlerp(-1.0, 1.0, direction);
    return float4(result, 1.0, magnitude);
}

float4 distortLava(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float noiseScale = 0.1;
    float modSpeed = 0.0005;
    float slideSpeed = 0.0001;
    float squish = 2;
    float maskScale = 0.6;
    float strength = 0.04;

    float2 uv = IN.PosW.xy * noiseScale;
    uv.y *= squish;
    uv.y -= slideSpeed * Time;
    float noise = tex2D(noiseSampler, uv).r;
	
    noise = sin(PI * 2.0 * fmod(noise + Time * modSpeed, 1.0));

    float2 direction = normalize(float2(sin(PI * 2.0 * noise), cos(PI * 2.0 * noise)));

    float magnitude = pow(tex2D(noiseSampler, uv * maskScale).r, 2);

    float topFade = 0.4;
    float bottomFade = 0.2;
    float sideFade = 0.05;
    magnitude *= smoothstep(1.0, 1.0 - topFade, IN.Tex.y);
    magnitude *= smoothstep(0, bottomFade, IN.Tex.y);
    magnitude *= smoothstep(0, sideFade, IN.Tex.x);
    magnitude *= smoothstep(1.0, 1.0 - sideFade, IN.Tex.x);
    magnitude *= strength;

    direction = unlerp(-1.0, 1.0, direction);
    return float4(direction, 1.0, magnitude);
}

float4 debugColorFill(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    return float4(IN.Tex.x, IN.Tex.y, 1, 1);
}

float4 blast(float2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0) * speed - timeOffset;
    float timeStomp = step(0, time);
    float noiseAmount = clamp(lerp(0.4, 0.16, time - 0.1), 0.0, 1.0);
    float threshold = clamp(lerp(1.0, 0.0, time - 0.1), 0.0, 1.0);

	
    uv -= 0.5;
    uv /= scale;
    uv += 0.5;
	
	uv = round(uv * 64.0) / 64.0; 
	
    float2 baseUv = uv;
    float minZoom = 1.0;
    float maxZoom = 2.0;
    float zoom = 1 / lerp(minZoom, maxZoom, time);
    uv -= 0.5;
    uv *= zoom;
    uv += 0.5;


    float noise = tex2D(lumpSampler, uv + rand).a;
    float noise2 = tex2D(lumpSampler, (uv - rand) * 0.6).a;

    float baseRadius = 0.3;
    float bout = abs(backOut(bias(unlerp(0.0, 0.6, time), 0.75)));
    float radius = lerp(0.0, 1.0, bout) * baseRadius;
    radius += noise2 * lerp(0.15, 0.07, threshold) * timeStomp;
    float arm = unlerp(0.0, radius, length(baseUv - 0.5));
    float power = sqrt(1.0 - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0 - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0;

    power = unlerp(0.0, threshold, power);

    float colorPicker = bias(power, noise) - (1.0 - threshold) + power * 0.16;
    float3 color = tex2D(lumpColorSampler, float2(colorPicker, 0.5)).rgb;
	
    float alpha = 1.0 - step(power, 0.0);
    float4 final = float4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

float4 smoke(float2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0) * speed - timeOffset;
    float noiseAmount = clamp(lerp(0.4, 0.16, time - 0.1), 0.0, 1.0);
    float threshold = saturate(lerp(0, 1, time - 0.1));

    float baseRadius = 0.3;
    float bout = abs(backOut(bias(unlerp(0.0, 0.6, time), 0.75)));
    float radius = lerp(0.0, 1.0, bout) * baseRadius;

    uv -= 0.5;
    uv /= scale;
    uv += 0.5;
	
	uv = round(uv * 64.0) / 64.0; 
	
    float2 baseUv = uv;
    float minZoom = 1.0;
    float maxZoom = 1.9;
    float zoom = 1 / lerp(minZoom, maxZoom, time);
    uv -= 0.5;
    uv *= zoom;
    uv += 0.5;

    float slide = time * -0.5;
    uv.y += slide;

    float noise = tex2D(lumpSampler, uv + rand).a;
    float noise2 = tex2D(lumpSampler, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1 - threshold) * 0.25;
    float3 color = tex2D(lumpColorSampler, float2(colorPicker, 0.5)).rgb * 0.75;

    float growthTime = 0.1;
    float edgeRaggedness = 0.2;
    float expansion = smoothstep(growthTime, 0, time) / 2;
    float falloff = 1 - ((length(baseUv - 0.5) + (1 - noise2) * edgeRaggedness) + expansion) * 2;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2);

    float4 final = float4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

float4 spark(float2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0) * speed - timeOffset;
    float timeStomp = step(0, time);
    float burstPower = time * 0.1;
    
    uv -= 0.5;
    uv /= scale;
    uv += 0.5;
	
	uv = round(uv * 64.0) / 64.0; 
	
    float2 epicenter = uv - 0.5;
    float r = length(epicenter);
    float2 burstUv = epicenter * 1.0 / pow(r, lerp(1.06, 2.0, burstPower)) / lerp(0.715, 0.57, bias(0.6, time));

    float threshold = lerp(0.682, 1.2, bias(0.755, time));
    float4 noise = tex2D(lumpSampler, burstUv - rand).a;
    float limit = 1.0 - (smoothstep(1.8, 0.531, r * 2)) - 0.066 * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    float3 color = tex2D(lumpColorSampler, float2(lerp(1, 0.5, time), 0.5));
    color.rgb *= vfxBlackout;
    return float4(color, alpha);
}

float4 comp(float4 src, float4 dst)
{
    return lerp(src, dst, 1.0 - src.a);
}

float4 explosion(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex.xy;
    float rand = random(float2(vfxRandom, 0));
    float4 blaast = blast(uv, 0.66, vfxElapsedTime, rand, 0.21, 2.0);
    float4 smooke = smoke(uv, 0.66, vfxElapsedTime, rand, 0, 0.7);
    float4 spaark = spark(uv, 1, vfxElapsedTime, rand, 0.08125, 0.9);
    float4 final = comp(spaark, comp(blaast, smooke));
    final.rgb *= vfxBlackout;
    return final;
}
float4 explosionBatch(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex.xy;
    float vfxRandomBatch = IN.Spec[1];
    float vfxElapsedTimeBatch = IN.Spec[2];
	float rand = vfxRandomBatch;
	
    float4 blaast = blast(uv, 0.66, vfxElapsedTimeBatch, rand, 0.21, 2.0);
    float4 smooke = smoke(uv, 0.66, vfxElapsedTimeBatch, rand, 0, 0.7);
    float4 spaark = spark(uv, 1, vfxElapsedTimeBatch, rand, 0.08125, 0.9);
    float4 final = comp(spaark, comp(blaast, smooke));
    final.rgb *= vfxBlackout;
    return final;
}

float4 blastPass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float rand = random(float2(vfxRandom, 0));
    return blast(IN.Tex.xy, 0.66, vfxElapsedTime, rand, 0.21, 2.0);
}

float4 smokePass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float rand = random(float2(vfxRandom, 0));
    return smoke(IN.Tex.xy, 0.66, vfxElapsedTime, rand, 0.0, 0.7);
}

float4 sparkPass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float rand = random(float2(vfxRandom, 0));
    return spark(IN.Tex.xy, 1, vfxElapsedTime, rand, 0.0, 0.9);
}

float3 zapLine(float2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323;
    const float scale = 0.5354330708661418;
    const float texSpeed = 1.0;
    const float sinSpeed = 0.1968503937007874;
    const float taper = 0.28346456692913385;
    const float timeScale = 1.0;
    const float bloomPower = 0.007874015748031496;

    float fatness = 0.023622047244094488;
    float maxOffset = 0.48031496062992124;
    float bloomRadius = 0.25196850393700787;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961, strength);


    float3 final = float3(0, 0, 0);
    float time = Time * timeScale;

    float2 texUv = uv;
    float2x2 rot = float2x2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5;
    texUv = mul(rot, texUv);
    texUv += 0.5;

    texUv.y += rand;
    texUv.x += time * 0.001 * texSpeed;
    texUv *= 1 / lerp(1, 3, scale);

    uv -= 0.5;
    uv = mul(rot, uv);
    uv += 0.5;

    float bwoopShrink = smoothstep(0.4094488, 0, strength);
    float bwoop = saturate(bias(taper, 1 - lerp(0, 1, abs(uv.y - 0.5) * 2 + bwoopShrink)));

    float lumps = tex2D(lumpSampler, texUv).a;
    float sinOff = (time * 0.001 * sinSpeed) + rand;
    float shift = (lumps - 0.5) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100) * bwoop;
    float width = bwoop * fatness;
    float power = 1 - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5 + shift)));
    power = bias(bloomPower, power);
    final.rgb = power;
    return final;
}

float3 zapRing(float2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826;
    float endRadius = startRadius + 0.27559055;
    
    float bloomRadius = lerp(0.71653543, 0, bias(0.13385826, age));
    float innerRadius = lerp(0, endRadius, bias(0.25196850, age));
    float outerRadius = lerp(startRadius, endRadius, bias(0.18110236, age));
    
    float bloomPower = 0.007874015748031496 * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5));
    float outer = 1 - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5));
    float power = bias(bloomPower, inner * outer);

    float3 final = float3(0, 0, 0);
    final.rgb = power;
    return final;
}

float4 zap(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float time = vfxElapsedTime / 1000.0;
    float lifetime = 0.22834645f;
    float progress = unlerp(0, lifetime, time);
    float strength = 1 - (progress % (0.5)) * 2;
    strength = time > lifetime ? 0 : strength;
    strength = bias(0.7244094488188977, strength);

    float angle = 0.97637795 * (PI * 2 * vfxRandom) + step(0.5, progress) * PI / 4;

    float4 col = float4(0, 0, 0, 1);
    col.rgb += zapLine(IN.Tex.xy, angle, strength, random(float2(0, 0)));
    col.rgb += zapLine(IN.Tex.xy, angle + PI / 2, strength, random(float2(0, 1)));
    col.rgb += zapRing(IN.Tex.xy, progress, 1);
    col.rgb = saturate(col.rgb);

    float3 white = float3(1, 1, 1);
    float3 black = float3(0, 0, 0);
    float3 blue = float3(0.1, 0.5, 1);
    col.a = bias(0.3543307, col.r);
    col.rgb = lerp(lerp(black, blue, unlerp(0, 0.5, col.r)), lerp(blue, white, unlerp(0.5, 1, col.r)), step(0.5, col.r));
    col.rgb *= vfxBlackout;
    return col;
}

float4 zapLinePass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float time = vfxElapsedTime / 1000.0;
    float lifetime = 0.22834645f;
    float progress = unlerp(0, lifetime, time);
    float strength = 1 - progress;
    strength = time > lifetime ? 0 : strength;
    strength = bias(0.7244094488188977, strength);

    float rand = random(float2(vfxRandom, 0));

    float4 col = float4(0, 0, 0, 1);
    col.rgb = saturate(zapLine(IN.Tex.xy, PI/2.0, strength, rand));

    float3 white = float3(1, 1, 1);
    float3 black = float3(0, 0, 0);
    float3 blue = float3(0.1, 0.5, 1);
    col.a = bias(0.3543307, col.r);
    col.rgb = lerp(lerp(black, blue, unlerp(0, 0.5, col.r)), lerp(blue, white, unlerp(0.5, 1, col.r)), step(0.5, col.r));
    col.rgb *= vfxBlackout;
    return col;
}

float4 simpleRingPass(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float time = vfxElapsedTime / 1000.0;
    float lifetime = 0.22834645f;
    float progress = unlerp(0, lifetime, time);
    float4 col = float4(0, 0, 0, 1);
    col.rgb = zapRing(IN.Tex.xy, progress, 0.0001);
    col.a = length(col.rgb);
    col.rgb *= vfxBlackout;
    return col;
}

float4 distortCharge(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    const float uvScale         = 0.283464566f;
    const float uvInversionBias = 0.629921258f;
    const float ringSoften      = 0.039370075f;
    const float ringAnimBias    = 0.29921259f;
    const float ringRadiusScale = 0.57480314f;
    const float ringFadeIn      = 0.05511811f;

    float2 center = float2(0.5, 0.5);
    float2 loc = IN.Tex.xy - center;
    float2 direction = normalize(loc);

    float radius = length(loc);
    float angle = Time / 1000.0;
    float2 texUvA = IN.Tex.xy;
    float2 texUvB = IN.Tex.xy;
    float2x2 rot = float2x2(cos(angle), -sin(angle), sin(angle), cos(angle));
    texUvA -= 0.5;
    texUvB -= 0.5;
    texUvA /= uvScale * 5;
    texUvB /= uvScale * 7;
    texUvA = mul(rot, texUvA);
    texUvB = mul(texUvB, rot);
    texUvA += 0.5;
    texUvB += 0.5;

    float stellate = pow(radius, uvInversionBias);
    texUvA = texUvA / stellate;
    texUvB = texUvB / stellate;
    float4 texA = tex2D(lumpSampler, texUvA);
    float4 texB = tex2D(lumpSampler, texUvB);

    float magnitude;
    direction *= lerp(-1.0, 1.0, texA.a * texB.a);

    float ringAnimProgress = (vfxElapsedTime / vfxDuration) % 1.0;
    float ringAnim = bias(ringAnimBias, 1.0 - ringAnimProgress);
    float ringRadius = lerp(0, 0.5 - ringSoften, ringAnim) * ringRadiusScale;
    float fadeIn = smoothstep(0, ringFadeIn, ringAnimProgress);

    magnitude = smoothstep(ringSoften, 0, length(radius - ringRadius));

    magnitude *= ringAnim * fadeIn;

    float2 result = unlerp(-1.0, 1.0, direction);

    return float4(result, 1.0, magnitude);
}

float4 recolorCircle(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 center = float2(0.5, 0.5);
    float arm = length(IN.Tex.xy - center) * 2;
    float alpha = saturate(recolorColor.a * smoothstep(1, 0, arm));
    return float4(recolorColor.rgb * alpha, alpha);
}

float udRoundBox(float2 p, float2 b, float r)
{
    return length(max(abs(p) - b + r, 0.0)) - r;
}

float4 recolorRectangle(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    const float radius = 0.34645669f;
    const float sharpness = 0.0f;
    
    float2 uv = IN.Tex.xy;
    float2 center = float2(0.5, 0.5);
    
    uv *= recolorAspect.xy;
    center *= recolorAspect.xy;
    
    float b = udRoundBox(uv.xy - center, center, radius);
    float val = smoothstep(0.0, radius, -b);

    float2x2 rot = float2x2(cos(recolorGradientAngle), -sin(recolorGradientAngle), sin(recolorGradientAngle), cos(recolorGradientAngle));
    float2 spunUv = IN.Tex.xy;
    spunUv -= 0.5;
    spunUv = mul(rot, spunUv);
    spunUv += 0.5;
    //val = lerp(val, val*smoothstep(0.0, 0.75, spunUv.x), recolorGradientStrength);
    val *= smoothstep(0.0, 1.0, spunUv.x + (1.0 - recolorGradientStrength));
    float alpha = saturate(recolorColor.a * val);
    return float4(recolorColor.rgb * alpha, alpha);
}

float4 navy(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    return float4(0.085, 0.155, 0.225, 1.0);
}






///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

float4 recolorMix(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorDarken(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = min(under, over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorMultiply(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under * over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorColorBurn(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = 1.0 - (1.0 - under) / over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLinearBurn(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under + over - 1.0;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLighten(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = max(under, over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorScreen(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = 1.0 - (1.0 - under) * (1.0 - over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorColorDodge(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under / (1.0 - over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLinearDodge(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = under + over;
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorOverlay(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (under > 0.5) ? (1.0 - (1.0 - 2.0 * (under - 0.5)) * (1.0 - over)) : ((2.0 * under) * over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorSoftLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (1.0 - (1.0 - under) * (1.0 - (over - 0.5))) : (under * (over + 0.5));
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorHardLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (1.0 - (1.0 - under) * (1.0 - 2.0 * (over - 0.5))) : (under * (2.0 * over));
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorVividLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (1.0 - (1.0 - under) / (2.0 * (over - 0.5))) : (under / (1.0 - 2.0 * over));
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorLinearLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (under + 2.0 * (over - 0.5)) : (under + 2.0 * over - 1.0);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorPinLight(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = (over > 0.5) ? (max(under, 2.0 * (over - 0.5))) : min(under, 2.0 * over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorDifference(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = abs(under - over);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

float4 recolorExclusion(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 uv = IN.Tex;
    uv.y = (ss.y + 0.5) / float(screenHeight);
    uv.x = (ss.x + 0.5) / float(screenWidth);
    float2 aspect = float2(float(screenWidth) / float(screenHeight), 1.0f);

    float4 sceneSample = tex2D(sceneSampler, uv);
    float4 colorSample = tex2D(recolorSampler, uv);
    
    float3 under = sceneSample.rgb;
    float3 over = saturate(colorSample.rgb / colorSample.a);
    
    float3 blended = 0.5 - 2.0 * (under - 0.5) * (over - 0.5);
    blended = saturate(blended);

    return float4(lerp(under, blended, colorSample.a), 1);
}

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

float4 postRenderPS(VS_OUTPUT IN, float4 ss : VPOS) : COLOR
{
    float2 Tex = IN.Tex;
    float blur = 0.01f;

    float2 texSpot = Tex;
    const float dist = 0.13f;
	
    texSpot.y = (ss[1] + 0.5f) / screenHeight;
    texSpot.x = (ss[0] + 0.5f) / screenWidth;
    float2 normTex = texSpot;
	
    float4 sum = tex2D(SamplerP, texSpot);
	
    if (SideWipeIn)
    {
        float swpt = SideWipePerc * 3.0f;
		
        float dLeft = 2.0f - ss[0] / screenWidth;
        float dVert = ss[1] / screenHeight;
        float cMult = dLeft - swpt + cos(dVert * 15. + Time / 100.) / 4.;
        cMult = clamp(cMult, 0., 1.);
        sum *= float4(cMult, cMult, cMult, 1.);
    }
    else if (SideWipeOut)
    {
        float dLeft = ss[0] / screenWidth;
        float dVert = ss[1] / screenHeight;
        float cMult = dLeft - SideWipePerc + 1. + (cos(dVert * 15. + Time / 100.) / 4.);
        cMult = clamp(cMult, 0., 1.);
        sum *= float4(cMult, cMult, cMult, 1.);
    }
	
    if (BlackAndWhiteMode || BlackAndWhiteFade)
    {
		//if (BlackAndWhiteMode) BlackAndWhitePerc = 1.0f;
        float value = (sum[0] + sum[1] + sum[2]) / 3;
		// value = (1-value) * (1-value);
		//BlackAndWhitePerc = -31.0f;
        sum[0] = value * BlackAndWhitePerc + sum[0] * (1.0f - BlackAndWhitePerc);
        sum[1] = value * BlackAndWhitePerc + sum[1] * (1.0f - BlackAndWhitePerc);
        sum[2] = value * BlackAndWhitePerc + sum[2] * (1.0f - BlackAndWhitePerc);
		// color[1] = value;
		// color[2] = value;
    }
	
    return sum;
}

technique TVertexAndPixelShader
{
    pass P0
    {
	
	//	SetBlendState(AlphaBlendingOn, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
        CullMode = none;
    //    VertexShader = compile vs_2_0 VS();
    //    PixelShader  = compile ps_2_0 PS();
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
	//	BlendOp = ADD;
	
    }
    pass P1
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCV();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P2
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P3
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P4
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCVEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P5
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
    pass P6
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P7
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCV();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
	
    pass P8
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P9
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
	
    pass P10
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFCVEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
	
    pass P11
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCSEF();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P12
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSHB();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P13
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFTW();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P14
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 postRenderPS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
	
	//OH SHIT
    pass P15
    {
        CullMode = none;
        VertexShader = compile vs_3_0 PickupVS();
        PixelShader = compile ps_3_0 glowPS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P16
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSClamp();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P17
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSYUV();
        AlphaBlendEnable = FALSE;
		//AlphaTestEnable = TRUE;
        //SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;
    }
    pass P18
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VSUIGlow();
        PixelShader = compile ps_3_0 PSFCV();
		//AlphaBlendEnable = TRUE;
		//AlphaTestEnable = TRUE;
        //SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P19
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 compositePS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P20
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 postProcessBloomPass1();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P21
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 postProcessBloomPass2();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P22
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 postProcessBloomPass2();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
   // pass P22 //Debug gradient
    //{
        //CullMode = none;
       // VertexShader = compile vs_3_0 VS();
      //  PixelShader = compile ps_3_0 debugColorFill();
     //   AlphaBlendEnable = TRUE;
     //   AlphaTestEnable = TRUE;
    //    SrcBlend = SrcAlpha;
   //     DestBlend = InvSrcAlpha;
  //  }
    pass P23 //Distort
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distort();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P24 //Shockwave distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortShockwave();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P25 //Lava distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortLava();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P26 //Navy
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 navy();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P27 //Explosion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 explosion();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P28 //Zap
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 zap();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = One;
        DestBlend = InvSrcAlpha;
    }
    pass P29 //ZapLine
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 zapLinePass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = One;
        DestBlend = InvSrcAlpha;
    }
    pass P30 //Smoke
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 smokePass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P31 //Sparks
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 sparkPass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P32 //Fire ring
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 blastPass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P33 //Simple ring
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 simpleRingPass();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P34 //Ripple distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortRipple();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P35 //Charge distortion
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 distortCharge();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P36 //Recolor circular region
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorCircle();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = InvSrcAlpha;
    }
    pass P37 //Recolor rectangular region
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorRectangle();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = InvSrcAlpha;
    }

    ///////////////////////////////////////
    // BEGIN RIDICULOUS BLEND-MODE BLOCK //
    ///////////////////////////////////////
    pass P38
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorMix();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P39
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorDarken();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P40
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorMultiply();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P41
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorColorBurn();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P42
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLinearBurn();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P43
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLighten();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P44
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorScreen();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P45
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorColorDodge();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P46
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLinearDodge();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P47
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorOverlay();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P48
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorSoftLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P49
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorHardLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P50
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorVividLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P51
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorLinearLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P52
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorPinLight();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P53
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorDifference();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    pass P54
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 recolorExclusion();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = ONE;
        DestBlend = ZERO;
    }
    /////////////////////////////////////
    // END RIDICULOUS BLEND-MODE BLOCK //
    /////////////////////////////////////

    pass P55
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSFont();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P56
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VSLava1();
        PixelShader = compile ps_3_0 PSCS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P57
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VSLava2();
        PixelShader = compile ps_3_0 PSCS();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P58 // CutsceneInterleave
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSYUVInterleave();
        AlphaBlendEnable = FALSE;
        //AlphaTestEnable = TRUE;
        //SrcBlend = SrcAlpha;
        //DestBlend = InvSrcAlpha;
    }
    pass P59 //Distort_Explosion_Batch
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 explosionBatch();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P60 //UI_Pixelize
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSUI();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P61 //UI_LinearSample
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS_UI();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P62 //UI_Add
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS_UI();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = ONE;
    }
    pass P63 //UI_LinearSample_NoClamp
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS_UI_NoClamp();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
    pass P64 //UI_LinearSample_CS
    {
        CullMode = none;
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PSCS_UI();
        AlphaBlendEnable = TRUE;
        AlphaTestEnable = TRUE;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
}
