//--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLOOM


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw








void compositePS()
{
    vec2 uv = v_Tex;
    uv.y = gl_FragCoord.y / float(screenHeight);
    uv.x = gl_FragCoord.x / float(screenWidth);

    vec4 baseImage = texture2D(sceneTexture, uv);
    vec4 blurImage = texture2D(blurTexture, uv);//vec4(uv, 0.0f, bloomSoften)); 
    vec4 blurImage2 = texture2D(blurTexture2, uv);//vec4(uv, 0.0f, bloomSoften)); 
    
    gl_FragColor = additiveBloom(baseImage, blurImage, blurImage2);
}

















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    compositePS();
}
