X  Normal.vert    6   Normal.frag6  16    FCV.vertl  6   FCV.frag  r6    CS.vertl  6   CS.frag  o6    Normal_EF.vertl  6   Normal_EF.frag o6    FCV_EF.vertl  6   FCV_EF.fragF 6   
 CS_EF.vertl  6  
 CS_EF.frag} 6    Normal_Add.vert    6   Normal_Add.frag6  16    FCV_Add.vertl  6   FCV_Add.frag  r6    CS_Add.vertl  6   CS_Add.frag  o6    Normal_EF_Add.vertl  6   Normal_EF_Add.frag o6    FCV_EF_Add.vertl  6   FCV_EF_Add.fragF 6    CS_EF_Add.vertl  6   CS_EF_Add.frag} 6    HB.vert    6   HB.frag w6    FTW.vertl  6   FTW.frag 7    PostRender.vert    6   PostRender.frag! :    Pickup1.vert\ P8   Pickup1.frag ]?    Pickup2.vert    6   Pickup2.fraga  7   
 Cutscene.vert    6  
 Cutscene.fragf p8    CutsceneInterleave.vert    6   CutsceneInterleave.fragC m7    UIGlow.vertM{ V7   UIGlow.frag  r6   
 Finalize.vert 6  
 Finalize.fragc 7    Bloom1.vert 6   Bloom1.fragx  6    Bloom2.vert 6   Bloom2.fragW c6    Distort.vert    6   Distort.frag~ *7    Distort_Shockwave.vert 6   Distort_Shockwave.fragj 7    Distort_Noise.vert"3 7   Distort_Noise.frag6j 9    Distort_Explosion.vert 6   Distort_Explosion.fragģ 7    Distort_Explosion_Batch.vert 6   Distort_Explosion_Batch.frag ]7    Distort_ZapFlash.vert 6   Distort_ZapFlash.frag- o9    Distort_ZapLine.vert 6   Distort_ZapLine.fragK 8    Distort_Smoke.vert 6   Distort_Smoke.frag1 5    Distort_Sparks.vert 6   Distort_Sparks.frag$ 5    Distort_FireRing.vert 6   Distort_FireRing.frag 5    Distort_SimpleRing.vert 6   Distort_SimpleRing.frag
& 6    Distort_Ripple.vert 6   Distort_Ripple.frag\ 08    Distort_Charge.vert 6   Distort_Charge.frag ;   	 Font.vertl  6  	 Font.frag 6   
 Lava1.vert C7  
 Lava1.frag  o6   
 Lava2.vert? 7  
 Lava2.frag  o6    UI_Pixelize.vertl  6   UI_Pixelize.fragv I6    UI_LinearSample.vertl  6   UI_LinearSample.frag K6    UI_Add.vertl  6   UI_Add.frag K6    UI_LinearSample_Noclamp.vertl  6   UI_LinearSample_Noclamp.frag1 `6    UI_LinearSample_CS.vertl  6   UI_LinearSample_CS.frag	 u6       //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VS()
{
	// Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
	v_Spec = vec4(1.0f - a_Norm.x, a_Norm.x, a_Norm.y, a_Norm.z);
	vec2 T = a_Tex.xy;

	// Calculate Position
	mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;
    
    v_Tex = T;
    gl_Position = finalPos;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT
void PS()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color.w = min(color.w, v_Spec.x);

    gl_FragColor = color;
}




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PS();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VS()
{
	// Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
	v_Spec = vec4(1.0f - a_Norm.x, a_Norm.x, a_Norm.y, a_Norm.z);
	vec2 T = a_Tex.xy;

	// Calculate Position
	mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;
    
    v_Tex = T;
    gl_Position = finalPos;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw
void PSFCV()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = FCVD(color);
    
    gl_FragColor = color;
}

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSFCV();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw


void PSCS()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = CSD(color);
    
    gl_FragColor = color;
}























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSCS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything

void PSEF()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = EFD(color);
    
    gl_FragColor = color;
}

//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSEF();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

void PSFCVEF()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = FCVD(color);
    color = EFD(color);
    gl_FragColor = color;
}
























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSFCVEF();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw




void PSCSEF()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = CSD(color);
    color = EFD(color);
    
    gl_FragColor = color;
}





















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSCSEF();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw





void PSHB()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    if (v_Tex[1] > HealthBarPerc)
        discard;
    
    gl_FragColor = color;
}




















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSHB();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything
void PSFTW()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = CSD(color);
    color = FCVD(color);

    color[0] = color[0] * (1.0f - fadeToPerc);
    color[1] = color[1] * (1.0f - fadeToPerc);
    color[2] = color[2] * (1.0f - fadeToPerc);
    
    gl_FragColor = color;
}


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSFTW();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw
























void postRenderPS()
{
    vec2 Tex = v_Tex;

    vec2 texSpot = Tex;
    
    texSpot.y = gl_FragCoord[1] / float(screenHeight);
    texSpot.x = gl_FragCoord[0] / float(screenWidth);
    
    vec4 sum = texture2D(samplerTex1p, texSpot);
    
    if (SideWipeIn != 0)
    {
        float swpt = SideWipePerc * 3.0f;
        
        float dLeft = 2.0f - (gl_FragCoord[0] - 0.5f) / float(screenWidth);
        float dVert = (gl_FragCoord[1] - 0.5f) / float(screenHeight);
        float cMult = dLeft - swpt + cos(dVert * 15.0f + Time / 100.0f) / 4.0f;
        cMult = clamp(cMult, 0.0f, 1.0f);
        sum *= vec4(cMult, cMult, cMult, 1.0f);
    }
    else if (SideWipeOut != 0)
    {
        float dLeft = gl_FragCoord[0] / float(screenWidth);
        float dVert = gl_FragCoord[1] / float(screenHeight);
        float cMult = dLeft - SideWipePerc + 1.0f + (cos(dVert * 15.0f + Time / 100.0f) / 4.0f);
        cMult = clamp(cMult, 0.0f, 1.0f);
        sum *= vec4(cMult, cMult, cMult, 1.0f);
    }
    
    if ((BlackAndWhiteMode != 0) || (BlackAndWhiteFade != 0))
    {
        float value = (sum[0] + sum[1] + sum[2]) / 3.0f;
        sum[0] = value * BlackAndWhitePerc + sum[0] * (1.0f - BlackAndWhitePerc);
        sum[1] = value * BlackAndWhitePerc + sum[1] * (1.0f - BlackAndWhitePerc);
        sum[2] = value * BlackAndWhitePerc + sum[2] * (1.0f - BlackAndWhitePerc);
    }
    
    gl_FragColor = sum;
}

///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    postRenderPS();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_BLUR_VS_OUTPUT
varying vec2 v_Tex0;
varying vec2 v_Tex1;
varying vec2 v_Tex2;
varying vec2 v_Tex3;
varying vec2 v_Tex4;
varying vec2 v_Tex5;
varying vec2 v_Tex6;
varying vec2 v_Tex7;
varying vec2 v_Tex8;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
void PickupVS()
{
    mat4 WorldViewProj = World * View  * Projection;

    v_Tex0 = a_Tex + vec2(         0.0f, 0.0f);
    v_Tex1 = a_Tex + vec2(-pSize * 2.0f * phMult, 0.0f);
    v_Tex2 = a_Tex + vec2(-pSize * 1.0f * phMult, 0.0f);
    v_Tex3 = a_Tex + vec2( pSize * 1.0f * phMult, 0.0f);
    v_Tex4 = a_Tex + vec2( pSize * 2.0f * phMult, 0.0f);
    v_Tex5 = a_Tex + vec2(         0.0f, -pSize * 2.0f * pvMult);
    v_Tex6 = a_Tex + vec2(         0.0f, -pSize * 1.0f * pvMult);
    v_Tex7 = a_Tex + vec2(         0.0f, pSize * 1.0f * pvMult);
    v_Tex8 = a_Tex + vec2(         0.0f, pSize * 2.0f * pvMult);

    gl_Position = vec4(a_Pos, 1) * WorldViewProj;
}
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PickupVS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_BLUR_VS_OUTPUT
varying vec2 v_Tex0;
varying vec2 v_Tex1;
varying vec2 v_Tex2;
varying vec2 v_Tex3;
varying vec2 v_Tex4;
varying vec2 v_Tex5;
varying vec2 v_Tex6;
varying vec2 v_Tex7;
varying vec2 v_Tex8;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT

void glowPS()
{
    vec4 color;
	
	float maxBleed = 0.01f;
	float tx0 = (1.0f - (clamp(abs(v_Tex0.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex0.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    color =  texture2D(blurTexture, v_Tex0) * tx0;
	
	//if (color[3] == 0.0f)
	//{
	vec4 addColor;
	float tx1 = (1.0f - (clamp(abs(v_Tex1.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex1.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
	addColor  = texture2D(blurTexture, v_Tex1) * 0.1f * tx1;
	
	float tx2 = (1.0f - (clamp(abs(v_Tex2.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex2.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += texture2D(blurTexture, v_Tex2) * 0.2f * tx2;
	
	float tx3 = (1.0f - (clamp(abs(v_Tex3.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex3.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += texture2D(blurTexture, v_Tex3) * 0.2f * tx3;
	
	float tx4 = (1.0f - (clamp(abs(v_Tex4.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex4.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += texture2D(blurTexture, v_Tex4) * 0.1f * tx4;
	
	float tx5 = (1.0f - (clamp(abs(v_Tex5.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex5.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
	addColor += texture2D(blurTexture, v_Tex5) * 0.1f * tx5;
	
	float tx6 = (1.0f - (clamp(abs(v_Tex6.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex6.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += texture2D(blurTexture, v_Tex6) * 0.2f * tx6;
	
	float tx7 = (1.0f - (clamp(abs(v_Tex7.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex7.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += texture2D(blurTexture, v_Tex7) * 0.2f * tx7;
	
	float tx8 = (1.0f - (clamp(abs(v_Tex8.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex8.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    addColor += texture2D(blurTexture, v_Tex8) * 0.1f * tx8;
    
    addColor = vec4(pickupGlowColor.xyz, addColor.w);
	addColor.w = clamp(addColor.w, 0.0f, 1.0f);
	
	color += addColor * (1.0f - clamp(color[3], 0.0f, 1.0f));
	//}

	//addColor.xyz += color.xyz * color[3];
	
	gl_FragColor = color;
//	gl_FragColor[0] = 1.0f;
//	gl_FragColor[3] = 1.0f;
}

#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    glowPS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT



void PSClamp()
{
	float maxBleed = 0.01f;
	float tx0 = (1.0f - (clamp(abs(v_Tex.x - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed)) * (1.0f - (clamp(abs(v_Tex.y - 0.5f) - 0.5f, 0.0f, maxBleed) / maxBleed));
    vec4 color =  texture2D(blurTexture, v_Tex) * tx0;
	
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color.w = min(color.w, v_Spec.x);

    gl_FragColor = color;
}

//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSClamp();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT



void PSYUV()
{
    const vec3 offset = vec3(-0.0627451017f, -0.501960814f, -0.501960814f);
    const vec3 Rcoeff = vec3(1.164f, 0.000f, 1.596f);
    const vec3 Gcoeff = vec3(1.164f, -0.391f, -0.813f);
    const vec3 Bcoeff = vec3(1.164f, 2.018f, 0.000f);

    vec3 yuv;
    
#ifdef LANGUAGE_GLSL
    yuv.x = texture2D(samplerTex1, v_Tex).r;
    yuv.y = texture2D(samplerTex2, v_Tex).r;
    yuv.z = texture2D(samplerTex3, v_Tex).r;
#else
    yuv.x = texture2D(samplerTex1, v_Tex).a;
    yuv.y = texture2D(samplerTex2, v_Tex).a;
    yuv.z = texture2D(samplerTex3, v_Tex).a;
#endif //LANGUAGE_GLSL
    
    yuv += offset;
    
    vec4 color;
    color.b = dot(yuv, Rcoeff);
    color.g = dot(yuv, Gcoeff);
    color.r = dot(yuv, Bcoeff);
    color.a = 1.0f;
    
    gl_FragColor = color;
}

//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSYUV();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT



void PSYUVInterleave()
{
    const vec3 offset = vec3(-0.0627451017f, -0.501960814f, -0.501960814f);
    const vec3 Rcoeff = vec3(1.164f, 0.000f, 1.596f);
    const vec3 Gcoeff = vec3(1.164f, -0.391f, -0.813f);
    const vec3 Bcoeff = vec3(1.164f, 2.018f, 0.000f);

    vec3 yuv;
    
    yuv.xyz = texture2D(samplerTex1, v_Tex).xyz;
    
    yuv += offset;
    
    vec4 color;
    color.b = dot(yuv, Rcoeff);
    color.g = dot(yuv, Gcoeff);
    color.r = dot(yuv, Bcoeff);
    color.a = 1.0f;
    
    gl_FragColor = color;
}

//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSYUVInterleave();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VSUIGlow()
{
    mat4 WorldViewProj = World * View * Projection;
    
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
        
    v_Tex = a_Tex;
    v_Spec = vec4(1.0f - a_Norm[0], 0.0f, 0.0f, 0.0f);

    float posX = UIGInfo[2] * UIGPerc * sign(a_Pos[0] - UIGInfo[0]) * float(screenHeight) / 1080.0f;
    float posY = UIGInfo[3] * UIGPerc * sign(a_Pos[1] - UIGInfo[1]) * float(screenHeight) / 1080.0f;
    vec4 pos = vec4(a_Pos[0] + posX, a_Pos[1] + posY, a_Pos[2], 1);
    gl_Position = pos * WorldViewProj;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VSUIGlow();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_BLOOM


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VS()
{
	// Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
	v_Spec = vec4(1.0f - a_Norm.x, a_Norm.x, a_Norm.y, a_Norm.z);
	vec2 T = a_Tex.xy;

	// Calculate Position
	mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;
    
    v_Tex = T;
    gl_Position = finalPos;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLOOM


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw








void compositePS()
{
    vec2 uv = v_Tex;
    uv.y = gl_FragCoord.y / float(screenHeight);
    uv.x = gl_FragCoord.x / float(screenWidth);

    vec4 baseImage = texture2D(sceneTexture, uv);
    vec4 blurImage = texture2D(blurTexture, uv);//vec4(uv, 0.0f, bloomSoften)); 
    vec4 blurImage2 = texture2D(blurTexture2, uv);//vec4(uv, 0.0f, bloomSoften)); 
    
    gl_FragColor = additiveBloom(baseImage, blurImage, blurImage2);
}

















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    compositePS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLOOM


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw









void postProcessBloomPass1()
{
    vec2 uv = v_Tex;
    uv.y = gl_FragCoord.y / float(screenHeight);
    uv.x = gl_FragCoord.x / float(screenWidth);

    float thresh = mix(1.0f, 5.0f, bloomThreshold);
    gl_FragColor = bloomSample(blurTexture, uv, normalize(vec2(1.0f, 1.0f)), bloomRadius, thresh);
}
















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    postProcessBloomPass1();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLOOM


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw










void postProcessBloomPass2()
{
    vec2 uv = v_Tex;
    uv.y = gl_FragCoord.y / float(screenHeight);
    uv.x = gl_FragCoord.x / float(screenWidth);

    gl_FragColor = bloomSample(blurTexture, uv, normalize(vec2(1.0f, -1.0f)), bloomRadius, 1.0f);
}















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    postProcessBloomPass2();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw











void distort()
{
    vec2 uv = v_Tex;
    uv.y = gl_FragCoord.y / float(screenHeight);
    uv.x = gl_FragCoord.x / float(screenWidth);
    vec2 aspect = vec2(float(screenWidth) / float(screenHeight), 1.0f);

    float maxDistortion = 0.05f;
    vec4 offsetSample = texture2D(distortTexture, uv);
    offsetSample.y = 1.0f - offsetSample.y;
    vec2 offsets = (offsetSample.xy * 2.0f - 1.0f) * maxDistortion / aspect;
    gl_FragColor = texture2D(sceneTexture, uv + offsets);
}














///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    distort();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VS()
{
	// Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
	v_Spec = vec4(1.0f - a_Norm.x, a_Norm.x, a_Norm.y, a_Norm.z);
	vec2 T = a_Tex.xy;

	// Calculate Position
	mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;
    
    v_Tex = T;
    gl_Position = finalPos;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VS();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw












void distortShockwave()
{
    vec2 center = vec2(0.5f, 0.5f);
    vec2 loc = v_Tex.xy - center;
    vec2 direction = normalize(loc);
    float radius = length(loc);
    float magnitude;

    float edgeSoften = 0.01f;
    float outerEdge = 0.5f - edgeSoften;
    float innerEdge = 0.392f;

    magnitude = unlerp(innerEdge, outerEdge, radius);
    magnitude = bias(0.1f, magnitude);
    magnitude = mix(magnitude, 0.0f, smoothstep(outerEdge, outerEdge + edgeSoften, radius));

    vec2 result = unlerp(-1.0f, 1.0f, direction);
    gl_FragColor = vec4(result, 1.0f, magnitude);
}













///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    distortShockwave();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_LAVA_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;
varying vec3 v_PosW;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
void VSDistortLava()
{
    // Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
    v_Spec = vec4(1.0f - a_Norm.x, 0, 0, 0);
    vec2 T = a_Tex.xy;

    // Calculate Position
    mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    v_PosW = (vec4(a_Pos.xyz, 1) * World).xyz;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;

    v_Tex = T;
    gl_Position = finalPos;
}
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VSDistortLava();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_LAVA_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;
varying vec3 v_PosW;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT

void distortLava()
{
    float noiseScale = 0.1f;
    float modSpeed = 0.0005f;
    float slideSpeed = 0.0001f;
    float squish = 2.0f;
    float maskScale = 0.6f;
    float strength = 0.04f;

    vec2 uv = v_PosW.xy * noiseScale;
    uv.y *= squish;
    uv.y -= slideSpeed * Time;
    float noise = texture2D(noiseTexture, uv).x;
    
    noise = sin(PI * 2.0f * fmod(noise + Time * modSpeed, 1.0f));

    vec2 direction = normalize(vec2(sin(PI * 2.0f * noise), cos(PI * 2.0f * noise)));

    float magnitude = pow(texture2D(noiseTexture, uv * maskScale).x, 2.0f);

    float topFade = 0.4f;
    float bottomFade = 0.2f;
    float sideFade = 0.05f;
    magnitude *= smoothstep(1.0f, 1.0f - topFade, v_Tex.y);
    magnitude *= smoothstep(0.0f, bottomFade, v_Tex.y);
    magnitude *= smoothstep(0.0f, sideFade, v_Tex.x);
    magnitude *= smoothstep(1.0f, 1.0f - sideFade, v_Tex.x);
    magnitude *= strength;

    direction = unlerp(-1.0f, 1.0f, direction);
    gl_FragColor = vec4(direction, 1.0f, magnitude);
}

#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    distortLava();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw














void explosion()
{
    vec2 uv = v_Tex.xy;
    float rand = random(vec2(vfxRandom, 0.0f));
    vec4 blaast = blast(uv, 0.66f, vfxElapsedTime, rand, 0.21f, 2.0f);
    vec4 smooke = smoke(uv, 0.66f, vfxElapsedTime, rand, 0.0f, 0.7f);
    vec4 spaark = spark(uv, 1.0f, vfxElapsedTime, rand, 0.08125f, 0.9f);
    vec4 final = comp(spaark, comp(blaast, smooke));
    final.rgb *= vfxBlackout;
    gl_FragColor = final;
}











///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    explosion();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw















void explosionBatch()
{
    vec2 uv = v_Tex.xy;
    float vfxRandomBatch = v_Spec.y;
    float vfxElapsedTimeBatch = v_Spec.z;
    float rand = vfxRandomBatch;
    vec4 blaast = blast(uv, 0.66f, vfxElapsedTimeBatch, rand, 0.21f, 2.0f);
    vec4 smooke = smoke(uv, 0.66f, vfxElapsedTimeBatch, rand, 0.0f, 0.7f);
    vec4 spaark = spark(uv, 1.0f, vfxElapsedTimeBatch, rand, 0.08125f, 0.9f);
    vec4 final = comp(spaark, comp(blaast, smooke));
    final.rgb *= vfxBlackout;
    gl_FragColor = final;
}










///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    explosionBatch();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw




















void zap()
{
    float time = vfxElapsedTime / 1000.0f;
    float lifetime = 0.22834645f;
    float progress = unlerp(0.0f, lifetime, time);
    float strength = 1.0f - mod(progress, 0.5f) * 2.0f;
    strength = time > lifetime ? 0.0f : strength;
    strength = bias(0.7244094488188977f, strength);

    float angle = 0.97637795f * (PI * 2.0f * vfxRandom) + step(0.5f, progress) * PI / 4.0f;

    vec4 col = vec4(0.0f, 0.0f, 0.0f, 1.0f);
    col.rgb += zapLine(v_Tex.xy, angle, strength, random(vec2(0.0f, 0.0f)));
    col.rgb += zapLine(v_Tex.xy, angle + PI / 2.0f, strength, random(vec2(0.0f, 1.0f)));
    col.rgb += zapRing(v_Tex.xy, progress, 1.0f);
    col.rgb = saturate(col.rgb);

    vec3 white = vec3(1.0f, 1.0f, 1.0f);
    vec3 black = vec3(0.0f, 0.0f, 0.0f);
    vec3 blue = vec3(0.1f, 0.5f, 1.0f);
    col.a = bias(0.3543307f, col.r);
    col.rgb = mix(mix(black, blue, unlerp(0.0f, 0.5f, col.r)), mix(blue, white, unlerp(0.5f, 1.0f, col.r)), step(0.5f, col.r));
    col.rgb *= vfxBlackout;
    gl_FragColor = col;
}





///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    zap();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw





















void zapLinePass()
{
    float time = vfxElapsedTime / 1000.0f;
    float lifetime = 0.22834645f;
    float progress = unlerp(0.0f, lifetime, time);
    float strength = 1.0f - progress;
    strength = time > lifetime ? 0.0f : strength;
    strength = bias(0.7244094488188977f, strength);

    float rand = random(vec2(vfxRandom, 0.0f));

    vec4 col = vec4(0.0f, 0.0f, 0.0f, 1.0f);
    col.rgb = saturate(zapLine(v_Tex.xy, PI / 2.0f, strength, rand));

    vec3 white = vec3(1.0f, 1.0f, 1.0f);
    vec3 black = vec3(0.0f, 0.0f, 0.0f);
    vec3 blue = vec3(0.1f, 0.5f, 1.0f);
    col.a = bias(0.3543307f, col.r);
    col.rgb = mix(mix(black, blue, unlerp(0.0f, 0.5f, col.r)), mix(blue, white, unlerp(0.5f, 1.0f, col.r)), step(0.5f, col.r));
    col.rgb *= vfxBlackout;
    gl_FragColor = col;
}




///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    zapLinePass();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw


















void smokePass()
{
    float rand = random(vec2(vfxRandom, 0.0f));
    gl_FragColor = smoke(v_Tex.xy, 0.66f, vfxElapsedTime, rand, 0.0f, 0.7f);
}







///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    smokePass();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw



















void sparkPass()
{
    float rand = random(vec2(vfxRandom, 0.0f));
    gl_FragColor = spark(v_Tex.xy, 1.0f, vfxElapsedTime, rand, 0.0f, 0.9f);
}






///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    sparkPass();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

















void blastPass()
{
    float rand = random(vec2(vfxRandom, 0.0f));
    gl_FragColor = blast(v_Tex.xy, 0.66f, vfxElapsedTime, rand, 0.21f, 2.0f);
}








///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    blastPass();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw






















void simpleRingPass()
{
    float time = vfxElapsedTime / 1000.0f;
    float lifetime = 0.22834645f;
    float progress = unlerp(0.0f, lifetime, time);
    vec4 col = vec4(0.0f, 0.0f, 0.0f, 1.0f);
    col.rgb = zapRing(v_Tex.xy, progress, 0.0001);
    col.a = length(col.rgb);
    col.rgb *= vfxBlackout;
    gl_FragColor = col;
}



///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    simpleRingPass();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw













void distortRipple()
{
    vec2 center = vec2(0.5f, 0.5f);
    vec2 loc = v_Tex.xy - center;
    vec2 direction = normalize(loc);
    
    float radius = length(loc);
    float rr = 2.0f;
    direction = (max((rr - (radius - 0.2f) * 5.0f) / rr, 0.0f)) * direction;
    direction.y = 0.0f;
    float magnitude;

    float edgeSoften = 0.01f;
    float outerEdge = 0.5f - edgeSoften;
    float innerEdge = 0.392f;

    magnitude = unlerp(innerEdge, outerEdge, radius);
    magnitude = bias(0.1f, magnitude);
    magnitude = mix(magnitude, 0.0f, smoothstep(outerEdge, outerEdge + edgeSoften, radius));

    vec2 result = unlerp(-1.0f, 1.0f, direction);
    gl_FragColor = vec4(result, 1.0f, magnitude);
}












///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    distortRipple();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_EFFECTS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw























void distortCharge()
{
    const float uvScale         = 0.283464566f;
    const float uvInversionBias = 0.629921258f;
    const float ringSoften      = 0.039370075f;
    const float ringAnimBias    = 0.29921259f;
    const float ringRadiusScale = 0.57480314f;
    const float ringFadeIn      = 0.05511811f;

    vec2 center = vec2(0.5f, 0.5f);
    vec2 loc = v_Tex.xy - center;
    vec2 direction = normalize(loc);

    float radius = length(loc);
    float angle = Time / 1000.0f;
    vec2 texUvA = v_Tex.xy;
    vec2 texUvB = v_Tex.xy;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
    texUvA -= 0.5f;
    texUvB -= 0.5f;
    texUvA /= uvScale * 5.0f;
    texUvB /= uvScale * 7.0f;
    texUvA = rot * texUvA;
    texUvB = texUvB * rot;
    texUvA += 0.5f;
    texUvB += 0.5f;

    float stellate = pow(radius, uvInversionBias);
    texUvA = texUvA / stellate;
    texUvB = texUvB / stellate;
    vec4 texA = texture2D(lumpTexture1, texUvA);
    vec4 texB = texture2D(lumpTexture1, texUvB);

    float magnitude;
    direction *= mix(-1.0f, 1.0f, texA.a * texB.a);

    float ringAnimProgress = mod((vfxElapsedTime / vfxDuration), 1.0f);
    float ringAnim = bias(ringAnimBias, 1.0f - ringAnimProgress);
    float ringRadius = mix(0.0f, 0.5f - ringSoften, ringAnim) * ringRadiusScale;
    float fadeIn = smoothstep(0.0f, ringFadeIn, ringAnimProgress);

    magnitude = smoothstep(ringSoften, 0.0f, length(radius - ringRadius));

    magnitude *= ringAnim * fadeIn;

    vec2 result = unlerp(-1.0f, 1.0f, direction);

    gl_FragColor = vec4(result, 1.0f, magnitude);
}


///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    distortCharge();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT



void PSFont()
{
#ifdef LANGUAGE_GLSL
    float color = texture2D(samplerTex1, v_Tex).r;
#else
    float color = texture2D(samplerTex1, v_Tex).a;
#endif //LANGUAGE_GLSL

#ifdef ALPHA_DISCARD
    if(color <= 0.01f)
        discard;
#endif //ALPHA_DISCARD

    color *= v_Diff.a;

    vec4 color2 = vec4(1.0f, 1.0f, 1.0f, min(color, v_Spec.x));

    color2 = FCVD(color2);

    gl_FragColor = color2;
}

//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSFont();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VSLava1()
{
    // Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
    v_Spec = vec4(1.0f - a_Norm.x, 0, 0, 0);
    vec2 T = a_Tex.xy;

    // Calculate Position
    mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;

    // Apply wave
    finalPos.y += (((cos((gTime / 1000.0f + a_Pos.x / 2.0f) / wavePer) + 1.0f) * waveAmp) * a_Pos.y / maxHeight);
    v_Tex = T;
    
    gl_Position = finalPos;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VSLava1();
}
     //--- HEADER ---//

#version 120

#define LANGUAGE_GLSL
#define VERTEX_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//

attribute vec3 a_Pos;
attribute vec3 a_Norm;
attribute vec2 a_Tex;

#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
void VSLava2()
{
    // Calculate colors
    v_Diff = vec4(fadeColor, fadeColor, fadeColor, fadeAlpha);
    v_Spec = vec4(1.0f - a_Norm.x, 0, 0, 0);
    vec2 T = a_Tex.xy;

    // Calculate Position
    mat4 WorldView = World * View;
    vec4 P = vec4(a_Pos.xyz, 1) * WorldView;
    vec4 finalPos = vec4(P.xyz, 1) * Projection;

    // Apply wave
    finalPos.y += (((cos((gTime / 1000.0f + a_Pos.x / 2.0f) / wavePer) + 1.0f) * waveAmp) * a_Pos.y / maxHeight);
    T.x += fmod(gTime, 20000.0f / waveSpd) / (20000.0f / waveSpd);
    v_Tex = T;
    
    gl_Position = finalPos;
}
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    VSLava2();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT


void PSUI()
{
    vec4 color = texture2D(samplerTex1, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color.w = min(color.w, v_Spec.x);

    gl_FragColor = color;
}


//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSUI();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT

void PS_UI()
{
    vec4 color = texture2D(samplerTex2, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color.w = min(color.w, v_Spec.x);

    gl_FragColor = color;
}



//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PS_UI();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT

void PS_UI_NoClamp()
{
    vec4 color = texture2D(uiNoClampTexture, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color.w = min(color.w, v_Spec.x);

    gl_FragColor = color;
}



//does everything


//does FCV draw

























///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PS_UI_NoClamp();
}
     //--- HEADER ---//

#version 120

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define LANGUAGE_GLSL
#define FRAGMENT_SHADER
#define USE_BLENDS


//--- CONSTANTS ---//

const vec3 lightDir = vec3(0.0f, -1.0f, 0.0f); // light direction (view space)
const float PI = 3.14159265f;


//--- DATA FORMAT ---//


#define varying_VS_OUTPUT
varying vec4 v_Diff;
varying vec4 v_Spec;
varying vec2 v_Tex;


//--- UNIFORMS ---//

uniform mat4 World;
uniform mat4 View;
uniform mat4 Projection;

uniform float wavePer;
uniform float waveAmp;
uniform float waveSpd;
uniform float maxHeight;
uniform float maxWidth;
uniform int screenHeight;
uniform int screenWidth;

uniform float pSize; // pixel size of the texture, equivalent to the inverse of the texture width
uniform float phMult;
uniform float pvMult;

uniform int BlackAndWhiteMode;
uniform int BlackAndWhiteFade;
uniform float BlackAndWhitePerc;

uniform vec2 EnemyFlash;

uniform float Time;
uniform float gTime;

uniform float FCVSat;

uniform int SideWipeIn;
uniform int SideWipeOut;
uniform float SideWipePerc;
uniform float HealthBarPerc;
uniform int HealthBar;
uniform int flipFade;
uniform float fadeToPerc;
uniform vec4 pickupGlowColor;

uniform vec4 FCV;
uniform mat4 ColorShift;

uniform float fadeColor;
uniform float fadeAlpha;
uniform float UIGPerc;
uniform vec4 UIGInfo;

uniform vec2 mousePos;

uniform float bloomRadius;
uniform float bloomThreshold;
uniform float bloomSoften;
uniform float bloomAlpha;
uniform float bloomAlpha2;

uniform float vfxElapsedTime;
uniform float vfxDuration;
uniform float vfxRandom;
uniform float vfxBlackout;

uniform vec4 recolorColor;
uniform vec4 recolorAspect;
uniform float recolorGradientStrength;
uniform float recolorGradientAngle;


//--- SAMPLERS ---//

uniform sampler2D samplerTex1;
uniform sampler2D samplerTex2;
uniform sampler2D samplerTex3;
uniform sampler2D noiseTexture;
uniform sampler2D sceneTexture;
uniform sampler2D blurTexture;
uniform sampler2D blurTexture2;
uniform sampler2D distortTexture;
uniform sampler2D recolorTexture;
uniform sampler2D lumpTexture1;
uniform sampler2D lumpTexture2;
uniform sampler2D samplerTex1p;
uniform sampler2D uiNoClampTexture;


//--- HELPER FUNCTIONS ---//
float trunc(float x)
{
    return x < 0.0f ? -floor(abs(x)) : floor(x);
}
float fmod(float x, float y)
{
    return x - y * trunc(x / y);
}

#ifdef FRAGMENT_SHADER
float unlerp(float min, float max, float t)
{
    return clamp((t - min) / (max - min), 0.0f, 1.0f);
}

vec2 unlerp(float min, float max, vec2 t)
{
    return vec2(unlerp(min, max, t.x), unlerp(min, max, t.y));
}

vec3 unlerp(float min, float max, vec3 t)
{
    return vec3(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z));
}

vec4 unlerp(float min, float max, vec4 t)
{
    return vec4(unlerp(min, max, t.x), unlerp(min, max, t.y), unlerp(min, max, t.z), unlerp(min, max, t.w));
}
float bias(float b, float x)
{
    return x / ((1.0f / b - 2.0f) * (1.0f - x) + 1.0f);
}

#ifdef USE_BLENDS
vec4 FCVD(vec4 cin)
{
    float l = (cin[0] + cin[1] + cin[2]) / 3.0f;
    
    float l2 = (l - 0.5f) * FCVSat;
    l2 = (1.0f - l2);
    l2 = l2 * l2 * l2;
    l = (l2 / 2.0f) + 0.0f;
    l = 1.0f - l;
    
    vec3 c2 = vec3((FCV[3]) * vec3(FCV[0], FCV[1], FCV[2]) + (1.0f - FCV[3]) * vec3(cin[0], cin[1], cin[2]));
    return vec4(c2[0], c2[1], c2[2], cin[3]);
}
vec4 CSD(vec4 cin)
{
    return cin * ColorShift;
}
vec4 EFD(vec4 cin)
{
    return vec4(cin[0], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[1], (EnemyFlash[1]) * (1.0f - EnemyFlash[0]) + (1.0f - EnemyFlash[1]) * cin[2], cin[3]);
}
#endif //USE_BLENDS

#ifdef USE_BLOOM
vec4 additiveBloom(vec4 baseImage, vec4 blurImage, vec4 blurImage2)
{
    return baseImage + 0.5f * (blurImage * bloomAlpha) + (blurImage2 * bloomAlpha2);
}
vec4 maxBloom(vec4 baseImage, vec4 blurImage)
{
    return max(baseImage, blurImage);
}
vec4 bloomSample(sampler2D samplerTex, vec2 uv, vec2 direction, float radius, float threshPower)
{
    vec2 aspect = vec2(1.0, float(screenWidth) / float(screenHeight));
    vec4 sum = vec4(0, 0, 0, 0);
    vec4 threshPowerVec4 = vec4(threshPower, threshPower, threshPower, threshPower);
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -4.0f) * aspect), threshPowerVec4) * 0.0162162f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * -1.0f) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv), threshPowerVec4) * 0.227027f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius) * aspect), threshPowerVec4) * 0.194595f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 2.0f) * aspect), threshPowerVec4) * 0.121622f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 3.0f) * aspect), threshPowerVec4) * 0.0540541f;
    sum += pow(texture2D(samplerTex, uv + (direction * radius * 4.0f) * aspect), threshPowerVec4) * 0.016216f;
    return sum;
}
#endif //USE_BLOOM

#ifdef USE_EFFECTS
float random(vec2 p)
{
    // We need irrationals for pseudo randomness.
    // Most (all?) known transcendental numbers will (generally) work.
    const vec2 r = vec2(
        23.1406926327792690f, // e^pi (Gelfond's constant)
        2.6651441426902251f); // 2^sqrt(2) (Gelfond/Schneider constant)
    return fract(cos(fmod(123456789.0f, 0.0000001f + 256.0f * dot(p, r))));
}
float saturate(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 saturate(vec2 x)
{
    return clamp(x, 0.0, 1.0);
}
vec3 saturate(vec3 x)
{
    return clamp(x, 0.0, 1.0);
}
vec4 saturate(vec4 x)
{
    return clamp(x, 0.0, 1.0);
}
float backOut(float t)
{
    float f = clamp(1.0f - t, 0.000001f, 1.0f); // Look I don't know why okay
    return 1.0f - (pow(f, 1.5f) - f * sin(f * PI));
}
vec4 blast(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float noiseAmount = clamp(mix(0.4f, 0.16f, time - 0.1f), 0.0f, 1.0f);
    float threshold = clamp(mix(1.0f, 0.0f, time - 0.1f), 0.0001f, 1.0f);

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 2.0f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv - rand) * 0.6f).a;

    float baseRadius = 0.3f;
    float bout = abs(backOut(bias(unlerp(0.0f, 0.6f, time), 0.75f)));
    float radius = mix(0.0f, 1.0f, bout) * baseRadius;
    radius += noise2 * mix(0.15f, 0.07f, threshold) * timeStomp;
    float arm = unlerp(0.0f, radius, length(baseUv - 0.5f));
    float power = sqrt(1.0f - (arm * arm));

    float noisyPower = noise * noiseAmount + power * (1.0f - noiseAmount);
    if (noisyPower > threshold)
        power = 0.0f;

    power = unlerp(0.0f, threshold, power);

    float colorPicker = bias(power, noise) - (1.0f - threshold) + power * 0.16f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5)).rgb;
    
    float alpha = 1.0f - step(power, 0.0f);
	
    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 smoke(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float threshold = saturate(mix(0.0f, 1.0f, time - 0.1f));

    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
    vec2 baseUv = uv;
    float minZoom = 1.0f;
    float maxZoom = 1.9f;
    float zoom = 1.0f / mix(minZoom, maxZoom, time);
    uv -= 0.5f;
    uv *= zoom;
    uv += 0.5f;

	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    float slide = time * -0.5f;
    uv.y += slide;

    float noise = texture2D(lumpTexture1, uv + rand).a;
    float noise2 = texture2D(lumpTexture1, (uv + rand) * 0.6).a;

    float colorPicker = noise * (1.0f - threshold) * 0.25f;
    vec3 color = texture2D(lumpTexture2, vec2(colorPicker, 0.5f)).rgb * 0.75f;

    float growthTime = 0.1f;
    float edgeRaggedness = 0.2f;
    float expansion = smoothstep(growthTime, 0.0f, time) / 2.0f;
    float falloff = 1.0f - ((length(baseUv - 0.5f) + (1.0f - noise2) * edgeRaggedness) + expansion) * 2.0f;
    
    float alpha = step(threshold, noise2 * noise * falloff * 2.0f);

    vec4 final = vec4(color, alpha);
    final.rgb *= vfxBlackout;
    return final;
}

vec4 spark(vec2 uv, float scale, float realTime, float rand, float timeOffset, float speed)
{
    float time = (realTime / 1000.0f) * speed - timeOffset;
    float timeStomp = step(0.0f, time);
    float burstPower = time * 0.1f;
    
    uv -= 0.5f;
    uv /= scale;
    uv += 0.5f;
	
	uv = floor((uv + vec2(0.5f, 0.5f)) * 64.0f) / 64.0f; 
	
    vec2 epicenter = uv - 0.5f;
    float r = length(epicenter);
    vec2 burstUv = epicenter * 1.0f / pow(r, mix(1.06f, 2.0f, burstPower)) / mix(0.715f, 0.57f, bias(0.6f, time));

    float threshold = mix(0.682f, 1.2f, bias(0.755f, time));
    float noise = texture2D(lumpTexture1, burstUv - rand).a;
    float limit = 1.0f - (smoothstep(1.8f, 0.531f, r * 2.0f)) - 0.066f * time;
    float alpha = step(threshold + limit, noise) * timeStomp;
    
    vec3 color = texture2D(lumpTexture2, vec2(mix(1.0f, 0.5f, time), 0.5f)).rgb;
    color.rgb *= vfxBlackout;
    return vec4(color, alpha);
}

vec4 comp(vec4 src, vec4 dst)
{
    return mix(src, dst, 1.0f - src.a);
}

vec3 zapLine(vec2 uv, float angle, float strength, float rand)
{
    const float sinFreq = 0.4330708661417323f;
    const float scale = 0.5354330708661418f;
    const float texSpeed = 1.0f;
    const float sinSpeed = 0.1968503937007874f;
    const float taper = 0.28346456692913385f;
    const float timeScale = 1.0f;
    const float bloomPower = 0.007874015748031496f;

    float fatness = 0.023622047244094488f;
    float maxOffset = 0.48031496062992124f;
    float bloomRadius = 0.25196850393700787f;

    maxOffset *= strength;
    fatness *= strength;
    bloomRadius *= bias(0.8740157480314961f, strength);


    vec3 final = vec3(0.0f, 0, 0);
    float time = Time * timeScale;

    vec2 texUv = uv;
    mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

    texUv -= 0.5f;
    texUv = rot * texUv;
    texUv += 0.5f;

    texUv.y += rand;
    texUv.x += time * 0.001f * texSpeed;
    texUv *= 1.0f / mix(1.0f, 3.0f, scale);

    uv -= 0.5f;
    uv = rot * uv;
    uv += 0.5f;

    float bwoopShrink = smoothstep(0.4094488f, 0.0f, strength);
    float bwoop = saturate(bias(taper, 1.0f - mix(0.0f, 1.0f, abs(uv.y - 0.5f) * 2.0f + bwoopShrink)));

    float lumps = texture2D(lumpTexture1, texUv).a;
    float sinOff = (time * 0.001f * sinSpeed) + rand;
    float shift = (lumps - 0.5f) * maxOffset * sin((texUv.y * sinFreq + sinOff) * 100.0f) * bwoop;
    float width = bwoop * fatness;
    float power = 1.0f - smoothstep(width, width + bloomRadius * bwoop, length((uv.x) - (0.5f + shift)));
    power = bias(bloomPower, power);
    final.rgb = vec3(power, power, power);
    return final;
}

vec3 zapRing(vec2 uv, float age, float bloomStomp)
{
    float startRadius = 0.13385826f;
    float endRadius = startRadius + 0.27559055f;
    
    float bloomRadius = mix(0.71653543f, 0.0f, bias(0.13385826f, age));
    float innerRadius = mix(0.0f, endRadius, bias(0.25196850f, age));
    float outerRadius = mix(startRadius, endRadius, bias(0.18110236f, age));
    
    float bloomPower = 0.007874015748031496f * bloomStomp;
    float inner = unlerp(innerRadius - bloomRadius, innerRadius, length(uv - 0.5f));
    float outer = 1.0f - unlerp(outerRadius, outerRadius + bloomRadius, length(uv - 0.5f));
    float power = bias(bloomPower, inner * outer);

    vec3 final = vec3(0.0f, 0.0f, 0.0f);
    final.rgb = vec3(power, power, power);
    return final;
}
#endif //USE_EFFECTS

#endif //FRAGMENT_SHADER

//--- VERTEX SHADERS ---///
#ifdef VERTEX_SHADER

#ifdef varying_VS_OUTPUT
#endif //varying_VS_OUTPUT

#ifdef varying_BLUR_VS_OUTPUT
#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT
#endif //varying_LAVA_VS_OUTPUT

#endif //VERTEX_SHADER

//--- FRAGMENT SHADERS ---///

#ifdef FRAGMENT_SHADER

#ifdef varying_VS_OUTPUT




//does everything


//does FCV draw



void PSCS_UI()
{
    vec4 color = texture2D(samplerTex2, v_Tex);
#ifdef ALPHA_DISCARD
    if(color.a <= 0.01f)
        discard;
#endif //ALPHA_DISCARD
    color *= v_Diff;
    color[3] = min(color[3], v_Spec[0]);
    
    color = CSD(color);
    
    gl_FragColor = color;
}






















///////////////////////////////////////
// BEGIN RIDICULOUS BLEND-MODE BLOCK //
///////////////////////////////////////

#ifdef COMPILE_RECOLOR
















#endif //COMPILE_RECOLOR

#endif //varying_VS_OUTPUT

/////////////////////////////////////
// END RIDICULOUS BLEND-MODE BLOCK //
/////////////////////////////////////

#ifdef varying_BLUR_VS_OUTPUT


#endif //varying_BLUR_VS_OUTPUT

#ifdef varying_LAVA_VS_OUTPUT


#endif //varying_LAVA_VS_OUTPUT

#endif //FRAGMENT_SHADER

//--- MAIN FUNCTION ---//
void main()
{
    PSCS_UI();
}
 