/*
=======================================================================
Cyberpunk 2077 Autohot-Key Script
Version 1.0.0
Author: by JC Denton (PaulDenton on Nexus)
=======================================================================

---------------------------------------------------
standard controls
---------------------------------------------------
pause 			: AHK suspend toggle

You can edit this settings in ini file
located in same folder: cp2077_Keys.ini
---------------------------------------------------
MAP: 		default Key=m
JOURNAL:	default Key=j
---------------------------------------------------
NOTE!
-----
You can edit your own key-mapping in this ini file.
=======================================================================
*/



; -----------------------------------------------------------------------
; Script Start - Settings
; -----------------------------------------------------------------------
#NoEnv						; Recommended for performance and compatibility with future AutoHotkey releases.
#SingleInstance Force
#MaxThreads, 100
#MaxThreadsPerHotkey 2
#MaxHotkeysPerInterval 99999
#KeyHistory 0
ListLines Off
Process, Priority, , H

SetKeyDelay, 30, 50
SetMouseDelay 10

SetWorkingDir %A_ScriptDir%	; Ensures a consistent starting directory.

Menu, Tray, Icon, cp2077_Keys.exe, 4
TrayTip, Autohotkey Cyberpunk 2077, Autohotkey for Game`nCyberpunk 2077, 10, 17

;SetTitleMatchMode RegEx
SetTitleMatchMode 1

SendMode, Event				; Recommended for CP, because better for mouse move


MapWASPressed1rstTime := false
JournalWASPressed1rstTime := false


#IfWinActive Cyberpunk 2077
#Persistent
#InstallKeybdHook
#InstallMouseHook
; -----------------------------------------------------------------------


; -----------------------------------------------------------------------
; Global Settings
; -----------------------------------------------------------------------
; Menu keys
KeyMAP := ""
KeyJOURNAL := ""




; load current configuration from .ini file
; -----------------------------------------
IniFile=%A_WorkingDir%\cp2077_Keys.ini
IfNotExist, %IniFile%
{
    MsgBox, The important ini-file "cp2077_Keys.ini" does not exist!`n`nMust be located in directory:`n%A_WorkingDir%\
	ExitApp 
}

IfExist, %IniFile%  ;Check if ini file exists.
{
	; Quickslot setting
	IniRead, KeyMAP, %IniFile%, MAP-Key, Key
	IniRead, KeyJOURNAL, %IniFile%, JOURNAL-Key, Key

	Gosub Hotkeys
}
; -----------------------------------------------------------------------



;----------- REMAP TO crappy Menu keys - Begin -----------------------
#UseHook On

; Press 'Pause' to temporarily disable the script,
: e.g. for rename Weapons/Armors or console usage.
Pause::Suspend,Toggle

; show win title for develop
;F1::
;    WinGetTitle, current, A
;    MsgBox, % current
;return

; -------------------
; disables the
; right-side Windows key
; -------------------
RWin::return
; -------------------

; -------------------
; disables the console,
; replaced by another hotkey
; -------------------
;^::return
; ------------------





; -------------------------
; MAP_open_close
; -------------------------
map_open_close:

if (JournalWASPressed1rstTime)
{
	; if called, when we are in journal menu
	JournalWASPressed1rstTime := false
	Send {ESC down}	; open
	Sleep, 250
	Send {ESC up}
	Sleep, 150
	Send {ESC down}	; open
	Sleep, 250
	Send {ESC up}
	
	MapWASPressed1rstTime := true
	Send {%KeyMAP% down}	; open
	Sleep, 250
	Send {%KeyMAP% up}
}
else 
{
	; we are in world modus
	if (MapWASPressed1rstTime)
	{
		MapWASPressed1rstTime := false
		Send {ESC down}	; open
		Sleep, 250
		Send {ESC up}
		Sleep, 150
		Send {ESC down}	; open
		Sleep, 250
		Send {ESC up}
	} 	
	else
	{
		MapWASPressed1rstTime := true
		Send {%KeyMAP% down}	; open
		Sleep, 250
		Send {%KeyMAP% up}
	}
}
return
; -------------------------



; -------------------------
; key journal_open_close
; -------------------------
journal_open_close:

if (MapWASPressed1rstTime)
{
	; if called, when we are in party menu
	MapWASPressed1rstTime := false
	Send {ESC down}	; open
	Sleep, 250
	Send {ESC up}
	Sleep, 150
	Send {ESC down}	; open
	Sleep, 250
	Send {ESC up}
	
	JournalWASPressed1rstTime := true
	Send {%KeyJOURNAL% down}	; open
	Sleep, 250
	Send {%KeyJOURNAL% up}
}
else
{
	if (JournalWASPressed1rstTime)
	{
		JournalWASPressed1rstTime := false
		Send {ESC down}	; open
		Sleep, 250
		Send {ESC up}
		Sleep, 150
		Send {ESC down}	; open
		Sleep, 250
		Send {ESC up}
	} 	
	else
	{
		JournalWASPressed1rstTime := true
		Send {%KeyJOURNAL% down}	; open
		Sleep, 250
		Send {%KeyJOURNAL% up}
	}
}	
return
; -------------------------


; -------------------------
; key ESC
; -------------------------
ESC_pressed:

MapWASPressed1rstTime := false
JournalWASPressed1rstTime := false

Send {ESC down}	; open
Sleep, 250
Send {ESC up}
return
; -------------------------

; --------------------------------------------------
#UseHook Off




; ----------------
; HOTKEYS settings
; ----------------
#UseHook On
Hotkeys:

; toggle map menu
if KeyMAP
{
	Hotkey, %KeyMAP%, map_open_close, On
}
else
{
	hotkey, m, map_open_close, On
}
if previousKeyMAP ;Save previous for disabling it when a new key appears
{
	Hotkey, %previousKeyMAP%, map_open_close, Off
}
PreviousKeyMAP := KeyMAP


; toggleJournal menu
if KeyJOURNAL
{
	Hotkey, %KeyJOURNAL%, Journal_open_close, On
}
else
{
	hotkey, j, Journal_open_close, On
}
if previousKeyJOURNAL ;Save previous for disabling it when a new key appears
{
	Hotkey, %previousKeyJOURNAL%, Journal_open_close, Off
}
PreviousKeyJOURNAL := KeyJOURNAL


; ESC reset all vars
hotkey, Esc, ESC_pressed, On

return
; --------------------------------------------------
#UseHook Off
